/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.components.eidtpolicy;

import aurora.ide.meta.gef.editors.components.part.CustomTreeContainerPart;
import aurora.ide.meta.gef.editors.components.part.CustomTreePart;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;

public class TreeExpandSupportEditPolicy
extends GraphicalEditPolicy {
    private boolean expanded = true;
    private Listener l = new Listener();
    public static final String EXPAND_SUPPORT = "EXPAND_SUPPORT";
    public static final String SIZE_CHANGED = "SIZE_CHANGED";

    public EditPart getTargetEditPart(Request request) {
        return super.getTargetEditPart(request);
    }

    private void notifyParent() {
        TreeExpandSupportEditPolicy treeExpandSupportEditPolicy = (TreeExpandSupportEditPolicy)this.getHost().getParent().getEditPolicy((Object)"Expand support");
        if (treeExpandSupportEditPolicy != null) {
            treeExpandSupportEditPolicy.sizeChanged();
        }
    }

    public void activate() {
        super.activate();
        CustomTreeContainerPart host = (CustomTreeContainerPart)this.getHost();
        host.getFigure().addMouseListener((MouseListener)this.l);
    }

    public void sizeChanged() {
        AbstractGraphicalEditPart host = (AbstractGraphicalEditPart)this.getHost();
        IFigure figure = host.getFigure();
        Dimension newSize = this.calculateNewSize(figure);
        figure.setSize(newSize);
        this.notifyParent();
    }

    private Dimension calculateNewSize(IFigure figure) {
        Dimension newSize = new Dimension();
        List children = figure.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure node = (IFigure)children.get(i);
            Dimension nodeSize = node.getSize();
            newSize.width = newSize.width >= nodeSize.width + 15 ? newSize.width : nodeSize.width + 15;
            newSize.height += nodeSize.height;
            ++i;
        }
        newSize.height += 24;
        return newSize;
    }

    public void deactivate() {
        CustomTreeContainerPart host = (CustomTreeContainerPart)this.getHost();
        host.getFigure().removeMouseListener((MouseListener)this.l);
        super.deactivate();
    }

    public Command getCommand(Request request) {
        if ("create child".equals(request.getType())) {
            return new Command("expand"){

                public void execute() {
                    CustomTreeContainerPart host = (CustomTreeContainerPart)TreeExpandSupportEditPolicy.this.getHost();
                    host.getComponent().setPropertyValue("tree_container_expand", (Object)true);
                }
            };
        }
        return null;
    }

    private class Listener
    extends MouseListener.Stub {
        private Listener() {
        }

        public void mousePressed(MouseEvent me) {
            Point location = me.getLocation();
            CustomTreeContainerPart host = (CustomTreeContainerPart)TreeExpandSupportEditPolicy.this.getHost();
            Rectangle bounds = host.getFigure().getBounds();
            if (location.x - bounds.x < 16 && location.y - bounds.y < 16) {
                this.expand();
            }
        }

        public void expand() {
            final CustomTreeContainerPart host = (CustomTreeContainerPart)TreeExpandSupportEditPolicy.this.getHost();
            host.getViewer().getEditDomain().getCommandStack().execute(new Command("expand"){

                public void execute() {
                    AuroraComponent auroraComponent = host.getComponent();
                    boolean bl = !TreeExpandSupportEditPolicy.this.expanded;
                    TreeExpandSupportEditPolicy.this.expanded = bl;
                    auroraComponent.setPropertyValue("tree_container_expand", (Object)bl);
                }
            });
            this.getTreeRoot((EditPart)host).layout();
        }

        private CustomTreePart getTreeRoot(EditPart editPart) {
            EditPart parent = editPart.getParent();
            if (parent instanceof CustomTreePart) {
                return (CustomTreePart)parent;
            }
            return this.getTreeRoot(parent);
        }
    }
}

