/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.components.figure;

import aurora.ide.meta.gef.editors.PrototypeImagesUtils;
import aurora.ide.meta.gef.editors.figures.ColorConstants;
import aurora.ide.meta.gef.editors.figures.ResourceDisposer;
import aurora.ide.meta.gef.util.TextStyleUtil;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Container;
import aurora.plugin.source.gen.screen.model.CustomTree;
import aurora.plugin.source.gen.screen.model.CustomTreeContainerNode;
import aurora.plugin.source.gen.screen.model.StyledStringText;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class TreeNodeFigure
extends Figure {
    private String text;
    private AuroraComponent treeNode;
    private CustomTree tree;
    private static final int IMG_FOLDER = 0;
    private static final int IMG_LEAF = 1;
    private static final int IMG_CHECK = 3;
    private static final int IMG_MINUS_TOP = 4;
    private static final int IMG_MINUS = 5;
    private static final int IMG_MINUS_BOTTOM = 6;
    private static final int IMG_PLUS_TOP = 7;
    private static final int IMG_PLUS = 8;
    private static final int IMG_PLUS_BOTTOM = 9;
    private static final int IMG_JOIN_TOP = 10;
    private static final int IMG_JOIN = 11;
    private static final int IMG_JOIN_BOTTOM = 12;
    private ResourceDisposer disposer = new ResourceDisposer();

    public TreeNodeFigure(AuroraComponent treeNode) {
        this.setTreeNode(treeNode);
    }

    public void refreshVisuals() {
        this.setText(this.getTreeNode().getPrompt());
        this.repaint();
    }

    private void setText(String name) {
        this.text = name;
    }

    private int getNodeLocation() {
        if (this.getTreeNode() != null && this.getTreeNode().getParent() != null) {
            Container parent = this.getTreeNode().getParent();
            List children = parent.getChildren();
            int index = children.indexOf(this.getTreeNode());
            int size = children.size();
            if (size - index == 1) {
                if (parent instanceof CustomTree && index == 0) {
                    return 100;
                }
                return 2;
            }
            if (index == 0) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    protected void paintFigure(Graphics graphics) {
        boolean line;
        Rectangle area = this.getBounds().getShrinked(this.getInsets());
        int x = area.x;
        int nl = this.getNodeLocation();
        Container parent = this.treeNode.getParent();
        if (nl == 0 && !(parent instanceof CustomTree)) {
            nl = 1;
        }
        boolean bl = line = nl != 2 && nl != 100;
        if (nl == 100) {
            nl = 0;
        }
        if (this.isFolder()) {
            if (this.isExpand()) {
                x = this.drawImage(graphics, 4 + nl, x, area.y, 18);
                if (line) {
                    this.drawLine(graphics);
                }
            } else {
                x = this.drawImage(graphics, 7 + nl, x, area.y, 18);
            }
            x = this.drawImage(graphics, 0, x, area.y + 2, 18);
        } else {
            x = this.drawImage(graphics, 10 + nl, x, area.y, 18);
            x = this.drawImage(graphics, 1, x, area.y + 2, 18);
        }
        if (this.isCheckTree()) {
            x = this.drawImage(graphics, 3, x, area.y, 18);
        }
        Rectangle clientArea = this.getClientArea();
        if (!TextStyleUtil.isTextLayoutUseless((AuroraComponent)this.treeNode, (String)"prompt")) {
            this.paintStyledText(graphics, this.getText(), "prompt", x, clientArea.y + 4);
        } else {
            graphics.drawText(this.getText(), x, clientArea.y + 4);
        }
    }

    private int drawImage(Graphics graphics, int img, int x, int y, int img_width) {
        Image image = this.getImage(img);
        if (image != null) {
            graphics.drawImage(image, x, y);
            x += img_width;
        }
        return x;
    }

    private boolean isFolder() {
        return this.getTreeNode() instanceof CustomTreeContainerNode;
    }

    private void drawLine(Graphics graphics) {
        Rectangle area = this.getBounds().getShrinked(this.getInsets());
        if (area.getSize().height > 24) {
            int i = 24;
            while (i < area.height) {
                graphics.drawImage(PrototypeImagesUtils.getImage((String)"tree/line.gif"), area.x, area.y + i);
                i += 24;
            }
        }
    }

    private Image getImage(int type) {
        switch (type) {
            case 0: {
                return PrototypeImagesUtils.getImage((String)"tree/folder.gif");
            }
            case 1: {
                return PrototypeImagesUtils.getImage((String)"tree/leaf.gif");
            }
            case 3: {
                return PrototypeImagesUtils.getImage((String)"tree/checkbox_0.gif");
            }
            case 5: {
                return PrototypeImagesUtils.getImage((String)"tree/minus.gif");
            }
            case 4: {
                return PrototypeImagesUtils.getImage((String)"tree/minustop.gif");
            }
            case 6: {
                return PrototypeImagesUtils.getImage((String)"tree/minusbottom.gif");
            }
            case 8: {
                return PrototypeImagesUtils.getImage((String)"tree/plus.gif");
            }
            case 7: {
                return PrototypeImagesUtils.getImage((String)"tree/plustop.gif");
            }
            case 9: {
                return PrototypeImagesUtils.getImage((String)"tree/plusbottom.gif");
            }
            case 11: {
                return PrototypeImagesUtils.getImage((String)"tree/join.gif");
            }
            case 10: {
                return PrototypeImagesUtils.getImage((String)"tree/jointop.gif");
            }
            case 12: {
                return PrototypeImagesUtils.getImage((String)"tree/joinbottom.gif");
            }
        }
        return null;
    }

    private String getText() {
        return this.text;
    }

    private boolean isCheckTree() {
        CustomTree tree2 = this.getTree();
        if (tree2 == null) {
            return false;
        }
        return tree2.isCheckedTree();
    }

    public boolean isExpand() {
        return this.treeNode.getBooleanPropertyValue("tree_container_expand");
    }

    private CustomTree getTree() {
        if (this.tree == null) {
            this.tree = this.getTree(this.treeNode);
            return this.tree;
        }
        return this.tree;
    }

    private CustomTree getTree(AuroraComponent treeNode) {
        if (treeNode == null) {
            return null;
        }
        Container parent = treeNode.getParent();
        if (parent instanceof CustomTree) {
            return (CustomTree)parent;
        }
        return this.getTree((AuroraComponent)parent);
    }

    public AuroraComponent getTreeNode() {
        return this.treeNode;
    }

    public void setTreeNode(AuroraComponent treeNode) {
        this.treeNode = treeNode;
    }

    protected void paintStyledText(Graphics g, String text, String property_id, int x, int y) {
        g.pushState();
        this.disposer.disposeResource(property_id);
        g.setForegroundColor(ColorConstants.BLACK);
        TextLayout tl = new TextLayout(null);
        tl.setText(text);
        tl.setFont(this.getFont());
        Object obj = this.treeNode.getPropertyValue(String.valueOf(property_id) + "_text_style");
        TextStyle ts = null;
        ts = obj instanceof StyledStringText ? TextStyleUtil.createTextStyle((StyledStringText)((StyledStringText)obj), (Display)Display.getDefault(), (Font)this.getFont()) : new TextStyle();
        tl.setStyle(ts, 0, text.length() - 1);
        if ("prompt".equals(property_id)) {
            g.drawTextLayout(tl, x, y);
        }
        this.disposer.handleResource(property_id, (Resource)tl);
        g.popState();
    }

    public void disposeResource() {
        this.disposer.disposeResource();
        this.disposer = null;
    }

    protected void handleResource(String id, Resource r) {
        this.disposer.handleResource(id, r);
    }

    protected void disposeResource(String prop_id) {
        this.disposer.disposeResource(prop_id);
    }
}

