/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.components.part;

import aurora.ide.libs.AuroraImagesUtils;
import aurora.ide.meta.gef.editors.components.command.ChangeImageCommand;
import aurora.ide.meta.gef.editors.layout.InputFieldLayout;
import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.plugin.source.gen.screen.model.CustomICon;
import java.io.FileNotFoundException;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Shell;

public class CustomIconPart
extends ComponentPart {
    protected IFigure createFigure() {
        ImageFigure inputField = new ImageFigure();
        return inputField;
    }

    public void updateImage() {
        byte[] iconByteData;
        IFigure figure = this.getFigure();
        if (figure instanceof ImageFigure && (iconByteData = AuroraImagesUtils.toBytes((String)this.getModel().getIconByteData())) != null) {
            ImageData idd = AuroraImagesUtils.toImageData((byte[])iconByteData);
            ImageDescriptor id = ImageDescriptor.createFromImageData((ImageData)idd);
            Image image = id.createImage();
            ((ImageFigure)figure).setImage(image);
        }
    }

    protected void refreshVisuals() {
        this.getFigure().setToolTip((IFigure)new Label(this.getModel().getComponentType()));
        IFigure figure = this.getFigure();
        if (figure instanceof ImageFigure) {
            this.updateImage();
        }
        super.refreshVisuals();
    }

    public CustomICon getModel() {
        return (CustomICon)super.getModel();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
    }

    public int getResizeDirection() {
        return 29;
    }

    public Rectangle layout() {
        InputFieldLayout layout = new InputFieldLayout();
        return layout.layout((ComponentPart)this);
    }

    public Command getCommand(Request request) {
        return super.getCommand(request);
    }

    public EditPolicy getEditPolicy(Object key) {
        return super.getEditPolicy(key);
    }

    public void performRequest(Request req) {
        String path;
        if ("open".equals(req.getType()) && (path = AuroraImagesUtils.queryFile((Shell)this.getViewer().getControl().getShell())) != null) {
            try {
                Path p = new Path(path);
                String fileExtension = p.getFileExtension();
                int iconType = AuroraImagesUtils.getIconType((String)fileExtension);
                if (iconType == -1) {
                    return;
                }
                ImageData loadImageData = AuroraImagesUtils.loadImageData((Path)p);
                ChangeImageCommand cic = new ChangeImageCommand(this.getModel(), loadImageData, iconType);
                this.getViewer().getEditDomain().getCommandStack().execute((Command)cic);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        super.performRequest(req);
    }
}

