/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.test;

import aurora.ide.meta.gef.editors.parts.ViewDiagramPart;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

public class CopyAsImageAction
extends SelectionAction {
    public static final String ID = "aurora.ide.meta.gef.editors.actions.CopyAsImageAction";
    private GraphicalEditor editor;

    public CopyAsImageAction(GraphicalEditor part) {
        super((IWorkbenchPart)part);
        this.editor = part;
        this.setId(ID);
        this.setText("Copy As Image");
    }

    public void run() {
        ScalableRootEditPart rootEditPart = (ScalableRootEditPart)this.getViewer().getRootEditPart();
        double zoom = rootEditPart.getZoomManager().getZoom();
        try {
            try {
                IFigure figure = this.getRootFigure(rootEditPart);
                Rectangle rectangle = this.calBounds(figure);
                Image image = new Image((Device)Display.getDefault(), rectangle.width, rectangle.height);
                GC gc = new GC((Drawable)image);
                SWTGraphics graphics = new SWTGraphics(gc);
                figure.paint((Graphics)graphics);
                Clipboard clipboard = new Clipboard(Display.getDefault());
                clipboard.setContents(new Object[]{image.getImageData()}, new Transfer[]{ImageTransfer.getInstance()});
                image.dispose();
                gc.dispose();
            }
            catch (Exception exception) {
                rootEditPart.getZoomManager().setZoom(zoom);
            }
        }
        finally {
            rootEditPart.getZoomManager().setZoom(zoom);
        }
    }

    protected GraphicalViewer getViewer() {
        return (GraphicalViewer)this.editor.getAdapter(GraphicalViewer.class);
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public IFigure getRootFigure(ScalableRootEditPart rootEditPart) {
        Object object;
        List children = rootEditPart.getChildren();
        if (children.size() > 0 && (object = children.get(0)) instanceof ViewDiagramPart) {
            return ((ViewDiagramPart)object).getFigure();
        }
        return rootEditPart.getLayer((Object)"Printable Layers");
    }

    public Rectangle calBounds(IFigure figure) {
        Rectangle r = new Rectangle(0, 0, 0, 0);
        List children = figure.getChildren();
        for (Object object : children) {
            if (!(object instanceof IFigure)) continue;
            Rectangle b = ((IFigure)object).getBounds();
            r.union(b);
        }
        return r.expand(10, 10);
    }
}

