/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.listener;

import aurora.ide.editor.editorInput.PathEditorInput;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DelayedEventsProcessor
implements Listener {
    private ArrayList<String> filesToOpen = new ArrayList(1);

    public DelayedEventsProcessor(Display display) {
        display.addListener(46, (Listener)this);
    }

    public void handleEvent(Event event) {
        String path = event.text;
        if (path == null) {
            return;
        }
        System.out.println("handleEvent adding " + path.toString());
        this.filesToOpen.add(path);
    }

    public void catchUp(Display display) {
        if (this.filesToOpen.isEmpty()) {
            return;
        }
        String[] filePaths = new String[this.filesToOpen.size()];
        this.filesToOpen.toArray(filePaths);
        this.filesToOpen.clear();
        int i = 0;
        while (i < filePaths.length) {
            this.openFile(display, filePaths[i]);
            ++i;
        }
    }

    private void openFile(Display display, final String path) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                DelayedEventsProcessor.this.openFile(path);
            }
        });
    }

    public void openFile(String path) {
        File file = new File(path);
        IEditorInput input = this.createEditorInput(file);
        String editorId = this.getEditorId(file);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        try {
            page.openEditor(input, editorId);
        }
        catch (PartInitException partInitException) {
            String msg = "Error on open of: " + path;
            MessageDialog.open((int)1, (Shell)window.getShell(), (String)"Initial Open", (String)msg, (int)0x10000000);
        }
    }

    private String getEditorId(File file) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbench workbench = window.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(file.getName());
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "aurora.ide.meta.gef.editors.ConsultantVScreenEditor";
    }

    private IEditorInput createEditorInput(File file) {
        Path location = new Path(file.getAbsolutePath());
        PathEditorInput input = new PathEditorInput((IPath)location);
        return input;
    }
}

