/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.product.demonstrate;

import aurora.ide.prototype.consultant.product.demonstrate.Messages;
import aurora.ide.prototype.consultant.product.editor.EditorManager;
import aurora.ide.swt.util.GridLayoutUtil;
import aurora.ide.swt.util.TextField;
import aurora.ide.swt.util.WidgetFactory;
import aurora.plugin.source.gen.screen.model.DemonstrateData;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DemonstrateOpeningPage
extends WizardPage {
    private DemonstrateData data;
    private Button uipButton;
    private Button msgButton;
    private TextField uipField;
    private Text msgText;

    protected DemonstrateOpeningPage(String pageName, String title, ImageDescriptor titleImage, DemonstrateData data) {
        super(pageName, title, titleImage);
        this.setData(data);
        this.setMessage(Messages.DemonstrateOpeningPage_0);
    }

    public void createControl(Composite root) {
        Composite parent = WidgetFactory.composite((Composite)root);
        parent.setLayout((Layout)GridLayoutUtil.COLUMN_LAYOUT_1);
        this.uipButton = new Button(parent, 16);
        this.uipButton.setText(Messages.DemonstrateOpeningPage_1);
        Composite p = WidgetFactory.composite((Composite)parent);
        p.setLayout((Layout)GridLayoutUtil.COLUMN_LAYOUT_3);
        p.setLayoutData((Object)new GridData(768));
        this.uipField = WidgetFactory.createTextButtonField((Composite)p, (String)"UIP", (String)Messages.DemonstrateOpeningPage_3);
        WidgetFactory.hSeparator((Composite)parent).setLayoutData((Object)new GridData(768));
        this.msgButton = new Button(parent, 16);
        this.msgButton.setText(Messages.DemonstrateOpeningPage_4);
        GridData gd = new GridData(1808);
        this.msgText = new Text(parent, 2050);
        this.msgText.setLayoutData((Object)gd);
        this.setControl((Control)parent);
        this.makeListener();
        this.init();
    }

    private void makeListener() {
        this.msgButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DemonstrateOpeningPage.this.getData().setOpenType("open_message");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.uipButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DemonstrateOpeningPage.this.getData().setOpenType("open_type_uip");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.msgText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DemonstrateOpeningPage.this.getData().setOpenMessage(DemonstrateOpeningPage.this.msgText.getText());
            }
        });
        this.uipField.addButtonClickListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String queryFile = DemonstrateOpeningPage.this.queryFile();
                if (queryFile != null) {
                    IPath afp = EditorManager.getActiveEditorFile();
                    Path p = new Path(queryFile);
                    IPath makeRelativeTo = p.makeRelativeTo(afp);
                    DemonstrateOpeningPage.this.uipField.setText(makeRelativeTo.toString());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.uipField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DemonstrateOpeningPage.this.getData().setOpenUIPPath(DemonstrateOpeningPage.this.uipField.getText().getText());
            }
        });
    }

    private String queryFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText("Open File");
        dialog.setFilterExtensions(new String[]{"*.uip"});
        String path = dialog.open();
        if (path != null && path.length() > 0) {
            return path;
        }
        return null;
    }

    private void init() {
        String msg;
        String openUIPPath;
        String openType = this.getData().getOpenType();
        if ("open_message".equals(openType)) {
            this.msgButton.setSelection(true);
        }
        if ("open_type_uip".equals(openType)) {
            this.uipButton.setSelection(true);
        }
        if ((openUIPPath = this.getData().getOpenUIPPath()) != null) {
            this.uipField.setText(openUIPPath);
        }
        if ((msg = this.getData().getOpenMessage()) != null) {
            this.msgText.setText(msg);
        }
    }

    public DemonstrateData getData() {
        return this.data;
    }

    public void setData(DemonstrateData data) {
        this.data = data;
    }
}

