/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.product.fsd;

import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.meta.gef.editors.EditorMode;
import aurora.ide.meta.gef.editors.parts.ExtAuroraPartFactory;
import aurora.ide.meta.gef.editors.parts.ViewDiagramPart;
import aurora.ide.meta.gef.util.MessageUtil;
import aurora.ide.prototype.consultant.product.fsd.FSDDocumentPackage;
import aurora.ide.prototype.consultant.product.fsd.Messages;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Button;
import aurora.plugin.source.gen.screen.model.Container;
import aurora.plugin.source.gen.screen.model.GridColumn;
import aurora.plugin.source.gen.screen.model.IDatasetFieldDelegate;
import aurora.plugin.source.gen.screen.model.Input;
import aurora.plugin.source.gen.screen.model.ScreenBody;
import aurora.plugin.source.gen.screen.model.TabFolder;
import aurora.plugin.source.gen.screen.model.TabItem;
import aurora.plugin.source.gen.screen.model.io.CompositeMap2Object;
import aurora.plugin.source.gen.screen.model.io.Object2CompositeMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.docx4j.XmlUtils;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.utils.BufferUtil;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.R;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.ui.palette.DefaultPaletteViewerPreferences;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.pptx4j.pml.ObjectFactory;
import uncertain.composite.CompositeMap;

public class BlockedContentPage {
    private FSDDocumentPackage doc;
    private WordprocessingMLPackage wordMLPackage;
    private org.docx4j.wml.ObjectFactory objectFactory = new org.docx4j.wml.ObjectFactory();
    private List<String> files;
    private boolean isOnlyLogic = false;

    public BlockedContentPage(FSDDocumentPackage doc, List<String> files) {
        this.doc = doc;
        this.wordMLPackage = doc.getWordMLPackage();
        this.files = files;
    }

    public void create() {
        MainDocumentPart mdp = this.doc.getMainDocumentPart();
        for (String file : this.files) {
            this.createContent(file);
        }
        mdp.addStyledParagraphOfText("3", Messages.ContentPage_4);
        mdp.addParagraphOfText("");
        mdp.addParagraphOfText("");
        mdp.addStyledParagraphOfText("3", Messages.ContentPage_8);
        mdp.addParagraphOfText("");
        mdp.addParagraphOfText("");
        mdp.getContent().add(this.createTbl("aurora/ide/meta/docx4j/docx/sample/sys_msg_table.xml"));
        mdp.addParagraphOfText("");
        mdp.addStyledParagraphOfText("3", Messages.ContentPage_13);
        mdp.addParagraphOfText("");
        mdp.addParagraphOfText("");
    }

    private void createContent(String file) {
        ScreenBody screenBody = this.loadFile(file);
        MainDocumentPart mdp = this.doc.getMainDocumentPart();
        mdp.addStyledParagraphOfText("3", String.valueOf(screenBody.getStringPropertyValue("fsd_page_name")) + Messages.ContentPage_1 + " : ");
        mdp.addParagraphOfText("");
        this.updateTabSelectCurrent(screenBody);
        try {
            mdp.getContent().add(this.newImage(this.wordMLPackage, (Part)mdp, BufferUtil.getBytesFromInputStream((InputStream)this.createImageInputStream(screenBody)), "www.hand-china.com", "www.hand-china.com", 1, 2));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        mdp.addParagraphOfText(screenBody.getStringPropertyValue("fsd_page_desc"));
        this.createContentInfo(mdp, (Container)screenBody);
        List<AuroraComponent> buttons = this.getFSDOperation((Container)screenBody);
        this.createButtonsContent(mdp, buttons);
        this.createTabContent(screenBody);
    }

    private void updateTabSelectCurrent(ScreenBody screenBody) {
        boolean hasTab = this.hasTab((Container)screenBody);
        if (hasTab) {
            List<TabFolder> tabs = this.getTabs((Container)screenBody);
            for (TabFolder tabFolder : tabs) {
                ArrayList tabItems = tabFolder.getTabItems();
                if (tabItems.size() <= 0) continue;
                ((TabItem)tabItems.get(0)).setCurrent(true);
            }
        }
    }

    public void createContentInfo(MainDocumentPart mdp, Container container) {
        List<AuroraComponent> inputs = this.getFSDTypeComponent(container, "fsd_input");
        if ("fsd_grid".equals(container.getPropertyValue("fsd_component_type"))) {
            inputs = this.ifGridColumnComponent(inputs);
        }
        this.createInputFSD(mdp, container, inputs);
        if ("fsd_grid".equals(container.getPropertyValue("fsd_component_type"))) {
            List<AuroraComponent> buttons = this.getButtons(container);
            this.createButtonsContent(mdp, buttons);
        }
        List<AuroraComponent> containers = this.getFSDTypeContainer_Grid(container);
        for (AuroraComponent ac : containers) {
            this.createContentInfo(mdp, (Container)ac);
        }
    }

    private List<AuroraComponent> getFSDTypeContainer_Grid(Container container) {
        List children = container.getChildren();
        ArrayList<AuroraComponent> result = new ArrayList<AuroraComponent>();
        for (AuroraComponent ac : children) {
            Object propertyValue = ac.getPropertyValue("fsd_component_type");
            if ("fsd_container".equals(propertyValue) || "fsd_grid".equals(propertyValue)) {
                result.add(ac);
            }
            if (!"fsd_none_type".equals(propertyValue) || !(ac instanceof Container)) continue;
            result.addAll(this.getFSDTypeContainer_Grid((Container)ac));
        }
        return result;
    }

    protected void createInputFSD(MainDocumentPart mdp, Container container, List<AuroraComponent> inputs) {
        List<AuroraComponent> cs = inputs;
        if (cs.size() == 0) {
            return;
        }
        String container_desc = container.getStringPropertyValue("fsd_desc");
        container_desc = container_desc == null || "".equals(container_desc) ? container.getPrompt() : container_desc;
        container_desc = container_desc == null || "".equals(container_desc) ? container.getStringPropertyValue("title") : container_desc;
        mdp.addStyledParagraphOfText("3", String.valueOf(container_desc) + Messages.ContentPage_9);
        this.createContentTbl(cs);
        mdp.addParagraphOfText("");
        mdp.addStyledParagraphOfText("3", String.valueOf(container_desc) + Messages.ContentPage_11);
        this.createNoteInfo(cs);
        mdp.addParagraphOfText("");
    }

    public List<AuroraComponent> ifGridColumnComponent(List<AuroraComponent> inputs) {
        ArrayList<AuroraComponent> result = new ArrayList<AuroraComponent>();
        for (AuroraComponent i : inputs) {
            result.add(i);
            if (!"gridcolumn".equals(i.getComponentType())) continue;
            GridColumn gc = (GridColumn)i;
            result.addAll(this.ifGridColumnComponent(gc.getChildren()));
        }
        return result;
    }

    public List<AuroraComponent> getFSDTypeComponent(Container container, String type) {
        List children = container.getChildren();
        ArrayList<AuroraComponent> result = new ArrayList<AuroraComponent>();
        for (AuroraComponent ac : children) {
            if (type.equals(ac.getPropertyValue("fsd_component_type"))) {
                result.add(ac);
            }
            if (!"fsd_none_type".equals(ac.getPropertyValue("fsd_component_type")) || !(ac instanceof Container)) continue;
            result.addAll(this.getFSDTypeComponent((Container)ac, type));
        }
        return result;
    }

    private void createTabContent(ScreenBody screenBody) {
        List<TabFolder> tabs = this.getTabs((Container)screenBody);
        MainDocumentPart mdp = this.doc.getMainDocumentPart();
        for (TabFolder tabFolder : tabs) {
            ArrayList tabItems = tabFolder.getTabItems();
            for (TabItem c : tabItems) {
                boolean current = c.isCurrent();
                System.out.println(current);
                ScreenBody sb = this.createNewTab(c);
                mdp.addStyledParagraphOfText("3", String.valueOf(c.getPrompt()) + "Tab : ");
                mdp.addParagraphOfText("");
                try {
                    mdp.getContent().add(this.newImage(this.wordMLPackage, (Part)mdp, BufferUtil.getBytesFromInputStream((InputStream)this.createImageInputStream(sb)), "www.hand-china.com", "www.hand-china.com", 1, 2));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.createContentInfo(mdp, (Container)c);
                List<AuroraComponent> buttons = this.getFSDOperation((Container)c);
                this.createButtonsContent(mdp, buttons);
            }
        }
    }

    private ScreenBody createNewTab(TabItem tab) {
        ScreenBody sb = new ScreenBody();
        TabFolder tf = new TabFolder();
        AuroraComponent cloneObject = this.cloneObject((AuroraComponent)tab);
        tf.addChild(cloneObject);
        sb.addChild((AuroraComponent)tf);
        return sb;
    }

    private AuroraComponent cloneObject(AuroraComponent ac) {
        Object2CompositeMap o2c = new Object2CompositeMap();
        CompositeMap map = o2c.createCompositeMap(ac);
        CompositeMap2Object c2o = new CompositeMap2Object();
        AuroraComponent createObject = c2o.createObject(map);
        return createObject;
    }

    private List<TabFolder> getTabs(Container screenBody) {
        ArrayList<TabFolder> tfs = new ArrayList<TabFolder>();
        List children = screenBody.getChildren();
        for (AuroraComponent ac : children) {
            if ("tabPanel".equals(ac.getComponentType())) {
                tfs.add((TabFolder)ac);
            } else if (ac instanceof Container && this.hasTab((Container)ac)) {
                tfs.addAll(this.getTabs((Container)ac));
            }
            if (!"tabPanel".equals(ac.getComponentType())) continue;
            ArrayList tabItems = ((TabFolder)ac).getTabItems();
            for (TabItem c : tabItems) {
                if (!this.hasTab((Container)c)) continue;
                tfs.addAll(this.getTabs((Container)c));
            }
        }
        return tfs;
    }

    public void createButtonsContent(MainDocumentPart mdp, List<AuroraComponent> buttons) {
        if (buttons.size() > 0) {
            mdp.addStyledParagraphOfText("3", Messages.ContentPage_22);
        }
        int i = 0;
        while (i < buttons.size()) {
            AuroraComponent b = buttons.get(i);
            if (b instanceof Button) {
                Button bb = (Button)b;
                mdp.addParagraphOfText(i + 1 + ".  " + MessageUtil.getButtonText((Button)bb) + " :  " + b.getStringPropertyValue("fsd_desc"));
            }
            ++i;
        }
    }

    private List<AuroraComponent> getButtons(Container container) {
        List children = container.getChildren();
        ArrayList<AuroraComponent> r = new ArrayList<AuroraComponent>();
        for (AuroraComponent ac : children) {
            if (ac instanceof Button) {
                r.add((AuroraComponent)((Button)ac));
            }
            if (!(ac instanceof Container)) continue;
            r.addAll(this.getButtons((Container)ac));
        }
        return r;
    }

    private List<AuroraComponent> getFSDOperation(Container container) {
        List children = container.getChildren();
        ArrayList<AuroraComponent> r = new ArrayList<AuroraComponent>();
        for (AuroraComponent ac : children) {
            if ("toolbar".equals(ac.getParent().getComponentType())) continue;
            if ("fsd_operation".equals(ac.getPropertyValue("fsd_component_type"))) {
                r.add(ac);
            }
            if ("fsd_tab".equals(ac.getPropertyValue("fsd_component_type")) || !(ac instanceof Container)) continue;
            r.addAll(this.getFSDOperation((Container)ac));
        }
        return r;
    }

    private boolean hasTab(Container container) {
        List children = container.getChildren();
        for (AuroraComponent ac : children) {
            if ("tabPanel".equals(ac.getComponentType())) {
                return true;
            }
            if (!(ac instanceof Container) || !this.hasTab((Container)ac)) continue;
            return true;
        }
        return false;
    }

    private boolean hasTabInTab(Container container) {
        List children = container.getChildren();
        for (AuroraComponent ac : children) {
            if ("tabPanel".equals(ac.getComponentType()) && this.hasTabInTab((TabFolder)ac)) {
                return true;
            }
            if (!(ac instanceof Container) || !this.hasTabInTab((Container)ac)) continue;
            return true;
        }
        return false;
    }

    private boolean hasTabInTab(TabFolder container) {
        ArrayList tabItems = container.getTabItems();
        for (TabItem c : tabItems) {
            if (!this.hasTab((Container)c)) continue;
            return true;
        }
        return false;
    }

    private List<AuroraComponent> getAllChildren(Container container) {
        ArrayList<AuroraComponent> r = new ArrayList<AuroraComponent>();
        List children = container.getChildren();
        for (AuroraComponent ac : children) {
            if (ac instanceof Container) {
                if ("gridcolumn".equals(ac.getComponentType()) && ((Container)ac).getChildren().size() == 0) {
                    r.add(ac);
                    continue;
                }
                r.addAll(this.getAllChildren((Container)ac));
                continue;
            }
            if (!(ac instanceof Input)) continue;
            r.add(ac);
        }
        return r;
    }

    private List<AuroraComponent> getNoTabAllChildren(Container container) {
        ArrayList<AuroraComponent> r = new ArrayList<AuroraComponent>();
        List children = container.getChildren();
        for (AuroraComponent ac : children) {
            if (ac instanceof Container && !"tabPanel".equals(ac.getComponentType())) {
                if ("gridcolumn".equals(ac.getComponentType()) && ((Container)ac).getChildren().size() == 0) {
                    r.add(ac);
                    continue;
                }
                r.addAll(this.getNoTabAllChildren((Container)ac));
                continue;
            }
            if (!(ac instanceof Input)) continue;
            r.add(ac);
        }
        return r;
    }

    private List<Container> getNoTabContainer(List<AuroraComponent> children) {
        ArrayList<Container> r = new ArrayList<Container>();
        for (AuroraComponent ac : children) {
            if (!(ac instanceof Container) || "tabPanel".equals(ac.getComponentType())) continue;
            r.add((Container)ac);
        }
        return r;
    }

    private List<Container> getContainerChildren(List<AuroraComponent> children) {
        ArrayList<Container> r = new ArrayList<Container>();
        for (AuroraComponent ac : children) {
            if (!(ac instanceof Container)) continue;
            r.add((Container)ac);
        }
        return r;
    }

    private void createContentTbl(List<AuroraComponent> childs) {
        if (childs.size() == 0) {
            return;
        }
        MainDocumentPart mdp = this.doc.getMainDocumentPart();
        Tbl createTbl = this.createTbl("aurora/ide/meta/docx4j/docx/sample/content_table.xml");
        int i = 0;
        while (i < childs.size()) {
            createTbl.getContent().add(this.createTr(childs.get(i), i + 1));
            ++i;
        }
        mdp.getContent().add(createTbl);
    }

    public void createNoteInfo(List<AuroraComponent> childs) {
        if (childs.size() == 0) {
            return;
        }
        if (this.isOnlyLogic) {
            this.createSampleNoteInfo(childs);
            return;
        }
        MainDocumentPart mdp = this.doc.getMainDocumentPart();
        int i = 0;
        while (i < childs.size()) {
            AuroraComponent auroraComponent = childs.get(i);
            mdp.addStyledParagraphOfText("contentInfoHead", "Note" + (i + 1) + ":" + auroraComponent.getPrompt());
            mdp.addStyledParagraphOfText("contentInfo", String.valueOf(Messages.ContentPage_31) + auroraComponent.getStringPropertyValue("fsd_meaning"));
            mdp.addStyledParagraphOfText("contentInfo", String.valueOf(Messages.ContentPage_33) + auroraComponent.getStringPropertyValue("fsd_data_from"));
            mdp.addStyledParagraphOfText("contentInfo", String.valueOf(Messages.ContentPage_35) + auroraComponent.getStringPropertyValue("fsd_logic"));
            ++i;
        }
    }

    public void createSampleNoteInfo(List<AuroraComponent> childs) {
        if (childs.size() == 0) {
            return;
        }
        MainDocumentPart mdp = this.doc.getMainDocumentPart();
        int i = 0;
        while (i < childs.size()) {
            AuroraComponent auroraComponent = childs.get(i);
            mdp.addStyledParagraphOfText("contentInfoHead", "Note" + (i + 1) + ":" + auroraComponent.getPrompt());
            mdp.addStyledParagraphOfText("contentInfo", String.valueOf(Messages.ContentPage_35) + auroraComponent.getStringPropertyValue("fsd_logic"));
            ++i;
        }
    }

    private List<AuroraComponent> getNoContainerChildren(List<AuroraComponent> children) {
        ArrayList<AuroraComponent> r = new ArrayList<AuroraComponent>();
        for (AuroraComponent ac : children) {
            if (ac instanceof Container || !(ac instanceof Input) && !"gridcolumn".equals(ac.getComponentType())) continue;
            r.add(ac);
        }
        return r;
    }

    private ScreenBody loadFile(String file) {
        ScreenBody diagram = null;
        CompositeMap loadFile = CompositeMapUtil.loadFile((File)new File(file));
        if (loadFile != null) {
            CompositeMap2Object c2o = new CompositeMap2Object();
            diagram = c2o.createScreenBody(loadFile);
        } else {
            diagram = new ScreenBody();
        }
        return diagram;
    }

    private Tr createTr(AuroraComponent ac, int i) {
        Tr tr = this.objectFactory.createTr();
        Tc tc = this.objectFactory.createTc();
        tc.getContent().add(this.wordMLPackage.getMainDocumentPart().createStyledParagraphOfText("contentTable", "" + i));
        tr.getContent().add(tc);
        tc = this.objectFactory.createTc();
        tc.getContent().add(this.wordMLPackage.getMainDocumentPart().createStyledParagraphOfText("contentTable", this.getFieldDesc(ac)));
        tr.getContent().add(tc);
        tc = this.objectFactory.createTc();
        tc.getContent().add(this.wordMLPackage.getMainDocumentPart().createStyledParagraphOfText("contentTable", this.getType(ac)));
        tr.getContent().add(tc);
        tc = this.objectFactory.createTc();
        tc.getContent().add(this.wordMLPackage.getMainDocumentPart().createStyledParagraphOfText("contentTable", "30"));
        tr.getContent().add(tc);
        tc = this.objectFactory.createTc();
        tc.getContent().add(this.wordMLPackage.getMainDocumentPart().createStyledParagraphOfText("contentTable", this.getFormat(ac)));
        tr.getContent().add(tc);
        tc = this.objectFactory.createTc();
        tc.getContent().add(this.wordMLPackage.getMainDocumentPart().createStyledParagraphOfText("contentTable", this.getMustInput(ac)));
        tr.getContent().add(tc);
        tc = this.objectFactory.createTc();
        tc.getContent().add(this.wordMLPackage.getMainDocumentPart().createStyledParagraphOfText("contentTable", this.getDefaultValue(ac)));
        tr.getContent().add(tc);
        tc = this.objectFactory.createTc();
        tc.getContent().add(this.wordMLPackage.getMainDocumentPart().createStyledParagraphOfText("contentTable", "Note" + i));
        tr.getContent().add(tc);
        return tr;
    }

    private String getFieldDesc(AuroraComponent ac) {
        if ("radio_item".equals(ac.getComponentType())) {
            return ac.getStringPropertyValue("text");
        }
        return ac.getPrompt();
    }

    private String getDefaultValue(AuroraComponent ac) {
        if (ac instanceof IDatasetFieldDelegate) {
            String v = ((IDatasetFieldDelegate)ac).getDatasetField().getDefaultValue();
            if (v == null || "".equals(v)) {
                return "N/A";
            }
            return "" + ((IDatasetFieldDelegate)ac).getDatasetField().isRequired();
        }
        return "N/A";
    }

    private String getMustInput(AuroraComponent ac) {
        if (ac instanceof IDatasetFieldDelegate) {
            return ("" + ((IDatasetFieldDelegate)ac).getDatasetField().isRequired()).toUpperCase();
        }
        return "false".toUpperCase();
    }

    private String getFormat(AuroraComponent ac) {
        if (ac instanceof Input) {
            return ac.getComponentType().toUpperCase();
        }
        if ("gridcolumn".equals(ac.getComponentType())) {
            GridColumn gc = (GridColumn)ac;
            return gc.getEditor().toUpperCase();
        }
        return "TEXT";
    }

    private String getType(AuroraComponent ac) {
        String type = ac.getComponentType();
        if ("datePicker".equals(type) || "dateTimePicker".equals(type)) {
            return "DATE";
        }
        if ("numberField".equals(type)) {
            return "NUM";
        }
        if ("gridcolumn".equals(type)) {
            GridColumn gc = (GridColumn)ac;
            type = gc.getEditor();
            if ("datePicker".equals(type) || "dateTimePicker".equals(type)) {
                return "DATE";
            }
            if ("numberField".equals(type)) {
                return "NUM";
            }
        }
        return "VC";
    }

    protected void createTc(Tbl tbl, int row, int cols, String content) {
        Tc tc = (Tc)((Tr)tbl.getContent().get(row)).getContent().get(cols);
        tc.getContent().clear();
        tc.getContent().add(this.wordMLPackage.getMainDocumentPart().createStyledParagraphOfText("DocInfoTable", content));
    }

    protected Tbl createTbl(String path) {
        InputStream is = null;
        try {
            is = ResourceUtils.getResource((String)path);
            Tbl tbl = (Tbl)XmlUtils.unmarshal((InputStream)is);
            return tbl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return null;
    }

    public InputStream createImageInputStream(ScreenBody diagram) {
        ScrollingGraphicalViewer viewer = new ScrollingGraphicalViewer();
        ScalableRootEditPart root = new ScalableRootEditPart();
        viewer.setRootEditPart((RootEditPart)root);
        viewer.setEditPartFactory((EditPartFactory)new ExtAuroraPartFactory(new EditorMode(){

            public String getMode() {
                return "None";
            }

            public boolean isForDisplay() {
                return false;
            }

            public boolean isForCreate() {
                return true;
            }

            public boolean isForUpdate() {
                return true;
            }

            public boolean isForSearch() {
                return false;
            }
        }));
        viewer.setContents((Object)diagram);
        Font font = new Font((Device)Display.getCurrent(), new DefaultPaletteViewerPreferences().getFontData());
        IFigure figure = root.getFigure();
        figure.setFont(font);
        figure.validate();
        InputStream is = this.createImageInputStream((ScalableRootEditPart)viewer.getRootEditPart());
        font.dispose();
        return is;
    }

    public InputStream createImageInputStream(ScalableRootEditPart rootEditPart) {
        double zoom = rootEditPart.getZoomManager().getZoom();
        try {
            IFigure figure = this.getRootFigure(rootEditPart);
            Rectangle rectangle = this.calBounds(figure);
            Image image = new Image((Device)Display.getDefault(), rectangle.width, rectangle.height);
            GC gc = new GC((Drawable)image);
            SWTGraphics graphics = new SWTGraphics(gc);
            figure.paint((Graphics)graphics);
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{image.getImageData()};
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            loader.save((OutputStream)baos, 5);
            ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
            image.dispose();
            gc.dispose();
            ByteArrayInputStream byteArrayInputStream = is;
            return byteArrayInputStream;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            rootEditPart.getZoomManager().setZoom(zoom);
        }
        return null;
    }

    public IFigure getRootFigure(ScalableRootEditPart rootEditPart) {
        Object object;
        List children = rootEditPart.getChildren();
        if (children.size() > 0 && (object = children.get(0)) instanceof ViewDiagramPart) {
            return ((ViewDiagramPart)object).getFigure();
        }
        return rootEditPart.getLayer((Object)"Printable Layers");
    }

    public Rectangle calBounds(IFigure figure) {
        Rectangle r = new Rectangle(0, 0, 0, 0);
        List children = figure.getChildren();
        for (Object object : children) {
            if (!(object instanceof IFigure)) continue;
            Rectangle b = ((IFigure)object).getBounds();
            r.union(b);
        }
        return r.expand(10, 10);
    }

    protected P newImage(WordprocessingMLPackage wordMLPackage, Part sourcePart, byte[] bytes, String filenameHint, String altText, int id1, int id2) throws Exception {
        Jc jc;
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((OpcPackage)wordMLPackage, (Part)sourcePart, (byte[])bytes);
        Inline inline = imagePart.createImageInline(filenameHint, altText, id1, id2, false);
        new org.docx4j.dml.ObjectFactory();
        new ObjectFactory();
        org.docx4j.wml.ObjectFactory factory = Context.getWmlObjectFactory();
        P p = factory.createP();
        R run = factory.createR();
        p.getContent().add(run);
        Drawing drawing = factory.createDrawing();
        run.getContent().add(drawing);
        drawing.getAnchorOrInline().add(inline);
        PPr pPr = p.getPPr();
        if (pPr == null) {
            pPr = factory.createPPr();
        }
        if ((jc = pPr.getJc()) == null) {
            jc = new Jc();
        }
        jc.setVal(JcEnumeration.RIGHT);
        pPr.setJc(jc);
        p.setPPr(pPr);
        return p;
    }

    public boolean isOnlyLogic() {
        return this.isOnlyLogic;
    }

    public void setOnlyLogic(boolean isOnlyLogic) {
        this.isOnlyLogic = isOnlyLogic;
    }
}

