/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.view;

import aurora.ide.editor.editorInput.PathEditorInput;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.FileExplorer;
import aurora.ide.meta.gef.editors.ConsultantVScreenEditor;
import aurora.ide.meta.gef.message.Messages;
import aurora.ide.prototype.consultant.product.Activator;
import aurora.ide.prototype.consultant.view.CNFContentProvider;
import aurora.ide.prototype.consultant.view.CNFLabelProvider;
import aurora.ide.prototype.consultant.view.CNFViewerSorter;
import aurora.ide.prototype.consultant.view.NavViewSetting;
import aurora.ide.prototype.consultant.view.Node;
import aurora.ide.prototype.consultant.view.NodeLinkHelper;
import aurora.ide.prototype.consultant.view.Root;
import aurora.ide.prototype.consultant.view.action.CollapseAllAction;
import aurora.ide.prototype.consultant.view.action.FunctionExportFSDAction;
import aurora.ide.prototype.consultant.view.action.LinkEditorAction;
import aurora.ide.prototype.consultant.view.action.NewMenuAction;
import aurora.ide.prototype.consultant.view.action.OpenLocalProjectAction;
import aurora.ide.prototype.consultant.view.action.PopMenuManager;
import aurora.ide.prototype.consultant.view.action.ProjectExportFSDAction;
import aurora.ide.prototype.consultant.view.action.RefreshLocalFileSystemAction;
import aurora.ide.prototype.consultant.view.action.RemoveLocalFolderAction;
import aurora.ide.prototype.consultant.view.util.ResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.CollapseAllHandler;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class NavigationView
extends ViewPart {
    public static final String ID = "aurora.ide.prototype.consultant.view.navigationView";
    private TreeViewer viewer;
    private CollapseAllAction collapseAllAction;
    private CollapseAllHandler collapseAllHandler;
    private LinkEditorAction toggleLinkingAction;
    private RefreshLocalFileSystemAction refreshLocalFileSystemAction;
    private Action removeLocalFolderAction;
    private Action openLocalFolderActionAction;
    private boolean isLinkingEnabled;
    private PopMenuManager pmm;
    public static final int IS_LINKING_ENABLED_PROPERTY = 65536;
    private IPropertyChangeListener partPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            Object input;
            Object newValue;
            if (!NavigationView.this.viewer.getControl().isDisposed() && (newValue = event.getNewValue()) instanceof String && (input = NavigationView.this.viewer.getInput()) instanceof Root) {
                List<Node> children = ((Root)((Object)input)).getChildren();
                for (Node node : children) {
                    if (!node.getPath().isPrefixOf((IPath)new Path((String)newValue))) continue;
                    NavigationView.this.viewer.refresh((Object)node);
                    Node findNode = new NodeLinkHelper(NavigationView.this).findNode((IPath)new Path((String)newValue), node);
                    if (findNode != null) {
                        NavigationView.this.selectReveal(findNode);
                    }
                    return;
                }
            }
        }
    };
    private UIJob viewerExpandJob = new UIJob("Expand"){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!NavigationView.this.viewer.getControl().isDisposed()) {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                    }
                });
            }
            return Status.OK_STATUS;
        }
    };
    private ISelection selection;
    private NewMenuAction newMenuAction;
    private OpenLocalProjectAction openLocalProjectAction;

    public void createPartControl(Composite parent) {
        this.viewer = this.createViewer(parent);
        this.viewer.setInput((Object)NavigationView.getInitialInput());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.setPartName(Messages.ApplicationActionBarAdvisor_17);
        this.makeActions();
        this.fillActionBars(this.getViewSite().getActionBars());
        this.initContextMenu();
        this.initListeners(this.viewer);
        this.configration();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private void configration() {
    }

    public void refreshViewer() {
        this.selection = this.viewer.getSelection();
        this.viewer.setInput((Object)NavigationView.getInitialInput());
        this.configration();
    }

    private void fillActionBars(IActionBars actionBars) {
        this.fillToolBar(actionBars.getToolBarManager());
    }

    private void makeActions() {
        IHandlerService service = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.collapseAllAction = new CollapseAllAction(this.viewer);
        ImageDescriptor collapseAllIcon = Activator.getImageDescriptor("/icons/collapseall.gif");
        this.collapseAllAction.setImageDescriptor(collapseAllIcon);
        this.collapseAllAction.setHoverImageDescriptor(collapseAllIcon);
        this.collapseAllHandler = new CollapseAllHandler((AbstractTreeViewer)this.viewer);
        service.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)this.collapseAllHandler);
        this.toggleLinkingAction = new LinkEditorAction(this, this.viewer);
        ImageDescriptor syncIcon = Activator.getImageDescriptor("/icons/synced.gif");
        this.toggleLinkingAction.setImageDescriptor(syncIcon);
        this.toggleLinkingAction.setHoverImageDescriptor(syncIcon);
        this.removeLocalFolderAction = new RemoveLocalFolderAction(this);
        ImageDescriptor icon = Activator.getDefault().getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_REMOVE");
        this.removeLocalFolderAction.setImageDescriptor(icon);
        this.removeLocalFolderAction.setHoverImageDescriptor(icon);
        this.refreshLocalFileSystemAction = new RefreshLocalFileSystemAction(this);
        icon = Activator.getImageDescriptor("/icons/nav_refresh.gif");
        this.refreshLocalFileSystemAction.setImageDescriptor(icon);
        this.refreshLocalFileSystemAction.setHoverImageDescriptor(icon);
        this.newMenuAction = new NewMenuAction(this);
        icon = Activator.getImageDescriptor("/icons/sample2.gif");
        this.newMenuAction.setImageDescriptor(icon);
        this.newMenuAction.setHoverImageDescriptor(icon);
        this.openLocalProjectAction = new OpenLocalProjectAction(this);
        icon = Activator.getImageDescriptor("/icons/open.gif");
        this.openLocalProjectAction.setImageDescriptor(icon);
        this.openLocalProjectAction.setHoverImageDescriptor(icon);
        this.pmm = new PopMenuManager(this);
    }

    protected void initContextMenu() {
        MenuManager menuMgr = new MenuManager("NavigationViewMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NavigationView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.viewer.getTree());
        this.viewer.getTree().setMenu(menu);
    }

    protected void fillToolBar(IToolBarManager toolBar) {
        if (this.newMenuAction != null) {
            toolBar.add((IAction)this.newMenuAction);
        }
        if (this.openLocalProjectAction != null) {
            toolBar.add((IAction)this.openLocalProjectAction);
        }
        if (this.removeLocalFolderAction != null) {
            toolBar.add((IAction)this.removeLocalFolderAction);
        }
        if (this.refreshLocalFileSystemAction != null) {
            toolBar.add((IAction)this.refreshLocalFileSystemAction);
        }
        if (this.collapseAllAction != null) {
            toolBar.add((IAction)this.collapseAllAction);
        }
        if (this.toggleLinkingAction != null) {
            toolBar.add((IAction)this.toggleLinkingAction);
        }
    }

    private void fillContextMenu(IMenuManager menu) {
        Node selectionNode;
        Node node = this.getSelectionNode();
        if (node == null) {
            return;
        }
        this.pmm.fillContextMenu(menu);
        if (node.getFile().isFile()) {
            menu.add((IAction)new Action(Messages.NavigationView_1){

                public void run() {
                    Node node = NavigationView.this.getSelectionNode();
                    File file = node.getFile();
                    IEditorInput input = NavigationView.this.createEditorInput(file);
                    IWorkbenchPage page = NavigationView.this.getViewSite().getWorkbenchWindow().getActivePage();
                    try {
                        IEditorReference[] editorReferences;
                        IEditorReference[] iEditorReferenceArray = editorReferences = page.getEditorReferences();
                        int n = editorReferences.length;
                        int n2 = 0;
                        while (n2 < n) {
                            boolean openConfirm;
                            IEditorReference iEditorReference = iEditorReferenceArray[n2];
                            IEditorInput editorInput = iEditorReference.getEditorInput();
                            if (input.equals(editorInput) && (openConfirm = MessageDialog.openConfirm((Shell)NavigationView.this.getSite().getShell(), (String)Messages.NavigationView_0, (String)Messages.NavigationView_6))) {
                                page.closeEditor(iEditorReference.getEditor(true), true);
                            }
                            ++n2;
                        }
                        page.openEditor(input, "aurora.ide.prototype.consultant.editor.FSDEditor");
                    }
                    catch (PartInitException partInitException) {}
                }
            });
        }
        if (ResourceUtil.isProject((selectionNode = this.getSelectionNode()).getFile())) {
            menu.add((IAction)new ProjectExportFSDAction(this, Messages.NavigationView_2));
        }
        if (ResourceUtil.isModule(selectionNode.getFile())) {
            menu.add((IAction)new ProjectExportFSDAction(this, Messages.NavigationView_3));
        }
        if (ResourceUtil.isFunction(selectionNode.getFile())) {
            menu.add((IAction)new FunctionExportFSDAction(this, Messages.NavigationView_5));
        }
        if (this.getSelectionNode() != null) {
            menu.add((IAction)new Action(""){

                public void run() {
                    Node node = NavigationView.this.getSelectionNode();
                    if (!node.getFile().exists()) {
                        MessageDialog.openInformation((Shell)NavigationView.this.getViewer().getControl().getShell(), (String)"Info", (String)Messages.NavigationView_7);
                        return;
                    }
                    if (node.getFile().isFile()) {
                        node = node.getParent();
                    }
                    FileExplorer.open((String)node.getPath().toOSString());
                }
            });
        }
        menu.add((IAction)new Action(Messages.NavigationView_8){

            public void run() {
                IHandlerService hs = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
                try {
                    hs.executeCommand("org.eclipse.ui.file.properties", null);
                }
                catch (ExecutionException e) {
                    DialogUtil.showExceptionMessageBox((Throwable)e);
                }
                catch (NotDefinedException e) {
                    DialogUtil.showExceptionMessageBox((Throwable)e);
                }
                catch (NotEnabledException e) {
                    DialogUtil.showExceptionMessageBox((Throwable)e);
                }
                catch (NotHandledException e) {
                    DialogUtil.showExceptionMessageBox((Throwable)e);
                }
            }
        });
    }

    protected void fillViewMenu(IMenuManager menu) {
    }

    protected TreeViewer createViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 2818);
        viewer.setContentProvider((IContentProvider)new CNFContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new CNFLabelProvider());
        viewer.setSorter((ViewerSorter)new CNFViewerSorter());
        return viewer;
    }

    protected void initListeners(TreeViewer viewer) {
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(final DoubleClickEvent event) {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        NavigationView.this.handleDoubleClick(event);
                    }
                });
            }
        });
        this.getViewSite().getPage().addPartListener(new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (part instanceof ConsultantVScreenEditor) {
                    ((ConsultantVScreenEditor)part).removePartPropertyListener(NavigationView.this.partPropertyChangeListener);
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
                if (part instanceof ConsultantVScreenEditor) {
                    ((ConsultantVScreenEditor)part).addPartPropertyListener(NavigationView.this.partPropertyChangeListener);
                }
            }
        });
    }

    protected void handleDoubleClick(DoubleClickEvent anEvent) {
        Object[] array;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1) {
            Node node = this.getSelectionNode();
            File file = node.getFile();
            if (!file.exists()) {
                MessageDialog.openInformation((Shell)this.getViewer().getControl().getShell(), (String)"Info", (String)Messages.NavigationView_11);
                return;
            }
            if (file.isDirectory()) {
                this.viewer.expandToLevel((Object)node, 1);
            }
        }
        Object[] objectArray = array = selection.toArray();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            File file;
            Object node = objectArray[n2];
            if (node instanceof Node && (file = ((Node)((Object)node)).getFile()).isFile()) {
                IEditorInput input = this.createEditorInput(file);
                String editorId = this.getEditorId(file);
                IWorkbenchPage page = this.getViewSite().getWorkbenchWindow().getActivePage();
                try {
                    page.openEditor(input, editorId);
                }
                catch (PartInitException partInitException) {}
            }
            ++n2;
        }
    }

    private String getEditorId(File file) {
        IWorkbench workbench = this.getViewSite().getWorkbenchWindow().getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(file.getName());
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "aurora.ide.meta.gef.editors.ConsultantVScreenEditor";
    }

    private IEditorInput createEditorInput(File file) {
        Path location = new Path(file.getAbsolutePath());
        PathEditorInput input = new PathEditorInput((IPath)location);
        return input;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public static IAdaptable getInitialInput() {
        String[] folders;
        Root root = new Root();
        NavViewSetting nvs = new NavViewSetting();
        String[] stringArray = folders = nvs.getFolders();
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            root.addChild(new Node((IPath)new Path(string)));
            ++n2;
        }
        return root;
    }

    public Node getSelectionNode() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Node node = (Node)((Object)selection.getFirstElement());
        return node;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void selectReveal(ISelection selection) {
        if (this.viewer != null) {
            this.viewer.setSelection(selection, true);
        }
    }

    public final void setLinkingEnabled(boolean toEnableLinking) {
        this.isLinkingEnabled = toEnableLinking;
        this.firePropertyChange(65536);
    }

    public final boolean isLinkingEnabled() {
        return this.isLinkingEnabled;
    }

    public void selectReveal(Node findNode) {
        this.selectReveal((ISelection)new StructuredSelection((Object)findNode));
    }

    public void addNewNode(Object parent, Node child) {
        Node[] nodes;
        IPath path = child.getPath().removeLastSegments(1);
        Node[] nodeArray = nodes = this.findSamePathNodes(path);
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            if (!node.equals(parent)) {
                Node cc = new Node(child.getPath());
                node.addChild(cc);
                this.getViewer().add((Object)node, (Object)cc);
            }
            ++n2;
        }
        ((Node)((Object)parent)).addChild(child);
        this.getViewer().add(parent, (Object)child);
        this.selectReveal(child);
    }

    public Node[] findSamePathNodes(Node n) {
        return this.findSamePathNodes(n.getPath());
    }

    public Node[] findSamePathNodes(IPath path) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Root input = (Root)((Object)this.getViewer().getInput());
        List<Node> children = input.getChildren();
        for (Node node : children) {
            NodeLinkHelper nlh;
            Node findNode;
            if (!node.getPath().isPrefixOf(path) || (findNode = (nlh = new NodeLinkHelper(this)).findNode(path, node)) == null) continue;
            nodes.add(findNode);
        }
        return nodes.toArray(new Node[nodes.size()]);
    }
}

