/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.view.action;

import aurora.ide.libs.AuroraImagesUtils;
import aurora.ide.prototype.consultant.view.NavigationView;
import aurora.ide.prototype.consultant.view.Node;
import aurora.ide.prototype.consultant.view.action.Messages;
import aurora.ide.prototype.consultant.view.wizard.CreateUIPWizard;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;

public class CreateUIPAction
extends Action
implements ISelectionChangedListener {
    private final TreeViewer commonViewer;
    private NavigationView viewer;

    public CreateUIPAction(NavigationView viewer) {
        super(Messages.CreateUIPAction_0);
        this.setToolTipText(Messages.CreateUIPAction_1);
        this.setImageDescriptor(AuroraImagesUtils.getImageDescriptor((String)"/meta.png"));
        this.viewer = viewer;
        this.commonViewer = viewer.getViewer();
        this.commonViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.selectionChanged();
    }

    public void run() {
        Node selectionNode = this.viewer.getSelectionNode();
        if (selectionNode == null) {
            return;
        }
        File file = selectionNode.getFile();
        File parent = file.isDirectory() ? file : file.getParentFile();
        CreateUIPWizard w = new CreateUIPWizard(this.commonViewer.getControl().getShell(), parent);
        if (w.open() == 0) {
            Node newNode = new Node((IPath)new Path(w.getUIPFile().getPath()));
            this.viewer.addNewNode((Object)(file.isDirectory() ? selectionNode : selectionNode.getParent()), newNode);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionChanged();
    }

    protected void selectionChanged() {
        Node node = this.viewer.getSelectionNode();
        if (node != null && node.getFile().exists()) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

