/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.view.action;

import aurora.ide.libs.AuroraImagesUtils;
import aurora.ide.prototype.consultant.view.NavigationView;
import aurora.ide.prototype.consultant.view.action.CreateFunctionAction;
import aurora.ide.prototype.consultant.view.action.CreateModuleAction;
import aurora.ide.prototype.consultant.view.action.CreateProjectAction;
import aurora.ide.prototype.consultant.view.action.CreateUIPAction;
import aurora.ide.prototype.consultant.view.action.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;

public class NewMenuAction
extends Action
implements IMenuCreator {
    private NavigationView viewer;
    private CreateProjectAction createProjectAction;
    private CreateFunctionAction createFunctionAction;
    private CreateUIPAction createUIPAction;
    private CreateModuleAction createModuleAction;
    private Action activeAction;

    public NewMenuAction(NavigationView viewer) {
        super(Messages.NewMenuAction_0, 4);
        this.viewer = viewer;
        this.setMenuCreator(this);
        this.makeActions();
    }

    private void makeActions() {
        this.createProjectAction = new CreateProjectAction(this.viewer);
        this.createFunctionAction = new CreateFunctionAction(this.viewer);
        this.createUIPAction = new CreateUIPAction(this.viewer);
        this.createModuleAction = new CreateModuleAction(this.viewer);
    }

    public void run() {
        if (this.activeAction != null && this.activeAction.isEnabled()) {
            this.activeAction.run();
        } else {
            this.createProjectAction.run();
        }
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        Menu menu = new Menu(parent);
        this.fillMenu(menu);
        return menu;
    }

    private MenuItem createMenuItem(Menu menu, Action action, String text) {
        MenuItem mi = new MenuItem(menu, 0);
        mi.setText(text);
        mi.setEnabled(action.isEnabled());
        mi.addSelectionListener((SelectionListener)new ActionRunner(action));
        return mi;
    }

    public void fillMenu(Menu menu) {
        this.createMenuItem(menu, this.createProjectAction, Messages.NewMenuAction_1).setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"));
        this.createMenuItem(menu, this.createModuleAction, Messages.NewMenuAction_2).setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"));
        this.createMenuItem(menu, this.createFunctionAction, Messages.NewMenuAction_3).setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"));
        this.createMenuItem(menu, this.createUIPAction, Messages.NewMenuAction_4).setImage(AuroraImagesUtils.getImage((String)"/meta.png"));
    }

    public Menu getMenu(Menu parent) {
        Menu menu = new Menu(parent);
        this.fillMenu(menu);
        return menu;
    }

    private class ActionRunner
    extends SelectionAdapter {
        private Action action;

        private ActionRunner(Action action) {
            this.action = action;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.action != null && this.action.isEnabled()) {
                this.action.run();
                NewMenuAction.this.activeAction = this.action;
            }
        }
    }
}

