/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.view.util;

import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.prototype.consultant.view.Node;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import uncertain.composite.CompositeMap;
import uncertain.composite.XMLOutputter;

public class ResourceUtil {
    public static boolean isProject(File pj) {
        File p = ResourceUtil.getProjectPropertyFile(pj);
        return p.exists();
    }

    public static boolean isModule(File file) {
        File p = ResourceUtil.getModulePropertyFile(file);
        return p.exists();
    }

    public static File getModulePropertyFile(File file) {
        return new File(file, "quick_ui.module");
    }

    public static File getSortFile(File file) {
        return new File(file, "quick_ui.sort");
    }

    public static boolean isFunction(File file) {
        File p = ResourceUtil.getFunctionPropertyFile(file);
        return p.exists();
    }

    public static File getFunctionPropertyFile(File file) {
        return new File(file, "quick_ui.function");
    }

    public static CompositeMap loadProjectProperties(File file) {
        File p = ResourceUtil.getProjectPropertyFile(file);
        if (!p.exists()) {
            return null;
        }
        CompositeMap loadFile = CompositeMapUtil.loadFile((File)p);
        return loadFile;
    }

    public static CompositeMap loadSortProperties(File file) {
        File p = ResourceUtil.getSortFile(file);
        if (!p.exists()) {
            return null;
        }
        CompositeMap loadFile = CompositeMapUtil.loadFile((File)p);
        return loadFile;
    }

    public static File getProjectPropertyFile(File file) {
        return new File(file, "quick_ui.project");
    }

    public static CompositeMap loadDemonProperties(File file) {
        File p = new File(file, "demonstrate.setting");
        if (!p.exists()) {
            return null;
        }
        CompositeMap loadFile = CompositeMapUtil.loadFile((File)p);
        return loadFile;
    }

    public static CompositeMap loadFunctionProperties(File file) {
        File p = ResourceUtil.getFunctionPropertyFile(file);
        if (!p.exists()) {
            return null;
        }
        CompositeMap loadFile = CompositeMapUtil.loadFile((File)p);
        return loadFile;
    }

    public static File getProject(File file) {
        if (ResourceUtil.isProject(file)) {
            return file;
        }
        File parentFile = file.getParentFile();
        if (parentFile != null && parentFile.exists()) {
            return ResourceUtil.getProject(parentFile);
        }
        return file;
    }

    public static IPath getFullProjectRelativePath(File project, File f) {
        Path pjPath = new Path(project.getPath());
        Path pPath = new Path(f.getPath());
        Path r = new Path(String.valueOf(project.getName()) + File.separator + pPath.makeRelativeTo((IPath)pjPath));
        return r;
    }

    public static File createFolder(File f) {
        if (f.mkdir()) {
            return f;
        }
        return null;
    }

    public static void createFile(File parent, String name, CompositeMap map) throws IOException {
        File p_file = new File(parent, name);
        p_file.createNewFile();
        if (p_file.exists() && p_file.canWrite()) {
            XMLOutputter.saveToFile((File)p_file, (CompositeMap)map);
        }
    }

    public static boolean isUIP(File file) {
        Path p = new Path(file.getPath());
        return "uip".equalsIgnoreCase(p.getFileExtension());
    }

    public static CompositeMap loadModuleProperties(File file) {
        File p = ResourceUtil.getModulePropertyFile(file);
        if (!p.exists()) {
            return null;
        }
        CompositeMap loadFile = CompositeMapUtil.loadFile((File)p);
        return loadFile;
    }

    public static void copyProjectProperties(File file, CompositeMap pp) {
        File project = ResourceUtil.getProject(file);
        CompositeMap projectProperties = ResourceUtil.loadProjectProperties(project);
        List childs = projectProperties.getChilds();
        if (childs == null) {
            return;
        }
        for (Object c : childs) {
            String t;
            String text;
            if (!(c instanceof CompositeMap) || "fsd_table_input".equals(((CompositeMap)c).getName()) || (text = ((CompositeMap)c).getText()) == null || "".equals(text)) continue;
            CompositeMap child = pp.getChild(((CompositeMap)c).getName());
            if (child == null) {
                child = pp.createChild(((CompositeMap)c).getName());
            }
            if ((t = child.getText()) != null && !"".equals(t)) continue;
            child.setText(text);
        }
    }

    public static Node getProjectNode(Node selectionNode) {
        File file = selectionNode.getFile();
        if (ResourceUtil.isProject(file)) {
            return selectionNode;
        }
        File file2 = selectionNode.getParent().getFile();
        if (file2 != null && file2.exists()) {
            return ResourceUtil.getProjectNode(selectionNode.getParent());
        }
        return selectionNode;
    }
}

