/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.view.wizard;

import aurora.ide.prototype.consultant.view.util.ResourceUtil;
import aurora.ide.prototype.consultant.view.wizard.CreateProjectPage;
import aurora.ide.prototype.consultant.view.wizard.Messages;
import aurora.ide.swt.util.PageModel;
import aurora.ide.swt.util.UWizard;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import uncertain.composite.CompositeMap;

public class CreateProjectWizard
extends UWizard {
    public static final String QUICK_UI_PROJECT = "quick_ui.project";
    private CreateProjectPage page = new CreateProjectPage("CreateProjectPage", new PageModel());

    public CreateProjectWizard(Shell shell) {
        super(shell);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        File pj = this.createProject();
        if (pj == null) {
            this.page.verifyPage(Messages.CreateProjectWizard_2);
            return false;
        }
        try {
            this.createPJProperties(pj);
        }
        catch (IOException iOException) {
            this.page.verifyPage(Messages.CreateProjectWizard_3);
            return false;
        }
        return true;
    }

    private File createProject() {
        File pj = this.getProject();
        return ResourceUtil.createFolder(pj);
    }

    public File getProject() {
        String pjName = this.page.getModel().getStringPropertyValue(CreateProjectPage.properties[0]);
        String pjPath = this.page.getModel().getStringPropertyValue(CreateProjectPage.properties[1]);
        File pj = new File(new File(pjPath), pjName);
        return pj;
    }

    private void createPJProperties(File pj) throws IOException {
        CompositeMap map = new CompositeMap("properties");
        map.createChild(CreateProjectPage.properties[2]).setText(this.page.getModel().getStringPropertyValue(CreateProjectPage.properties[2]));
        map.createChild(CreateProjectPage.properties[3]).setText(this.page.getModel().getStringPropertyValue(CreateProjectPage.properties[3]));
        map.createChild(CreateProjectPage.properties[4]).setText(this.page.getModel().getStringPropertyValue(CreateProjectPage.properties[4]));
        ResourceUtil.createFile(pj, QUICK_UI_PROJECT, map);
    }
}

