/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Calendar;
import org.docx4j.convert.out.flatOpcXml.FlatOpcXmlCreator;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.CommentsPart;
import org.docx4j.samples.AbstractSample;
import org.docx4j.wml.Comments;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.Text;

public class CommentsSample
extends AbstractSample {
    static ObjectFactory factory = Context.getWmlObjectFactory();

    public static void main(String[] args) throws Exception {
        try {
            CommentsSample.getInputFilePath((String[])args);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            inputfilepath = String.valueOf(System.getProperty("user.dir")) + "/OUT_CommentsSample.docx";
        }
        boolean save = inputfilepath != null;
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        CommentsPart cp = new CommentsPart();
        wordMLPackage.getMainDocumentPart().addTargetPart((Part)cp);
        Comments comments = factory.createComments();
        cp.setJaxbElement((Object)comments);
        BigInteger commentId = BigInteger.valueOf(0L);
        Comments.Comment theComment = CommentsSample.createComment(commentId, "fred", null, "my first comment");
        comments.getComment().add(theComment);
        P paraToCommentOn = wordMLPackage.getMainDocumentPart().addParagraphOfText("here is some content");
        paraToCommentOn.getContent().add(CommentsSample.createRunCommentReference(commentId));
        commentId = commentId.add(BigInteger.ONE);
        if (save) {
            wordMLPackage.save(new File(inputfilepath));
            System.out.println("Saved " + inputfilepath);
        } else {
            FlatOpcXmlCreator worker = new FlatOpcXmlCreator((OpcPackage)wordMLPackage);
            worker.marshal((OutputStream)System.out);
        }
        System.out.println("Done.");
    }

    private static Comments.Comment createComment(BigInteger commentId, String author, Calendar date, String message) {
        Comments.Comment comment = factory.createCommentsComment();
        comment.setId(commentId);
        if (author != null) {
            comment.setAuthor(author);
        }
        P commentP = factory.createP();
        comment.getEGBlockLevelElts().add(commentP);
        R commentR = factory.createR();
        commentP.getContent().add(commentR);
        Text commentText = factory.createText();
        commentR.getContent().add(commentText);
        commentText.setValue(message);
        return comment;
    }

    private static R createRunCommentReference(BigInteger commentId) {
        R run = factory.createR();
        R.CommentReference commentRef = factory.createRCommentReference();
        run.getContent().add(commentRef);
        commentRef.setId(commentId);
        return run;
    }
}

