/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.docx4j.XmlUtils;
import org.docx4j.model.sdt.QueryString;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.opendope.ConditionsPart;
import org.docx4j.openpackaging.parts.opendope.XPathsPart;
import org.docx4j.samples.AbstractSample;
import org.docx4j.utils.SingleTraversalUtilVisitorCallback;
import org.docx4j.utils.TraversalUtilVisitor;
import org.docx4j.wml.CTDataBinding;
import org.docx4j.wml.SdtElement;
import org.docx4j.wml.SdtPr;
import org.docx4j.wml.Tag;
import org.opendope.conditions.Condition;
import org.opendope.conditions.Conditions;
import org.opendope.conditions.Xpathref;
import org.opendope.xpaths.Xpaths;

public class ContentControlsInfoStructure
extends AbstractSample {
    private static Conditions conditions;
    private static Xpaths xPaths;

    public static void main(String[] args) throws Exception {
        IndentingVisitorCallback contentControlCallback;
        try {
            ContentControlsInfoStructure.getInputFilePath((String[])args);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            inputfilepath = String.valueOf(System.getProperty("user.dir")) + "/sample-docs/word/databinding/invoice.docx";
        }
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load((File)new File(inputfilepath));
        wordMLPackage.getMainDocumentPart();
        if (wordMLPackage.getMainDocumentPart().getXPathsPart() == null) {
            throw new Docx4JException("OpenDoPE XPaths part missing");
        }
        xPaths = (Xpaths)wordMLPackage.getMainDocumentPart().getXPathsPart().getJaxbElement();
        if (wordMLPackage.getMainDocumentPart().getConditionsPart() != null) {
            conditions = (Conditions)wordMLPackage.getMainDocumentPart().getConditionsPart().getJaxbElement();
        }
        TraversalUtilContentControlVisitor visitor = new TraversalUtilContentControlVisitor();
        visitor.callback = contentControlCallback = new IndentingVisitorCallback(visitor);
        contentControlCallback.walkJAXBElements(wordMLPackage.getMainDocumentPart().getJaxbElement());
    }

    public static class IndentingVisitorCallback
    extends SingleTraversalUtilVisitorCallback {
        String indent = "";

        public IndentingVisitorCallback(TraversalUtilVisitor visitor) {
            super(visitor);
        }

        public void walkJAXBElements(Object parent) {
            List children = this.getChildren(parent);
            if (children != null) {
                String oldIndent = this.indent;
                this.indent = String.valueOf(this.indent) + "  ";
                for (Object o : children) {
                    o = XmlUtils.unwrap(o);
                    this.apply(o, parent, children);
                    if (!this.shouldTraverse(o)) continue;
                    this.walkJAXBElements(o);
                }
                this.indent = oldIndent;
            }
        }
    }

    public static class TraversalUtilContentControlVisitor
    extends TraversalUtilVisitor<SdtElement> {
        IndentingVisitorCallback callback;

        public void apply(SdtElement element, Object parent, List<Object> siblings) {
            System.out.println();
            SdtPr sdtPr = element.getSdtPr();
            if (sdtPr == null) {
                System.out.println(String.valueOf(this.callback.indent) + element.getClass().getSimpleName() + "  [no sdtPr!]" + " (having parent " + parent.getClass().getSimpleName() + ")");
            } else {
                Tag tag;
                System.out.println(String.valueOf(this.callback.indent) + element.getClass().getSimpleName() + " (having parent " + parent.getClass().getSimpleName() + ")");
                CTDataBinding binding = (CTDataBinding)XmlUtils.unwrap((Object)sdtPr.getDataBinding());
                if (binding != null) {
                    System.out.println(String.valueOf(this.callback.indent) + "  binding: " + binding.getXpath());
                }
                if ((tag = sdtPr.getTag()) == null) {
                    return;
                }
                System.out.println(String.valueOf(this.callback.indent) + "  " + tag.getVal());
                HashMap map = QueryString.parseQueryString((String)tag.getVal(), (boolean)true);
                String conditionId = (String)map.get("od:condition");
                String repeatId = (String)map.get("od:repeat");
                String xp = (String)map.get("od:xpath");
                if (conditionId != null) {
                    Condition c = ConditionsPart.getConditionById((Conditions)conditions, (String)conditionId);
                    if (c == null) {
                        System.out.println(String.valueOf(this.callback.indent) + "  " + "Missing condition " + conditionId);
                    }
                    if (c.getParticle() instanceof Xpathref) {
                        Xpaths.Xpath xpath;
                        Xpathref xpathRef = (Xpathref)c.getParticle();
                        if (xpathRef == null) {
                            System.out.println(String.valueOf(this.callback.indent) + "  " + "Condition " + c.getId() + " references a missing xpath!");
                        }
                        if ((xpath = XPathsPart.getXPathById((Xpaths)xPaths, (String)xpathRef.getId())) == null) {
                            System.out.println(String.valueOf(this.callback.indent) + "  " + "XPath specified in condition '" + c.getId() + "' is missing!");
                        } else {
                            System.out.println(String.valueOf(this.callback.indent) + "  " + xpath.getId() + ": " + xpath.getDataBinding().getXpath());
                        }
                    } else {
                        System.out.println("Complex condition: " + XmlUtils.marshaltoString((Object)c, (boolean)true, (boolean)true));
                    }
                } else if (repeatId != null) {
                    Xpaths.Xpath xpath = XPathsPart.getXPathById((Xpaths)xPaths, (String)repeatId);
                    if (xpath == null) {
                        System.out.println(String.valueOf(this.callback.indent) + "  " + "XPath specified in repeat '" + repeatId + "' is missing!");
                    } else {
                        System.out.println(String.valueOf(this.callback.indent) + "  " + xpath.getId() + ": " + xpath.getDataBinding().getXpath());
                    }
                } else if (xp != null) {
                    Xpaths.Xpath xpath = XPathsPart.getXPathById((Xpaths)xPaths, (String)xp);
                    if (xpath == null) {
                        System.out.println(String.valueOf(this.callback.indent) + "  " + "XPath specified with id '" + xp + "' is missing!");
                    } else {
                        System.out.println(String.valueOf(this.callback.indent) + "  " + xpath.getId() + ": " + xpath.getDataBinding().getXpath());
                    }
                }
            }
        }
    }
}

