/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;

public class ImageAdd {
    public static void main(String[] args) throws Exception {
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        File file = new File(String.valueOf(System.getProperty("user.dir")) + "/src/test/resources/images/greentick.png");
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            System.out.println("File too large!!");
        }
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            System.out.println("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        String filenameHint = null;
        String altText = null;
        int id1 = 0;
        int id2 = 1;
        P p = ImageAdd.newImage(wordMLPackage, bytes, filenameHint, altText, id1, id2);
        wordMLPackage.getMainDocumentPart().addObject((Object)p);
        P p2 = ImageAdd.newImage(wordMLPackage, bytes, filenameHint, altText, id1, id2, 3000L);
        wordMLPackage.getMainDocumentPart().addObject((Object)p2);
        P p3 = ImageAdd.newImage(wordMLPackage, bytes, filenameHint, altText, id1, id2, 6000L);
        wordMLPackage.getMainDocumentPart().addObject((Object)p3);
        wordMLPackage.save(new File(String.valueOf(System.getProperty("user.dir")) + "/OUT_AddImage.docx"));
    }

    public static P newImage(WordprocessingMLPackage wordMLPackage, byte[] bytes, String filenameHint, String altText, int id1, int id2) throws Exception {
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)wordMLPackage, (byte[])bytes);
        Inline inline = imagePart.createImageInline(filenameHint, altText, id1, id2, false);
        ObjectFactory factory = Context.getWmlObjectFactory();
        P p = factory.createP();
        R run = factory.createR();
        p.getContent().add(run);
        Drawing drawing = factory.createDrawing();
        run.getContent().add(drawing);
        drawing.getAnchorOrInline().add(inline);
        return p;
    }

    public static P newImage(WordprocessingMLPackage wordMLPackage, byte[] bytes, String filenameHint, String altText, int id1, int id2, long cx) throws Exception {
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)wordMLPackage, (byte[])bytes);
        Inline inline = imagePart.createImageInline(filenameHint, altText, id1, id2, cx, false);
        ObjectFactory factory = Context.getWmlObjectFactory();
        P p = factory.createP();
        R run = factory.createR();
        p.getContent().add(run);
        Drawing drawing = factory.createDrawing();
        run.getContent().add(drawing);
        drawing.getAnchorOrInline().add(inline);
        return p;
    }
}

