/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.docx4j.dml.CTBlip;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.relationships.Relationships;
import org.docx4j.utils.SingleTraversalUtilVisitorCallback;
import org.docx4j.utils.TraversalUtilVisitor;
import org.docx4j.wml.Body;
import org.docx4j.wml.Document;

public class ImageConvertEmbeddedToLinked {
    public static void main(String[] args) throws Exception {
        String BASE_DIR = System.getProperty("user.dir");
        String inputfilepath = String.valueOf(BASE_DIR) + "/sample-docs/word/sample-docx.docx";
        boolean saveImages = true;
        boolean saveResultingDoc = true;
        String outputfilepath = String.valueOf(BASE_DIR) + "/OUT_ConvertEmbeddedImageToLinked.docx";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load((File)new File(inputfilepath));
        MainDocumentPart documentPart = wordMLPackage.getMainDocumentPart();
        RelationshipsPart relsPart = documentPart.getRelationshipsPart();
        Relationships rels = relsPart.getRelationships();
        List relsList = rels.getRelationship();
        for (Relationship r : relsList) {
            System.out.println(r.getTargetMode());
            if (!r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/image") || r.getTargetMode() != null && !r.getTargetMode().equalsIgnoreCase("internal")) continue;
            String target = r.getTarget();
            System.out.println("target: " + target);
            if (saveImages) {
                File f = new File(String.valueOf(BASE_DIR) + "/" + target);
                if (f.exists()) {
                    System.out.println("Overwriting existing object: " + f.getPath());
                } else if (!f.getParentFile().exists()) {
                    System.out.println("creating " + f.getParentFile().getAbsolutePath());
                    f.getParentFile().mkdirs();
                }
                Part p = relsPart.getPart(r);
                FileOutputStream fos = new FileOutputStream(f);
                ((BinaryPart)p).writeDataToOutputStream((OutputStream)fos);
                fos.close();
            }
            r.setTargetMode("External");
        }
        Document wmlDocumentEl = (Document)documentPart.getJaxbElement();
        Body body = wmlDocumentEl.getBody();
        SingleTraversalUtilVisitorCallback imageVisitor = new SingleTraversalUtilVisitorCallback((TraversalUtilVisitor)new TraversalUtilBlipVisitor());
        imageVisitor.walkJAXBElements((Object)body);
        if (saveResultingDoc) {
            SaveToZipFile saver = new SaveToZipFile((OpcPackage)wordMLPackage);
            saver.save(outputfilepath);
        }
    }

    public static class TraversalUtilBlipVisitor
    extends TraversalUtilVisitor<CTBlip> {
        public void apply(CTBlip element, Object parent, List<Object> siblings) {
            if (element.getEmbed() != null) {
                String relId = element.getEmbed();
                element.setLink(relId);
                element.setEmbed(null);
                System.out.println("Converted a:blip with relId " + relId);
            }
        }
    }
}

