/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.bgtcheck.executecheck;

import aurora.plugin.bgtcheck.DatabaseTool;
import aurora.plugin.bgtcheck.executecheck.DataBaseActions;
import aurora.service.IServiceFactory;
import aurora.service.ServiceInvoker;
import aurora.service.ServiceThreadLocal;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;
import uncertain.proc.ProcedureRunner;
import uncertain.util.resource.ILocatable;

public class ExecuteCheck
extends AbstractEntry {
    private IObjectRegistry mRegistry;
    private ILogger logger;
    private DataBaseActions dbActions;
    private IProcedureManager procedureManager;
    private IServiceFactory serviceFactory;
    private String executeProcPath;
    private String batchIdPath;
    private int batch_id;

    public ExecuteCheck(IObjectRegistry registry) throws IOException {
        this.mRegistry = registry;
        this.logger = LoggingContext.getLogger((String)((Object)((Object)this)).getClass().getPackage().getName(), (IObjectRegistry)this.mRegistry);
        this.procedureManager = (IProcedureManager)this.mRegistry.getInstanceOfType(IProcedureManager.class);
        if (this.procedureManager == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException((ILocatable)this, IProcedureManager.class, (String)((Object)((Object)this)).getClass().getName());
        }
        this.serviceFactory = (IServiceFactory)this.mRegistry.getInstanceOfType(IServiceFactory.class);
        if (this.serviceFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException((ILocatable)this, IServiceFactory.class, (String)((Object)((Object)this)).getClass().getName());
        }
    }

    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        this.executeProcPath = TextParser.parse((String)this.executeProcPath, (CompositeMap)context);
        this.batchIdPath = TextParser.parse((String)this.batchIdPath, (CompositeMap)context);
        if (this.batchIdPath != null && !"".equals(this.batchIdPath)) {
            this.batch_id = Integer.valueOf(this.batchIdPath);
        }
        if (this.executeProcPath == null || "".equals(this.executeProcPath)) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)"sqlFileRootPath");
        }
        this.dbActions = new DataBaseActions(this.mRegistry, this.logger);
        this.execute(context);
    }

    private void execute(CompositeMap context) throws Exception {
        CompositeMap hierarchyBatch = this.getHierarchyBatch();
        List batchList = hierarchyBatch.getChilds();
        if (batchList == null) {
            throw new IllegalStateException("Can not find batch records!");
        }
        for (CompositeMap batch : batchList) {
            this.executeCheck(batch, context);
        }
    }

    private void executeCheck(CompositeMap batch, CompositeMap context) throws Exception {
        List subBatchList;
        int batch_id = batch.getInt((Object)"batch_id");
        CompositeMap batchTables = this.dbActions.getBatchTables(batch_id);
        List recordList = batchTables.getChilds();
        if (recordList != null) {
            for (CompositeMap record : recordList) {
                String table_name = record.getString((Object)"table_name");
                this.dbActions.deleteTable(table_name);
                this.dbActions.copyDataToTable(batch_id, table_name);
            }
        }
        if ((subBatchList = batch.getChilds()) == null || subBatchList.size() == 0) {
            this.executeProc(this.executeProcPath, batch_id);
        } else {
            for (CompositeMap subBatch : subBatchList) {
                this.executeCheck(subBatch, context);
            }
        }
    }

    protected void executeProc(String procedure_name, int batch_id) {
        this.logger.log(Level.CONFIG, "load procedure:{0}", new Object[]{procedure_name});
        Procedure proc = this.procedureManager.loadProcedure(procedure_name);
        this.executeProc(batch_id, proc);
    }

    protected void executeProc(int batch_id, Procedure proc) {
        if (proc == null) {
            throw new IllegalArgumentException("Procedure can not be null!");
        }
        try {
            CompositeMap context = ServiceThreadLocal.getCurrentThreadContext();
            CompositeMap fakeContext = new CompositeMap("context");
            fakeContext.addChild(context.getChild("session"));
            fakeContext.addChild(context.getChild("parameter"));
            String name = "check." + batch_id;
            fakeContext.putObject("/parameter/@batch_id", (Object)batch_id, true);
            Connection connection = DatabaseTool.getContextConnection(this.mRegistry);
            connection.commit();
            ServiceInvoker.invokeProcedureWithTransaction((String)name, (Procedure)proc, (IServiceFactory)this.serviceFactory, (CompositeMap)fakeContext, (Connection)connection);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private CompositeMap getHierarchyBatch() throws SQLException {
        CompositeMap hierarchyBatch = new CompositeMap();
        HashMap<Integer, CompositeMap> batch_map = new HashMap<Integer, CompositeMap>();
        CompositeMap batchRecords = null;
        batchRecords = this.batch_id > 0 ? this.dbActions.getBatchs(this.batch_id) : this.dbActions.getBatchs();
        if (batchRecords == null) {
            throw new IllegalStateException("Can not find batch records!");
        }
        List recordList = batchRecords.getChilds();
        if (recordList == null) {
            throw new IllegalStateException("Can not find batch records!");
        }
        for (CompositeMap record : recordList) {
            int parent_batch_id;
            CompositeMap batch = null;
            int batch_id = record.getInt((Object)"batch_id");
            batch = (CompositeMap)batch_map.get(batch_id);
            if (batch == null) {
                batch = new CompositeMap("batch");
                batch.put((Object)"batch_id", (Object)batch_id);
                batch_map.put(batch_id, batch);
            }
            if ((parent_batch_id = record.getInt((Object)"parent_batch_id").intValue()) > 0) {
                CompositeMap parentBatch = (CompositeMap)batch_map.get(parent_batch_id);
                if (parentBatch == null) {
                    parentBatch = new CompositeMap("batch");
                    parentBatch.put((Object)"batch_id", (Object)parent_batch_id);
                    batch_map.put(parent_batch_id, parentBatch);
                }
                parentBatch.addChild(batch);
                continue;
            }
            hierarchyBatch.addChild(batch);
        }
        return hierarchyBatch.getRoot();
    }

    public String getExecuteProcPath() {
        return this.executeProcPath;
    }

    public void setExecuteProcPath(String executeProcPath) {
        this.executeProcPath = executeProcPath;
    }

    public String getBatchIdPath() {
        return this.batchIdPath;
    }

    public void setBatchIdPath(String batchIdPath) {
        this.batchIdPath = batchIdPath;
    }
}

