/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.memcached;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.spy.memcached.MemcachedClient;
import org.apache.commons.codec.digest.DigestUtils;
import uncertain.cache.ICache;
import uncertain.logging.DummyLogger;
import uncertain.logging.ILogger;

public class MemcachedClientWrapper
implements ICache {
    String mName;
    MemcachedClient mClient;
    long mTimeout = 100L;
    ILogger mLogger = DummyLogger.getInstance();

    public MemcachedClientWrapper(String name, MemcachedClient client) {
        this.mClient = client;
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public long getTimeout() {
        return this.mTimeout;
    }

    public void setTimeout(long timeout) {
        this.mTimeout = timeout;
    }

    public ILogger getLogger() {
        return this.mLogger;
    }

    public void setLogger(ILogger logger) {
        this.mLogger = logger;
    }

    public Object getValue(Object key) {
        this.checkKey(key);
        key = DigestUtils.md5Hex((String)key.toString());
        return this.mClient.get(key.toString());
    }

    public boolean setValue(Object key, Object value) {
        return this.setValue(key, 0, value);
    }

    private Boolean checkResult(Future<Boolean> result, String message) {
        try {
            return result.get(this.mTimeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            this.mLogger.log(Level.WARNING, message, (Throwable)ex);
            return null;
        }
    }

    private void checkKey(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key can't be null");
        }
    }

    public boolean setValue(Object key, int timeout, Object value) {
        this.checkKey(key);
        key = DigestUtils.md5Hex((String)key.toString());
        Future b = this.mClient.set(key.toString(), timeout, value);
        Boolean result = this.checkResult(b, "Error when trying to set value to memcached server");
        return result == null ? false : result;
    }

    public void remove(Object key) {
        this.checkKey(key);
        key = DigestUtils.md5Hex((String)key.toString());
        Future f = this.mClient.delete(key.toString());
        this.checkResult(f, "Error when removing key " + key + " from memcached server");
    }

    public void clear() {
        this.mClient.flush();
    }
}

