/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.poi.usermodel;

import aurora.plugin.dataimport.ImportExcel;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import uncertain.composite.CompositeMap;

public class ExcelParse {
    DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    FormulaEvaluator evaluator;

    public void parseFile(InputStream is, ImportExcel importProcessor, String suffix) throws IOException, SQLException {
        HSSFWorkbook wb = null;
        if (".xls".equalsIgnoreCase(suffix)) {
            wb = new HSSFWorkbook(is);
        } else if (".xlsx".equalsIgnoreCase(suffix)) {
            wb = new XSSFWorkbook(is);
        }
        this.evaluator = wb.getCreationHelper().createFormulaEvaluator();
        Sheet sheet = null;
        int i = 0;
        int l = wb.getNumberOfSheets();
        while (i < l) {
            sheet = wb.getSheetAt(i);
            this.parseFile(sheet, importProcessor);
            ++i;
        }
    }

    void parseFile(Sheet sheet, ImportExcel importProcessor) throws SQLException {
        LinkedList<String> cellList = new LinkedList<String>();
        String sheetName = sheet.getSheetName();
        int l = sheet.getLastRowNum();
        if (sheet.getRow(0) == null) {
            return;
        }
        boolean is_write = false;
        boolean is_new = true;
        int i = 0;
        while (i <= l) {
            Row row = sheet.getRow(i);
            if (row != null) {
                CompositeMap record = new CompositeMap("record");
                record.putBoolean((Object)"is_new", is_new);
                is_new = false;
                is_write = false;
                if (i == 0) {
                    record.putString((Object)"sheetName", "sheetName");
                } else {
                    record.putString((Object)"sheetName", sheetName);
                }
                int maxCellNum = row.getLastCellNum();
                int j = 0;
                while (j < maxCellNum) {
                    String value = null;
                    Cell cell = row.getCell(j);
                    if (cell != null) {
                        CellValue cellValue = this.evaluator.evaluate(cell);
                        if (cellValue != null) {
                            switch (cellValue.getCellType()) {
                                case 4: {
                                    value = Boolean.toString(cellValue.getBooleanValue());
                                    break;
                                }
                                case 0: {
                                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                        if (cell.getDateCellValue() == null) break;
                                        value = this.df.format(cell.getDateCellValue());
                                        break;
                                    }
                                    value = BigDecimal.valueOf(cellValue.getNumberValue()).stripTrailingZeros().toPlainString();
                                    break;
                                }
                                case 1: {
                                    value = cellValue.getStringValue();
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                                case 5: {
                                    break;
                                }
                            }
                        }
                        if (value != null && !"".equalsIgnoreCase(value)) {
                            is_write = true;
                            record.putString((Object)("C" + j), value);
                            cellList.add(value);
                        } else {
                            cellList.add("");
                        }
                    } else {
                        cellList.add("");
                    }
                    ++j;
                }
                if (i == 0) {
                    int indexcount = 0;
                    int index = cellList.size();
                    while (index > 0) {
                        String value = (String)cellList.get(index - 1);
                        if (!"".equals(value)) break;
                        ++indexcount;
                        --index;
                    }
                    maxCellNum -= indexcount;
                }
                record.putInt((Object)"maxCell", maxCellNum);
                if (is_write) {
                    importProcessor.saveLine(record, i);
                }
            }
            ++i;
        }
    }
}

