/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen;

import aurora.plugin.source.gen.BuilderSession;

public class RendererScriptGenerator {
    private BuilderSession session;

    public RendererScriptGenerator(BuilderSession session) {
        this.session = session;
    }

    public String hrefScript(String functionName, String labelText, String newWindowName, String para_value) {
        String s = "function #functionName#(value,record, name){return '<a href=\"javascript:#newWindowName#(' + record.get('#para_value#') + ')\">#LabelText#</a>';}";
        s = s.replace("#functionName#", functionName);
        s = s.replace("#newWindowName#", newWindowName);
        s = s.replace("#LabelText#", labelText);
        s = s.replace("#para_value#", para_value);
        return s;
    }

    public String searchScript(String functionName, String datasetId) {
        String s = "function #functionName#(){$('#datasetId#').query();}";
        s = s.replace("#functionName#", functionName);
        s = s.replace("#datasetId#", datasetId);
        return s;
    }

    public String resetScript(String functionName, String datasetId) {
        String s = " function #functionName#(){$('#datasetId#').reset();}";
        s = s.replace("#functionName#", functionName);
        s = s.replace("#datasetId#", datasetId);
        return s;
    }

    public String saveScript(String functionName, String datasetId) {
        String s = " function #functionName#(){$('#datasetId#').submit();}";
        s = s.replace("#functionName#", functionName);
        s = s.replace("#datasetId#", datasetId);
        return s;
    }

    public String openScript(String functionName, String linkId, String para_name) {
        String s = " function #functionName#(para) {var linkUrl = $('#linkId#'); linkUrl.set('#para_name#', para); new Aurora.Window({id: '#windowId#',url:linkUrl.getUrl(),title: 'Title',height: 735,width: 720});}";
        s = s.replace("#functionName#", functionName);
        String windowID = this.session.getIDGenerator().genWindowID(linkId);
        s = s.replaceAll("#windowId#", windowID);
        s = s.replaceAll("#linkId#", linkId);
        s = s.replaceAll("#para_name#", para_name);
        return s;
    }

    public String closeScript(String functionName, String windowId) {
        String s = "function #functionName#(){$('#windowId#').close();}";
        s = s.replace("#functionName#", functionName);
        s = s.replace("#windowId#", windowId);
        return s;
    }

    public String buildHrefScript(String hrefScript, String[] parametersDetail) {
        hrefScript = hrefScript.replace("#parameters#", parametersDetail[0]);
        return hrefScript;
    }

    public String buildOpenScript(String openScript, String[] parametersDetail) {
        openScript = openScript.replace("#parameter_keys#", parametersDetail[1]);
        openScript = openScript.replace("#parameters#", parametersDetail[2]);
        return openScript;
    }
}

