/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen;

import aurora.plugin.source.gen.ActionMethod;
import aurora.plugin.source.gen.BuilderSession;
import aurora.plugin.source.gen.ISourceTemplateProvider;
import aurora.plugin.source.gen.PropertiesMethod;
import aurora.plugin.source.gen.SourceGenManager;
import aurora.plugin.source.gen.TemplateModelWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.core.UncertainEngine;
import uncertain.ocm.IObjectRegistry;

public class SourceTemplateProvider
implements ISourceTemplateProvider {
    private String template = "default";
    private String packageName;
    private Configuration freemarkerConfiguration;
    private Map<String, Template> cache = new HashMap<String, Template>();
    private IObjectRegistry registry;
    private File theme;
    private Template defaultTemplate;
    private SourceGenManager sourceGenManager;

    public SourceTemplateProvider() {
    }

    public SourceTemplateProvider(IObjectRegistry registry) {
        this.registry = registry;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void initialize() {
        this.freemarkerConfiguration = new Configuration();
        this.freemarkerConfiguration.setDefaultEncoding(this.getDefaultEncoding());
        this.freemarkerConfiguration.setOutputEncoding(this.getDefaultEncoding());
        this.freemarkerConfiguration.setObjectWrapper(ObjectWrapper.BEANS_WRAPPER);
    }

    private String getDefaultEncoding() {
        return "UTF-8";
    }

    private Template getFMTemplate(CompositeMap currentMap) {
        String component_type = currentMap.getString((Object)"component_type", "");
        Template template = this.cache.get(component_type);
        if (template == null) {
            template = this.loadTemplate(currentMap);
            if (template != null) {
                this.cache.put(component_type, template);
            } else {
                template = this.getDefaultTempalte();
            }
        }
        return template;
    }

    private Template getDefaultTempalte() {
        if (this.defaultTemplate == null) {
            this.defaultTemplate = Template.getPlainTextTemplate((String)"default", (String)"<a:screen id='${model}'\\>", (Configuration)this.freemarkerConfiguration);
        }
        return this.defaultTemplate;
    }

    private Template loadTemplate(CompositeMap currentMap) {
        String component_type = currentMap.getString((Object)"component_type", "");
        File theme = this.getTemplateTheme();
        File f = new File(theme, String.valueOf(component_type) + ".ftl");
        if (!(f.exists() && f.isFile() && f.getName().endsWith("ftl"))) {
            f = new File(theme, "default.ftl");
        }
        try {
            FileReader fr = new FileReader(f);
            Template t = new Template(component_type, (Reader)fr, this.freemarkerConfiguration);
            return t;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected File getTemplateTheme() {
        if (this.theme != null) {
            return this.theme;
        }
        UncertainEngine engine = (UncertainEngine)this.registry.getInstanceOfType(UncertainEngine.class);
        File configDirectory = engine.getConfigDirectory();
        File f = new File(configDirectory, "aurora.plugin.source.gen");
        File tFolder = new File(f, "template");
        this.theme = new File(tFolder, this.getTemplate());
        return this.theme;
    }

    public String bindTemplate(CompositeMap context, BuilderSession session) {
        Template tplt = this.getFMTemplate(context);
        try {
            StringWriter sw = new StringWriter();
            HashMap<String, Object> p = new HashMap<String, Object>();
            p.put("context", new TemplateModelWrapper(context));
            p.put("config", session.defineConfig());
            p.put("action", new ActionMethod(session));
            p.put("properties", new PropertiesMethod(session));
            tplt.process(p, (Writer)sw);
            sw.flush();
            return sw.toString();
        }
        catch (TemplateException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String buildBM(CompositeMap modelMap) {
        return "";
    }

    public String getPackageName() {
        return this.packageName == null ? "aurora.plugin.source.gen" : this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public String bindTemplate(BuilderSession session) {
        CompositeMap context = session.getCurrentContext();
        return this.bindTemplate(context, session);
    }

    public SourceGenManager getSourceGenManager() {
        return this.sourceGenManager;
    }

    public void setSourceGenManager(SourceGenManager sourceGenManager) {
        this.sourceGenManager = sourceGenManager;
    }
}

