/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen.builders;

import aurora.plugin.source.gen.BuilderSession;
import aurora.plugin.source.gen.ModelMapParser;
import aurora.plugin.source.gen.Util;
import aurora.plugin.source.gen.builders.DefaultSourceBuilder;
import java.util.List;
import uncertain.composite.CompositeMap;

public class ViewBuilder
extends DefaultSourceBuilder {
    private static final String A = "a";

    @Override
    public void buildContext(BuilderSession session) {
        super.buildContext(session);
        this.buildLinkContext(session);
        this.buildDatasetsContext(session);
        this.calBindTarget(session);
    }

    private void buildDatasetsContext(BuilderSession session) {
        CompositeMap currentContext = session.getCurrentContext();
        ModelMapParser mmp = this.getModelMapParser(session);
        List<CompositeMap> datasets = mmp.getDatasets();
        for (CompositeMap ds : datasets) {
            String ds_id = this.genDatasetID(ds, session);
            ds.put((Object)"ds_id", (Object)ds_id);
        }
        for (CompositeMap ds : datasets) {
            String type = ds.getString((Object)"component_type", "");
            if ("querydataset".equalsIgnoreCase(type)) {
                ds.put((Object)"autoCreate", (Object)true);
            }
            if (!"resultdataset".equalsIgnoreCase(type)) continue;
            CompositeMap query = ds.getChildByAttrib((Object)"propertye_id", (Object)"dataset_query_container");
            if (query != null) {
                CompositeMap container = mmp.getComponentByID(query.getString((Object)"markid", ""));
                if (container == null) {
                    return;
                }
                CompositeMap cds = container.getChildByAttrib((Object)"propertye_id", (Object)"i_dataset_delegate");
                String fds_type = cds.getString((Object)"component_type", "");
                if ("querydataset".equalsIgnoreCase(fds_type)) {
                    ds.put((Object)"query_ds", (Object)cds.getString((Object)"ds_id", ""));
                    continue;
                }
                if (!"resultdataset".equalsIgnoreCase(fds_type)) continue;
                ds.put((Object)"bindName", (Object)ds.getString((Object)"ds_id", ""));
                ds.put((Object)"bindTarget", (Object)cds.getString((Object)"ds_id", ""));
                continue;
            }
            ds.put((Object)"autoQuery", (Object)true);
            ds.put((Object)"pageSize", null);
        }
        for (CompositeMap ds : datasets) {
            List<CompositeMap> datasetFields = mmp.getDatasetFields(ds);
            CompositeMap newDS = (CompositeMap)ds.clone();
            newDS.getChildsNotNull().clear();
            newDS.setPrefix(A);
            newDS.setName("dataset");
            for (CompositeMap field : datasetFields) {
                field.put((Object)"field_name", (Object)field.getParent().getString((Object)"name", ""));
                String fieldType = field.getParent().getString((Object)"component_type", "");
                if ("gridcolumn".equals(fieldType)) {
                    fieldType = field.getParent().getString((Object)"editor", "");
                }
                field.put((Object)"field_type", (Object)fieldType);
                if (this.isLov(field)) {
                    this.genLovDSField(session, field);
                }
                if (this.isCombo(field)) {
                    this.genComboDSField(session, field);
                }
                CompositeMap clone = (CompositeMap)field.clone();
                clone.setName("field");
                clone.setPrefix(A);
                newDS.addChild(clone);
            }
            currentContext.addChild(newDS);
        }
    }

    ModelMapParser getModelMapParser(BuilderSession session) {
        CompositeMap currentModel = session.getCurrentModel();
        return session.createModelMapParser(currentModel);
    }

    public void genLovDSField(BuilderSession session, CompositeMap field) {
        String model;
        ModelMapParser mmp = this.getModelMapParser(session);
        String[] models = mmp.findComboFieldOption(field);
        CompositeMap lovservice = this.getLovServiceMap(session, field);
        String lovservice_options = lovservice.getString((Object)"lovservice_options", "");
        models[0] = model = "".equals(lovservice_options) ? models[0] : lovservice_options;
        field.put((Object)"displayField", mmp.getComboDisplayField(models, field));
        field.put((Object)"valueField", mmp.getComboValueField(models, field));
        field.put((Object)"lovService", (Object)model);
    }

    private CompositeMap getLovServiceMap(BuilderSession session, CompositeMap field) {
        CompositeMap innerLovService = field.getChildByAttrib((Object)"component_type", (Object)"innerLovService");
        return innerLovService;
    }

    public void genComboDSField(BuilderSession session, CompositeMap field) {
        ModelMapParser mmp = this.getModelMapParser(session);
        String[] models = mmp.findComboFieldOption(field);
        CompositeMap lovservice = this.getLovServiceMap(session, field);
        String lovservice_options = lovservice.getString((Object)"lovservice_options", "");
        String model = "".equals(lovservice_options) ? models[0] : lovservice_options;
        String lookupCode = models[1];
        if (!"".equals(model) || !"".equals(lookupCode)) {
            CompositeMap createComboDatasetMap = this.createComboDatasetMap(model, lookupCode, session);
            session.getCurrentContext().addChild(createComboDatasetMap);
            field.put((Object)"options", (Object)createComboDatasetMap.getString((Object)"ds_id", ""));
        }
        models[0] = model;
        field.put((Object)"displayField", mmp.getComboDisplayField(models, field));
        field.put((Object)"valueField", mmp.getComboValueField(models, field));
    }

    public boolean isLov(CompositeMap field) {
        String type = field.getParent().getString((Object)"component_type", "");
        if ("gridcolumn".equalsIgnoreCase(type)) {
            type = field.getParent().getString((Object)"editor", "");
        }
        return "lov".equalsIgnoreCase(type);
    }

    public boolean isCombo(CompositeMap field) {
        String type = field.getParent().getString((Object)"component_type", "");
        if ("gridcolumn".equalsIgnoreCase(type)) {
            type = field.getParent().getString((Object)"editor", "");
        }
        return "comboBox".equalsIgnoreCase(type);
    }

    private void calBindTarget(BuilderSession session) {
        ModelMapParser mmp = this.getModelMapParser(session);
        List<CompositeMap> datasets = mmp.getDatasets();
        for (CompositeMap ds : datasets) {
            if (ds.getParent().getString((Object)"component_type", "").equals("grid")) {
                ds.getParent().put((Object)"bindTarget", (Object)ds.getString((Object)"ds_id", ""));
            }
            List<CompositeMap> datasetFields = mmp.getDatasetFields(ds);
            for (CompositeMap field : datasetFields) {
                String ds_id = ds.getString((Object)"ds_id", "");
                field.getParent().put((Object)"bindTarget", (Object)ds_id);
            }
        }
    }

    private CompositeMap createComboDatasetMap(String model, String lookupCode, BuilderSession session) {
        CompositeMap ds = new CompositeMap("dataset");
        ds.setPrefix(A);
        String id = this.genDatasetID(ds, session);
        ds.put((Object)"ds_id", (Object)id);
        ds.put((Object)"autoCreate", (Object)true);
        ds.put((Object)"component_type", (Object)"combodataset");
        if (!"".equals(model)) {
            ds.put((Object)"model", (Object)model);
        }
        ds.put((Object)"loadData", (Object)true);
        if (!"".equals(lookupCode)) {
            ds.put((Object)"lookupCode", (Object)lookupCode);
        }
        return ds;
    }

    private String genDatasetID(CompositeMap ds, BuilderSession session) {
        return session.getIDGenerator().genDatasetID(ds);
    }

    private CompositeMap genLinkContext(CompositeMap map, BuilderSession session, String openpath) {
        CompositeMap link = new CompositeMap("link");
        String id = this.genLinkID(link, session);
        link.put((Object)"url", (Object)("${/request/@context_path}/" + openpath));
        link.put((Object)"component_type", (Object)"link");
        link.put((Object)"id", (Object)id);
        return link;
    }

    private String genLinkID(CompositeMap link, BuilderSession session) {
        return session.getIDGenerator().genLinkID("link");
    }

    private void buildLinkContext(BuilderSession session) {
        CompositeMap link;
        String openpath;
        ModelMapParser mmp = this.getModelMapParser(session);
        CompositeMap currentContext = session.getCurrentContext();
        List<CompositeMap> buttons = mmp.getComponents("button");
        for (CompositeMap button : buttons) {
            String id;
            CompositeMap clicker = button.getChild("inner_buttonclicker");
            if (clicker == null || !"open".equals(id = clicker.getString((Object)"button_click_actionid"))) continue;
            openpath = clicker.getString((Object)"openpath", "");
            if (openpath.endsWith(".uip")) {
                openpath = openpath.replaceAll(".uip", ".screen");
            }
            link = this.genLinkContext(clicker, session, openpath);
            currentContext.addChild(link);
            clicker.put((Object)"link_id", (Object)link.getString((Object)"id", ""));
        }
        List<CompositeMap> renderers = mmp.getComponents("renderer");
        for (CompositeMap renderer : renderers) {
            String type = renderer.getString((Object)"renderer_type", "");
            if (!"PAGE_REDIRECT".equals(type)) continue;
            openpath = renderer.getString((Object)"openpath", "");
            if (openpath.endsWith(".uip")) {
                openpath = Util.getNewLinkFilePath(openpath, "" + session.getConfig("file_name"));
            }
            link = this.genLinkContext(renderer, session, openpath);
            currentContext.addChild(link);
            renderer.put((Object)"link_id", (Object)link.getString((Object)"id", ""));
        }
    }

    @Override
    public void actionEvent(String event, BuilderSession session) {
        if ("children".equals(event) && "view".equalsIgnoreCase(session.getCurrentModel().getString((Object)"component_type", ""))) {
            this.buildChildComponent(session);
        }
    }
}

