/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen.screen.model;

import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Button;
import aurora.plugin.source.gen.screen.model.Dataset;
import aurora.plugin.source.gen.screen.model.DatasetBinder;
import aurora.plugin.source.gen.screen.model.GridColumn;
import aurora.plugin.source.gen.screen.model.GridSelectionCol;
import aurora.plugin.source.gen.screen.model.IDatasetDelegate;
import aurora.plugin.source.gen.screen.model.Navbar;
import aurora.plugin.source.gen.screen.model.Toolbar;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Grid
extends GridColumn
implements DatasetBinder,
IDatasetDelegate {
    public static final String GRID = "grid";
    private GridSelectionCol gsc = new GridSelectionCol();
    public static final String NAVBAR_NONE = "";
    public static final String NAVBAR_SIMPLE = "simple";
    public static final String NAVBAR_COMPLEX = "complex";
    public static final String NAVBAR = "navBar";
    private Navbar navBar;

    public Grid() {
        this.setSize(750, 380);
        this.navBar = new Navbar();
        Dataset dataset = new Dataset();
        dataset.setComponentType("resultdataset");
        this.setDataset(dataset);
        this.setSectionType("SECTION_TYPE_RESULT");
        this.setComponentType(GRID);
        this.setPrompt(NAVBAR_NONE);
    }

    public String getSelectionMode() {
        return this.gsc.getSelectionMode();
    }

    @Override
    public void setDataset(Dataset dataset) {
        super.setDataset(dataset);
        dataset.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectionModel".equals(evt.getPropertyName())) {
                    Grid.this.setSelectionMode(Grid.NAVBAR_NONE + evt.getNewValue());
                }
            }
        });
        dataset.setOwner(this);
        this.setSelectionMode(this.getDataset().getSelectionMode());
    }

    public void setSelectionMode(String sm) {
        if (this.gsc.getSelectionMode().equals(sm)) {
            return;
        }
        this.gsc.setSelectionMode(sm);
        if (this.gsc.getSelectionMode().equals(NAVBAR_NONE)) {
            this.removeChild(this.gsc);
        } else {
            int idx = this.getChildren().indexOf(this.gsc);
            if (idx == -1) {
                this.addChild(this.gsc, 0);
            }
        }
    }

    public void setNavbarType(String type) {
        if (this.navBar == null) {
            return;
        }
        if (this.eq(this.getNavBarType(), type)) {
            return;
        }
        this.navBar.setNavBarType(type);
        if (this.eq(this.getNavBarType(), NAVBAR_NONE)) {
            this.removeChild(this.navBar);
        } else {
            int idx = this.getChildren().indexOf(this.navBar);
            if (idx == -1) {
                this.addChild(this.navBar, this.getChildren().size());
            }
        }
    }

    @Override
    public void addChild(AuroraComponent ac, int idx) {
        int index;
        int index2;
        List<AuroraComponent> children = this.getChildren();
        int index1 = children.indexOf(this.navBar);
        if (index1 == -1) {
            index1 = children.size();
        }
        if ((index2 = children.indexOf(this.getToolbar())) == -1) {
            index2 = index1;
        }
        if (idx > (index = Math.min(index1, index2)) || idx == 0 && children.indexOf(this.gsc) != -1) {
            idx = index;
        }
        if (ac instanceof Toolbar) {
            idx = children.size();
        }
        super.addChild(ac, idx);
    }

    protected void print(GridColumn gc, String prefix) {
        List<AuroraComponent> cs = gc.getChildren();
        for (AuroraComponent ac : cs) {
            if (ac.getClass().equals(GridColumn.class)) {
                GridColumn gc1 = (GridColumn)ac;
                System.out.println(String.valueOf(prefix) + ac.getClass().getSimpleName() + "    " + gc1.getPrompt());
                this.print(gc1, String.valueOf(prefix) + "    ");
                continue;
            }
            System.out.println(String.valueOf(prefix) + ac.getClass().getSimpleName());
        }
    }

    public boolean hasNavBar() {
        return this.getChildren().indexOf(this.navBar) != -1;
    }

    public boolean hasToolbar() {
        return this.getToolbar() != null;
    }

    public Toolbar getToolbar() {
        return (Toolbar)this.getFirstChild(Toolbar.class);
    }

    public void setToolbar(Toolbar tl) {
        this.addChild(tl, 0);
    }

    public boolean hasSelectionCol() {
        return this.getChildren().indexOf(this.gsc) != -1;
    }

    public List<Button> getToobarButtons() {
        return this.getToolbar() != null ? this.getToolbar().getButtons() : Collections.EMPTY_LIST;
    }

    @Override
    public boolean isResponsibleChild(AuroraComponent child) {
        if (child instanceof Toolbar || child instanceof Navbar) {
            return this.getFirstChild(child.getClass()) == null;
        }
        if (child instanceof GridSelectionCol) {
            return true;
        }
        if (child instanceof Grid) {
            return false;
        }
        return super.isResponsibleChild(child);
    }

    @Override
    public Object getPropertyValue(String propName) {
        if ("navBarType".equals(propName)) {
            return this.getNavBarType();
        }
        if ("toolbar".equals(propName)) {
            return this.getToolbar();
        }
        if ("component_children".equals(propName)) {
            return this.getCols();
        }
        return super.getPropertyValue(propName);
    }

    private List<AuroraComponent> getCols() {
        List<AuroraComponent> children = this.getChildren();
        ArrayList<AuroraComponent> cols = new ArrayList<AuroraComponent>();
        for (AuroraComponent c : children) {
            if (!"gridcolumn".equals(c.getComponentType())) continue;
            cols.add(c);
        }
        return cols;
    }

    public String getNavBarType() {
        if (this.navBar == null) {
            return NAVBAR_NONE;
        }
        return this.navBar.getNavBarType();
    }

    @Override
    public void setPropertyValue(String propName, Object val) {
        if ("navBarType".equals(propName)) {
            this.setNavbarType(NAVBAR_NONE + val);
        }
        if ("toolbar".equals(propName) && val instanceof Toolbar) {
            this.setToolbar((Toolbar)val);
        }
        if ("component_children".equals(propName) && val instanceof List) {
            for (AuroraComponent c : (List)val) {
                if (!(c instanceof GridColumn)) continue;
                this.addCol((GridColumn)c);
            }
            return;
        }
        super.setPropertyValue(propName, val);
    }
}

