/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.spnego;

import aurora.plugin.spnego.DelegateServletRequest;
import aurora.plugin.spnego.SpnegoPrincipal;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.ietf.jgss.GSSCredential;

public class SpnegoHttpServletRequest
extends HttpServletRequestWrapper
implements DelegateServletRequest {
    private final transient SpnegoPrincipal principal;

    public SpnegoHttpServletRequest(HttpServletRequest request, SpnegoPrincipal spnegoPrincipal) {
        super(request);
        this.principal = spnegoPrincipal;
    }

    public String getAuthType() {
        String header = this.getHeader("Authorization");
        String authType = header.startsWith("Negotiate") ? "Negotiate" : (header.startsWith("Basic") ? "Basic" : super.getAuthType());
        return authType;
    }

    @Override
    public GSSCredential getDelegatedCredential() {
        return this.principal.getDelegatedCredential();
    }

    public String getRemoteUser() {
        if (this.principal == null) {
            return super.getRemoteUser();
        }
        String[] username = this.principal.getName().split("@", 2);
        return username[0];
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }
}

