/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.swt.util.viewer;

import aurora.ide.swt.util.GridLayoutUtil;
import aurora.ide.swt.util.TableContentProvider;
import aurora.ide.swt.util.TableLabelProvider;
import aurora.ide.swt.util.WidgetFactory;
import aurora.ide.swt.util.viewer.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class CTableViewer {
    private List<Object> input = new ArrayList<Object>();
    private List<Tl> columns = new ArrayList<Tl>();
    private TableContentProvider tableContentProvider;
    private TableLabelProvider tableLabelProvider;

    public TableViewer createContentTable(final Composite tableComposite) {
        final TableViewer tv = new TableViewer(tableComposite, 68352);
        Table table = tv.getTable();
        this.configure(tv);
        this.createTableColumn(table);
        Composite buttonComposite = WidgetFactory.composite(tableComposite);
        buttonComposite.setLayout((Layout)GridLayoutUtil.COLUMN_LAYOUT_1);
        buttonComposite.setLayoutData((Object)new GridData(1040));
        Button add = WidgetFactory.button(buttonComposite, Messages.CTableViewer_0);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTableViewer.this.clickAddButton(tableComposite.getShell(), tv);
            }
        });
        Button del = WidgetFactory.button(buttonComposite, Messages.CTableViewer_1);
        del.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTableViewer.this.clickDelButton(tv);
            }
        });
        Button up = WidgetFactory.button(buttonComposite, Messages.CTableViewer_2);
        up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTableViewer.this.moveElement(tv, -1);
            }
        });
        Button down = WidgetFactory.button(buttonComposite, Messages.CTableViewer_3);
        down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTableViewer.this.moveElement(tv, 1);
            }
        });
        this.setInput(tv);
        return tv;
    }

    protected void setInput(TableViewer tv) {
        tv.setInput(this.getTableInput());
    }

    protected void configure(TableViewer tv) {
        Table table = tv.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        tv.setContentProvider((IContentProvider)this.getContentProvider());
        tv.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
    }

    protected TableContentProvider getContentProvider() {
        return this.tableContentProvider == null ? new TableContentProvider() : this.tableContentProvider;
    }

    protected TableLabelProvider getLabelProvider() {
        return this.tableLabelProvider == null ? new TableLabelProvider() : this.tableLabelProvider;
    }

    protected void createTableColumn(Table table) {
        for (Tl t : this.columns) {
            TableColumn column1 = new TableColumn(table, t.style);
            column1.setWidth(t.width);
            column1.setText(t.text);
        }
    }

    public void moveElement(TableViewer tv, int i) {
        ISelection s = tv.getSelection();
        if (s instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)s;
            Object r1 = ss.getFirstElement();
            int idx = this.getTableInput().indexOf(r1);
            if (idx == -1) {
                return;
            }
            int idx2 = idx + i;
            if (idx2 < 0 || idx2 == this.getTableInput().size()) {
                return;
            }
            Object r2 = this.getTableInput().get(idx2);
            this.getTableInput().set(idx2, r1);
            this.getTableInput().set(idx, r2);
            this.setInput(tv);
        }
    }

    protected List<Object> getTableInput() {
        return this.getInput();
    }

    protected void clickAddButton(Shell shell, TableViewer tv) {
        FileDialog dialog = new FileDialog(shell, 4096);
        dialog.setText("Open File");
        dialog.setFilterExtensions(new String[]{"*.uip"});
        String path = dialog.open();
        if (path != null && path.length() > 0) {
            this.getTableInput().add(path);
        }
        this.setInput(tv);
    }

    protected void clickDelButton(TableViewer tv) {
        ISelection s = tv.getSelection();
        if (s instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)s;
            List list = ss.toList();
            this.getTableInput().removeAll(list);
            this.setInput(tv);
        }
    }

    public List<Object> getInput() {
        return this.input;
    }

    public void setInput(List<Object> input) {
        this.input = input;
    }

    public void addColumn(String text, int width) {
        this.columns.add(new Tl(text, width));
    }

    public TableContentProvider getTableContentProvider() {
        return this.tableContentProvider;
    }

    public void setTableContentProvider(TableContentProvider tableContentProvider) {
        this.tableContentProvider = tableContentProvider;
    }

    public TableLabelProvider getTableLabelProvider() {
        return this.tableLabelProvider;
    }

    public void setTableLabelProvider(TableLabelProvider tableLabelProvider) {
        this.tableLabelProvider = tableLabelProvider;
    }

    public class Tl {
        String text;
        int width;
        int style = 0;

        public Tl(String text, int width) {
            this.text = text;
            this.width = width;
        }
    }
}

