/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.api.composite.map;

import aurora.ide.api.composite.map.CommentCompositeMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.CompositeUtil;
import uncertain.composite.XMLOutputter;
import uncertain.util.XMLWritter;

public class CommentXMLOutputter
extends XMLOutputter {
    public static final String CDATA_END = "]]>";
    public static final String CDATA_BEGIN = "<![CDATA[";
    public static final String DEFAULT_INDENT = "    ";
    boolean mUseNewLine;
    String mIndentString;
    boolean mGenerateCdata = true;
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static XMLOutputter default_inst = new CommentXMLOutputter("    ", true);

    public static XMLOutputter defaultInstance() {
        return default_inst;
    }

    public CommentXMLOutputter() {
        this.mIndentString = DEFAULT_INDENT;
        this.mUseNewLine = true;
    }

    public CommentXMLOutputter(String _indent, boolean _new_line) {
        this.mIndentString = _indent;
        this.mUseNewLine = _new_line;
    }

    String getIndentString(int level) {
        StringBuilder pre_indent = new StringBuilder();
        if (this.mIndentString != null) {
            int i = 0;
            while (i < level) {
                pre_indent.append(this.mIndentString);
                ++i;
            }
        }
        return pre_indent.toString();
    }

    static void getAttributeXML(Map map, StringBuilder attribs) {
        Iterator it = map.entrySet().iterator();
        HashMap<String, String> strings = new HashMap<String, String>();
        ArrayList<String> keyList = new ArrayList<String>();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            strings.put(key.toString(), value.toString());
            keyList.add(key.toString());
        }
        Object[] keys = keyList.toArray();
        keys = CommentXMLOutputter.sortKey(keys);
        int i = 0;
        while (i < keys.length) {
            attribs.append(" ").append(XMLWritter.getAttrib((String)keys[i].toString(), (String)strings.get(keys[i]).toString()));
            ++i;
        }
    }

    private static Object[] sortKey(Object[] keys) {
        if (keys == null) {
            return null;
        }
        ArrayList<String> keyColumnList = new ArrayList<String>();
        keyColumnList.add("id");
        keyColumnList.add("name");
        Arrays.sort(keys);
        LinkedList<String> list = new LinkedList<String>();
        int i = 0;
        while (i < keys.length) {
            String keyStr = keys[i].toString();
            if (keyColumnList.contains(keyStr)) {
                list.add(0, keyStr);
            } else {
                list.add(keyStr);
            }
            ++i;
        }
        return list.toArray();
    }

    void getChildXML(int level, List childs, StringBuilder buf, Map namespaces, Map prefix_mapping) {
        if (childs == null) {
            return;
        }
        for (CompositeMap map : childs) {
            buf.append(this.toXMLWithPrefixMapping(level, map, namespaces, prefix_mapping));
        }
    }

    static Map addRef(Map namespaces, String uri, CompositeMap map) {
        Integer count;
        if (uri == null) {
            return namespaces;
        }
        if (namespaces == null) {
            namespaces = new HashMap<String, Integer>();
        }
        Integer new_count = (count = (Integer)namespaces.get(map.getNamespaceURI())) != null ? new Integer(count + 1) : new Integer(1);
        namespaces.put(((CommentCompositeMap)map).namespace_uri, new_count);
        return namespaces;
    }

    static void subRef(Map map, String uri) {
        if (uri == null) {
            return;
        }
        Integer count = (Integer)map.get(uri);
        if (count != null) {
            int value = count - 1;
            if (value <= 0) {
                map.remove(uri);
            } else {
                map.put(uri, new Integer(value));
            }
        }
    }

    public String toXML(CompositeMap map) {
        return this.toXML(map, false);
    }

    public String toXML(CompositeMap map, boolean namespace_in_root) {
        if (namespace_in_root) {
            Map prefix_mapping = CompositeUtil.getPrefixMapping((CompositeMap)map);
            return this.toXMLWithPrefixMapping(0, map, null, prefix_mapping);
        }
        return this.toXMLWithPrefixMapping(0, map, null, null);
    }

    static StringBuilder appendNamespace(StringBuilder buf, Map prefix_mapping) {
        for (Map.Entry entry : prefix_mapping.entrySet()) {
            String namespace = (String)entry.getKey();
            String prefix = (String)entry.getValue();
            buf.append(" xmlns:").append(prefix).append("=\"").append(namespace).append("\"");
        }
        return buf;
    }

    String toXMLWithPrefixMapping(int level, CompositeMap map, Map namespaces, Map prefix_mapping) {
        String comment;
        StringBuilder attribs = new StringBuilder();
        StringBuilder childs = new StringBuilder();
        StringBuilder xml = new StringBuilder();
        String indent_str = this.getIndentString(level);
        String namespace_uri = map.getNamespaceURI();
        StringBuilder xmlns_declare = null;
        boolean need_new_line_local = this.mUseNewLine;
        if (prefix_mapping == null && namespace_uri != null) {
            boolean uri_exists = false;
            if (namespaces != null) {
                boolean bl = uri_exists = namespaces.get(namespace_uri) != null;
            }
            if (!uri_exists) {
                String xmlns = "xmlns";
                if (map.getPrefix() != null) {
                    xmlns = "xmlns:" + map.getPrefix();
                }
                attribs.append(" ").append(XMLWritter.getAttrib((String)xmlns, (String)namespace_uri));
            }
            namespaces = CommentXMLOutputter.addRef(namespaces, namespace_uri, map);
        }
        if ((comment = this.getComment(level, map)) != null) {
            xml.append(comment);
        }
        CommentXMLOutputter.getAttributeXML((Map)map, attribs);
        String endElementComment = this.getEndElementComment(level + 1, map);
        if (map.getChilds() == null || map.getChilds().size() == 0) {
            if (endElementComment != null) {
                childs.append(LINE_SEPARATOR).append(endElementComment);
            }
            if (map.getText() != null) {
                need_new_line_local = false;
                if (this.mGenerateCdata) {
                    childs.append(CDATA_BEGIN).append(map.getText()).append(CDATA_END);
                } else {
                    childs.append(XMLWritter.escape((String)map.getText()));
                }
            }
        } else {
            this.getChildXML(level + 1, map.getChilds(), childs, namespaces, prefix_mapping);
            if (endElementComment != null) {
                childs.append(endElementComment).append(LINE_SEPARATOR);
            }
        }
        if (prefix_mapping == null) {
            CommentXMLOutputter.subRef(namespaces, namespace_uri);
        }
        String elm = null;
        if (prefix_mapping == null) {
            elm = map.getRawName();
        } else {
            elm = map.getName();
            if (namespace_uri != null) {
                String prefix = (String)prefix_mapping.get(namespace_uri);
                elm = String.valueOf(prefix) + ":" + elm;
            }
            if (level == 0) {
                xmlns_declare = new StringBuilder();
                CommentXMLOutputter.appendNamespace(xmlns_declare, prefix_mapping);
            }
        }
        xml.append(indent_str).append('<').append(elm);
        if (xmlns_declare != null) {
            xml.append((CharSequence)xmlns_declare);
        }
        xml.append((CharSequence)attribs);
        if (childs.length() > 0) {
            xml.append('>');
            if (need_new_line_local) {
                xml.append(LINE_SEPARATOR);
            }
            xml.append((CharSequence)childs);
            if (need_new_line_local) {
                xml.append(indent_str);
            }
            xml.append(XMLWritter.endTag((String)elm));
        } else {
            xml.append("/>");
        }
        if (this.mUseNewLine) {
            xml.append(LINE_SEPARATOR);
        }
        return xml.toString();
    }

    private String getComment(int level, CompositeMap map) {
        if (map instanceof CommentCompositeMap) {
            StringBuilder xml = new StringBuilder();
            String indent_str = this.getIndentString(level);
            if (((CommentCompositeMap)map).getComment() != null) {
                String[] comms = ((CommentCompositeMap)map).getComment().split("-->");
                int i = 0;
                while (i < comms.length) {
                    String comm = comms[i];
                    String fullComm = "<!--" + comm + "-->";
                    xml.append(indent_str).append(fullComm).append(LINE_SEPARATOR);
                    ++i;
                }
            } else {
                return null;
            }
            return xml.toString();
        }
        return "";
    }

    private String getEndElementComment(int level, CompositeMap map) {
        if (map instanceof CommentCompositeMap) {
            StringBuilder xml = new StringBuilder();
            String indent_str = this.getIndentString(level);
            if (((CommentCompositeMap)map).getEndElementComment() != null) {
                String[] comms = ((CommentCompositeMap)map).getEndElementComment().split("-->");
                int i = 0;
                while (i < comms.length) {
                    String comm = comms[i];
                    String fullComm = "<!--" + comm + "-->";
                    if (i > 0) {
                        xml.append(LINE_SEPARATOR);
                    }
                    xml.append(indent_str).append(fullComm);
                    ++i;
                }
            } else {
                return null;
            }
            return xml.toString();
        }
        return "";
    }

    public static void saveToFile(File target_file, CompositeMap map) throws IOException {
        CommentXMLOutputter.saveToFile(target_file, map, "UTF-8");
    }

    public static void saveToFile(File target_file, CompositeMap map, String encoding) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(target_file);
            String xml_decl = "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n";
            os.write(xml_decl.getBytes());
            String content = CommentXMLOutputter.defaultInstance().toXML(map, true);
            os.write(content.getBytes(encoding));
            os.flush();
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    public boolean isUseNewLine() {
        return this.mUseNewLine;
    }

    public void setUseNewLine(boolean useNewLine) {
        this.mUseNewLine = useNewLine;
    }

    public String getIndentString() {
        return this.mIndentString;
    }

    public void setIndentString(String indentString) {
        this.mIndentString = indentString;
    }

    public boolean isGenerateCdata() {
        return this.mGenerateCdata;
    }

    public void setGenerateCdata(boolean generateCdata) {
        this.mGenerateCdata = generateCdata;
    }
}

