/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.bm.editor;

import aurora.bm.IModelFactory;
import aurora.database.service.BusinessModelService;
import aurora.database.service.BusinessModelServiceContext;
import aurora.database.service.DatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.api.composite.map.CommentXMLOutputter;
import aurora.ide.bm.AuroraDataBase;
import aurora.ide.bm.editor.IDEModelFactory;
import aurora.ide.bm.editor.toolbar.action.ExecuteSqlAction;
import aurora.ide.editor.core.ISqlViewer;
import aurora.ide.editor.textpage.ColorManager;
import aurora.ide.editor.textpage.SQLConfiguration;
import aurora.ide.editor.textpage.format.SQLFormat;
import aurora.ide.editor.widgets.GridViewer;
import aurora.ide.fake.uncertain.engine.FakeUncertainEngine;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraResourceUtil;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.DBConnectionUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.ExceptionUtil;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.helpers.SystemException;
import aurora.ide.search.cache.CacheManager;
import java.io.File;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.event.Configuration;
import uncertain.logging.ILoggerProvider;
import uncertain.logging.LoggerProvider;
import uncertain.logging.LoggingContext;
import uncertain.ocm.ObjectRegistryImpl;

public class SQLExecutePage
extends FormPage
implements ISqlViewer {
    private static final String PageId = "SQLExecutePage";
    private static final String PageTitle = LocaleMessage.getString("auto.sql.test");
    private CTabFolder tabFolder;
    private SashForm sashForm;
    private Connection connection;
    private ToolBarManager toolBarManager;
    private static final String[] tabs = new String[]{"query", "insert", "update", "delete"};
    private FakeUncertainEngine uncertainEngine;
    private BusinessModelService modelService;
    private ViewForm viewForm;
    private GridViewer tableViewer;
    private boolean modify = false;

    public SQLExecutePage(FormEditor editor) {
        super(editor, PageId, PageTitle);
    }

    public SQLExecutePage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public SQLExecutePage(String id, String title) {
        super(id, title);
    }

    public void addActions(IAction[] actions) {
        if (actions == null) {
            return;
        }
        int i = 0;
        while (i < actions.length) {
            this.toolBarManager.add((IContributionItem)this.createActionContributionItem(actions[i]));
            ++i;
        }
        this.toolBarManager.update(true);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getSql() {
        if (this.tabFolder.getSelection() != null) {
            StyledText st = (StyledText)this.tabFolder.getSelection().getControl();
            return st.getText();
        }
        return null;
    }

    public boolean isModify() {
        return this.modify;
    }

    public void refresh(ResultSet resultSet, int resultCount) {
        if (resultSet != null) {
            try {
                this.creatTableViewer((Composite)this.sashForm, resultSet);
                this.sashForm.layout();
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
                return;
            }
        }
        if (resultCount != 0) {
            if (this.tableViewer != null && this.tableViewer.getControl() != null) {
                this.tableViewer.getControl().setVisible(false);
                this.sashForm.layout();
            }
            String sql = this.getSql().split(" ")[0];
            int message = DialogUtil.showConfirmDialogBox(String.valueOf(LocaleMessage.getString("are.you.sure.want.to")) + sql + " " + resultCount + LocaleMessage.getString("records") + "?");
            try {
                if (message == 32) {
                    this.connection.commit();
                } else {
                    this.connection.rollback();
                }
            }
            catch (SQLException e) {
                DialogUtil.showExceptionMessageBox(e);
            }
        }
    }

    public void refresh(String content) throws ApplicationException {
        if (this.uncertainEngine == null || !this.isModify()) {
            return;
        }
        this.modelService = this.makeBusinessModelService(this.uncertainEngine, this.connection, content);
        int i = 0;
        while (i < tabs.length) {
            StyledText st = (StyledText)this.tabFolder.getItem(i).getControl();
            try {
                SQLFormat sf = new SQLFormat();
                st.setText(sf.format(this.modelService.getSql(tabs[i]).toString()));
            }
            catch (Throwable e) {
                st.setText(ExceptionUtil.getExceptionTraceMessage(e));
            }
            ++i;
        }
        if (this.tableViewer != null && this.tableViewer.getControl() != null) {
            this.tableViewer.getControl().setVisible(false);
            this.sashForm.layout();
        }
        this.setModify(false);
    }

    public void setActions(IAction[] actions) {
        this.toolBarManager.removeAll();
        if (actions == null) {
            return;
        }
        int i = 0;
        while (i < actions.length) {
            this.toolBarManager.add((IContributionItem)this.createActionContributionItem(actions[i]));
            ++i;
        }
        this.toolBarManager.update(true);
    }

    public void setModify(boolean modify) {
        this.modify = modify;
    }

    protected void createContent(Composite shell, FormToolkit toolkit) throws ApplicationException {
        this.viewForm = new ViewForm(shell, 0);
        this.viewForm.setLayout((Layout)new FillLayout());
        this.createToolbar(this.viewForm);
        this.sashForm = new SashForm((Composite)this.viewForm, 512);
        this.createSqlContent((Composite)this.sashForm);
        this.createResultContent((Composite)this.sashForm);
        this.sashForm.setWeights(new int[]{30, 70});
        this.viewForm.setContent((Control)this.sashForm);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        Composite shell = form.getBody();
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        try {
            this.initConnection();
            this.createContent(shell, toolkit);
        }
        catch (ApplicationException e) {
            DialogUtil.showExceptionMessageBox(e);
        }
    }

    protected void createResultContent(Composite parent) throws ApplicationException {
        this.tableViewer = new GridViewer();
        this.tableViewer.createViewer(parent);
        this.tableViewer.getControl().setVisible(false);
    }

    protected File getFile() {
        IFile ifile = ((IFileEditorInput)this.getEditor().getEditorInput()).getFile();
        String fileName = AuroraResourceUtil.getIfileLocalPath(ifile);
        return new File(fileName);
    }

    protected void initConnection() throws ApplicationException {
        String content;
        IFile file = ((IFileEditorInput)this.getEditor().getEditorInput()).getFile();
        IProject project = file.getProject();
        AuroraDataBase ad = new AuroraDataBase(project);
        String datasourceName = null;
        try {
            CompositeMap cMap = CacheManager.getWholeBMCompositeMap(file);
            datasourceName = CompositeMapUtil.getValueIgnoreCase(cMap, "dataSourceName");
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        this.connection = ad.getDBConnection(datasourceName);
        try {
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new SystemException(e);
        }
        this.uncertainEngine = DBConnectionUtil.getFakeUncertainEngine(project);
        if (!this.uncertainEngine.isRunning()) {
            this.uncertainEngine.startup();
        }
        try {
            content = CommentXMLOutputter.defaultInstance().toXML(AuroraResourceUtil.getCompsiteLoader().loadByFullFilePath(this.getFile().getAbsolutePath()), true);
        }
        catch (Throwable e) {
            throw new SystemException(e);
        }
        this.modelService = this.makeBusinessModelService(this.uncertainEngine, this.connection, content);
    }

    private ActionContributionItem createActionContributionItem(IAction action) {
        ActionContributionItem aci = new ActionContributionItem(action);
        aci.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        return aci;
    }

    private String[] createColumnProperties(ResultSet resultSet) throws SystemException {
        String[] column_index = null;
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            column_index = new String[resultSetMetaData.getColumnCount()];
            int i = 1;
            while (i <= resultSetMetaData.getColumnCount()) {
                column_index[i - 1] = resultSetMetaData.getColumnName(i);
                ++i;
            }
        }
        catch (SQLException e) {
            throw new SystemException(e);
        }
        return column_index;
    }

    private BusinessModelServiceContext createContext(FakeUncertainEngine uncertainEngine, Connection connection) {
        Configuration rootConfig = uncertainEngine.createConfig();
        rootConfig.addParticipant((Object)this);
        CommentCompositeMap context = new CommentCompositeMap("root");
        BusinessModelServiceContext bc = (BusinessModelServiceContext)DynamicObject.cast((CompositeMap)context, BusinessModelServiceContext.class);
        bc.setConfig(rootConfig);
        bc.setConnection(connection);
        LoggerProvider lp = LoggerProvider.createInstance((Level)Level.FINE, (OutputStream)System.out);
        LoggingContext.setLoggerProvider((CompositeMap)context, (ILoggerProvider)lp);
        SqlServiceContext sc = SqlServiceContext.createSqlServiceContext((CompositeMap)context);
        sc.setTrace(true);
        return bc;
    }

    private void createSqlContent(Composite parent) throws SystemException {
        this.tabFolder = this.createTabFolder(parent);
        String TabHeighGrab = "           ";
        int i = 0;
        while (i < tabs.length) {
            this.tabFolder.getItem(i).setText("           " + tabs[i] + "           ");
            SourceViewer textSection = new SourceViewer((Composite)this.tabFolder, null, 576);
            textSection.configure((SourceViewerConfiguration)new SQLConfiguration(new ColorManager()));
            Document document = new Document();
            textSection.setDocument((IDocument)document);
            final StyledText st = textSection.getTextWidget();
            this.tabFolder.getItem(i).setControl(textSection.getControl());
            final int itemIndex = i++;
            this.tabFolder.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    if (SQLExecutePage.this.tabFolder.getSelectionIndex() == itemIndex && st.getText() != null && !st.getText().equals("")) {
                        return;
                    }
                    try {
                        StringBuffer sqlbf = SQLExecutePage.this.modelService.getSql(tabs[itemIndex]);
                        String sql = sqlbf.toString();
                        if (sqlbf != null) {
                            SQLFormat sf = new SQLFormat();
                            st.setText(sf.format(sql));
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                        st.setText(ExceptionUtil.getExceptionTraceMessage(ex));
                    }
                }
            });
        }
        this.tabFolder.layout(true);
    }

    private CTabFolder createTabFolder(final Composite parent) {
        final CTabFolder tabFolder = new CTabFolder(parent, 2816);
        tabFolder.setMaximizeVisible(true);
        tabFolder.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (tabFolder.getMaximized()) {
                    tabFolder.setMaximized(false);
                    SQLExecutePage.this.sashForm.setMaximizedControl(null);
                    parent.layout(true);
                } else {
                    tabFolder.setMaximized(true);
                    SQLExecutePage.this.sashForm.setMaximizedControl((Control)tabFolder);
                    parent.layout(true);
                }
            }
        });
        tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void maximize(CTabFolderEvent event) {
                tabFolder.setMaximized(true);
                SQLExecutePage.this.sashForm.setMaximizedControl((Control)tabFolder);
                parent.layout(true);
            }

            public void minimize(CTabFolderEvent event) {
                tabFolder.setMinimized(true);
                tabFolder.setLayoutData((Object)new GridData(4, 4, true, false));
                parent.layout(true);
            }

            public void restore(CTabFolderEvent event) {
                tabFolder.setMaximized(false);
                SQLExecutePage.this.sashForm.setMaximizedControl(null);
                parent.layout(true);
            }
        });
        tabFolder.setSimple(false);
        tabFolder.setTabHeight(23);
        int i = 0;
        while (i < tabs.length) {
            new CTabItem(tabFolder, 256);
            ++i;
        }
        return tabFolder;
    }

    private void createToolbar(ViewForm viewForm) {
        ToolBar toolBar = new ToolBar((Composite)viewForm, 0x820000);
        this.toolBarManager = new ToolBarManager(toolBar);
        ExecuteSqlAction action = new ExecuteSqlAction(this, ExecuteSqlAction.getDefaultImageDescriptor(), null);
        this.addActions((IAction[])new Action[]{action});
        viewForm.setTopLeft((Control)toolBar);
    }

    private void creatTableViewer(Composite parent, ResultSet resultSet) throws ApplicationException {
        this.tableViewer.clearAll(false);
        this.tableViewer.createViewer(parent);
        this.tableViewer.getControl().setVisible(true);
        String[] ColumnProperties = this.createColumnProperties(resultSet);
        this.tableViewer.setColumnNames(ColumnProperties);
        CompositeMap input = this.getInput(resultSet, ColumnProperties);
        this.tableViewer.setData(input);
        this.tableViewer.packColumns();
    }

    private CompositeMap getInput(ResultSet tableRet, String[] ColumnProperties) throws SystemException {
        CommentCompositeMap input = new CommentCompositeMap();
        try {
            while (tableRet.next()) {
                CommentCompositeMap element = new CommentCompositeMap();
                int i = 0;
                while (i < ColumnProperties.length) {
                    element.put(ColumnProperties[i], tableRet.getObject(ColumnProperties[i]));
                    ++i;
                }
                input.addChild(element);
            }
        }
        catch (SQLException e) {
            throw new SystemException(e);
        }
        return input;
    }

    private BusinessModelService makeBusinessModelService(FakeUncertainEngine uncertainEngine, Connection connection, String content) throws ApplicationException {
        ObjectRegistryImpl reg = uncertainEngine.getObjectRegistry();
        DatabaseServiceFactory svcFactory = (DatabaseServiceFactory)reg.getInstanceOfType(DatabaseServiceFactory.class);
        BusinessModelServiceContext bc = this.createContext(uncertainEngine, connection);
        CompositeMap context = bc.getObjectContext();
        IDEModelFactory modelFactory = new IDEModelFactory(uncertainEngine.getOc_manager(), ((IFileEditorInput)this.getEditor().getEditorInput()).getFile());
        uncertainEngine.getObjectRegistry().registerInstanceOnce(IModelFactory.class, (Object)modelFactory);
        svcFactory.setModelFactory((IModelFactory)modelFactory);
        svcFactory.updateSqlCreator((IModelFactory)modelFactory);
        try {
            CompositeMap bm_model = svcFactory.getModelFactory().getCompositeLoader().loadFromString(content, "UTF-8");
            BusinessModelService service = svcFactory.getModelService(bm_model, context);
            return service;
        }
        catch (Throwable e) {
            throw new SystemException(e);
        }
    }
}

