/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.bm.wizard.sql;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.api.composite.map.CommentXMLOutputter;
import aurora.ide.bm.AuroraDataBase;
import aurora.ide.bm.wizard.sql.BMFromSQLWizardPage;
import aurora.ide.bm.wizard.sql.CompositeMapTagParser;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraResourceUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.helpers.SystemException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import uncertain.composite.CompositeMap;
import uncertain.datatype.DataType;
import uncertain.datatype.DataTypeRegistry;

public class BMFromSQLWizard
extends Wizard
implements INewWizard {
    private static final String bm_pre = "bm";
    private BMFromSQLWizardPage mainPage;
    private ISelection selection;
    private CompositeMap initContent;

    public BMFromSQLWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.mainPage = new BMFromSQLWizardPage(this.selection);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        final String containerName = this.mainPage.getContainerName();
        final String fileName = this.mainPage.getFileName();
        this.initContent = this.createInitContent();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        BMFromSQLWizard.this.doFinish(containerName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        if (fileName.indexOf(".") == -1) {
            fileName = String.valueOf(fileName) + ".bm";
        }
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            DialogUtil.showErrorMessageBox("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream();
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (Throwable e) {
            DialogUtil.showExceptionMessageBox(e);
        }
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream() throws SystemException {
        String contents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + AuroraResourceUtil.LineSeparator + AuroraResourceUtil.getSign() + CommentXMLOutputter.defaultInstance().toXML(this.initContent, true);
        try {
            return new ByteArrayInputStream(contents.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SystemException(e);
        }
    }

    private CompositeMap createInitContent() {
        CommentCompositeMap model = new CommentCompositeMap(bm_pre, "http://www.aurora-framework.org/schema/bm", "model");
        CommentCompositeMap operations = new CommentCompositeMap(bm_pre, "http://www.aurora-framework.org/schema/bm", "operations");
        CommentCompositeMap operation = new CommentCompositeMap(bm_pre, "http://www.aurora-framework.org/schema/bm", "operation");
        operations.addChild(operation);
        model.addChild(operations);
        String sql = this.mainPage.getSQL();
        String operationName = "update";
        if (sql.toLowerCase().trim().startsWith("select")) {
            operationName = "query";
        }
        operation.put("name", operationName);
        if (operationName.equals("query")) {
            CommentCompositeMap query = new CommentCompositeMap(bm_pre, "http://www.aurora-framework.org/schema/bm", "query-sql");
            query.setText(sql);
            operation.addChild(query);
        } else {
            CommentCompositeMap update = new CommentCompositeMap(bm_pre, "http://www.aurora-framework.org/schema/bm", "update-sql");
            update.setText(sql);
            operation.addChild(update);
        }
        CompositeMapTagParser tagParser = new CompositeMapTagParser();
        CompositeMap parameters = tagParser.parse(sql);
        if (parameters.getChildsNotNull().size() > 0) {
            operation.addChild(parameters);
        }
        Connection dbConnection = null;
        try {
            dbConnection = this.getConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dbConnection == null || !operationName.equals("query")) {
            return model;
        }
        String fromClause = BMFromSQLWizard.getSelectClause(sql);
        if (fromClause == null) {
            return model;
        }
        String test = String.valueOf(fromClause) + " where 1<>1";
        CompositeMap selectedFields = null;
        try {
            Statement stmt = dbConnection.createStatement();
            ResultSet result = stmt.executeQuery(test);
            ResultSetMetaData rsMetaData = result.getMetaData();
            selectedFields = this.getSelectedFields(rsMetaData);
        }
        catch (SQLException e) {
            DialogUtil.showExceptionMessageBox(e);
        }
        if (selectedFields != null && selectedFields.getChildsNotNull().size() > 0) {
            model.addChild(selectedFields);
        }
        return model;
    }

    public Connection getConnection() throws ApplicationException {
        String containerName = this.mainPage.getContainerName();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            throw new ApplicationException(String.valueOf(LocaleMessage.getString("container")) + " \"" + containerName + "\"" + LocaleMessage.getString("not.exist"));
        }
        AuroraDataBase ad = new AuroraDataBase(resource.getProject());
        Connection conn = ad.getDBConnection();
        return conn;
    }

    private static String getSelectClause(String sql) {
        if (sql == null) {
            return null;
        }
        String upperCase = sql.toUpperCase();
        int fromIndex = upperCase.indexOf("FROM");
        if (fromIndex == -1) {
            return null;
        }
        int whereIndex = upperCase.indexOf("#WHERE_CLAUSE#", fromIndex);
        if (whereIndex == -1 && (whereIndex = upperCase.indexOf("WHERE", fromIndex)) == -1) {
            whereIndex = sql.length();
        }
        return sql.substring(0, whereIndex);
    }

    public static void main(String[] args) {
        String sql = "select empno, ename, deptno, hiredate from emp  e #WHERE_CLAUSE#";
        sql = BMFromSQLWizard.getSelectClause(sql);
        System.out.println(sql);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public CompositeMap getSelectedFields(ResultSetMetaData resultSetMetaData) throws SQLException {
        CommentCompositeMap fieldsArray = new CommentCompositeMap(bm_pre, "http://www.aurora-framework.org/schema/bm", "fields");
        int i = 1;
        while (i <= resultSetMetaData.getColumnCount()) {
            CommentCompositeMap field = new CommentCompositeMap(bm_pre, "http://www.aurora-framework.org/schema/bm", "field");
            String columnName = resultSetMetaData.getColumnName(i);
            field.put("name", columnName.toLowerCase());
            field.put("physicalName", columnName);
            if (resultSetMetaData.isNullable(i) == 0) {
                field.put("required", "true");
            }
            String dataType = resultSetMetaData.getColumnTypeName(i);
            field.put("databaseType", dataType);
            Integer db_data_type = new Integer(resultSetMetaData.getColumnType(i));
            DataTypeRegistry dtr = DataTypeRegistry.getInstance();
            DataType dt = dtr.getType(db_data_type.intValue());
            if (dt == null) {
                DialogUtil.showErrorMessageBox("field:" + columnName + " have a " + dataType + " which dataBase Type is " + db_data_type + " is not registried!");
            } else {
                field.put("datatype", dt.getJavaType().getName());
            }
            fieldsArray.addChild(field);
            ++i;
        }
        return fieldsArray;
    }
}

