/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.bm.wizard.table;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.bm.wizard.table.BMFromDBWizard;
import aurora.ide.celleditor.CellInfo;
import aurora.ide.celleditor.StringTextCellEditor;
import aurora.ide.editor.widgets.GridViewer;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LocaleMessage;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import uncertain.composite.CompositeMap;
import uncertain.datatype.DataType;
import uncertain.datatype.DataTypeRegistry;

public class BMFieldsPage
extends WizardPage {
    private Text containerText;
    private BMFromDBWizard wizard;
    private final String[] columnNames = new String[]{"COLUMN_NAME", "REMARKS", "IS_NULLABLE", "TYPE_NAME", "COLUMN_SIZE"};
    private final String[] columnTitles = new String[]{"\u5217\u540d", "\u63cf\u8ff0", "\u53ef\u7a7a", "\u7c7b\u578b", "\u5927\u5c0f"};
    private final int REMARKS_INDEX = 1;
    private final String[] excluedColumns = new String[]{"CREATED_BY", "CREATION_DATE", "LAST_UPDATED_BY", "LAST_UPDATE_DATE"};
    private DatabaseMetaData dbMetaData;
    private GridViewer gridViewer;

    public BMFieldsPage(ISelection selection, BMFromDBWizard bmWizard) {
        super("wizardPage");
        this.setTitle(LocaleMessage.getString("business.model.editor.file"));
        this.setDescription(LocaleMessage.getString("bm.wizard.desc"));
        this.wizard = bmWizard;
    }

    public void createControl(Composite parent) {
        this.dbMetaData = this.wizard.getDBMetaData();
        CompositeMap input = null;
        try {
            input = this.getInput(this.dbMetaData, "%");
        }
        catch (SQLException e) {
            DialogUtil.showExceptionMessageBox(e);
            return;
        }
        this.gridViewer = new GridViewer(this.columnNames, 322);
        Composite container = null;
        try {
            this.gridViewer.setColumnTitles(this.columnTitles);
            container = this.gridViewer.createViewer(parent);
            CellEditor[] celleditors = new CellEditor[this.columnNames.length];
            CellInfo cellProperties = new CellInfo(this.gridViewer, "REMARKS", false);
            StringTextCellEditor cellEditor = new StringTextCellEditor(cellProperties);
            celleditors[1] = cellEditor.getCellEditor();
            cellEditor.init();
            this.gridViewer.addEditor("REMARKS", cellEditor);
            this.gridViewer.setCellEditors(celleditors);
            this.gridViewer.setData(input);
        }
        catch (ApplicationException e) {
            DialogUtil.logErrorException(e);
        }
        this.setControl((Control)container);
        this.setPageComplete(true);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public CompositeMap getSelectedFields() throws ApplicationException {
        CommentCompositeMap fieldsArray = new CommentCompositeMap("bm", "http://www.aurora-framework.org/schema/bm", "fields");
        Object[] elements = this.gridViewer.getCheckedElements();
        int j = 0;
        while (j < elements.length) {
            CompositeMap record = (CompositeMap)elements[j];
            CommentCompositeMap field = new CommentCompositeMap("bm", "http://www.aurora-framework.org/schema/bm", "field");
            String fieldName = record.getString((Object)"COLUMN_NAME").toLowerCase();
            field.put("name", fieldName);
            field.put("physicalName", record.getString((Object)"COLUMN_NAME"));
            String dataType = record.getString((Object)"TYPE_NAME");
            field.put("databaseType", dataType);
            Integer db_data_type = record.getInt((Object)"DATA_TYPE");
            DataTypeRegistry dtr = DataTypeRegistry.getInstance();
            DataType dt = dtr.getType(db_data_type.intValue());
            if (dt == null) {
                DialogUtil.showErrorMessageBox(String.valueOf(LocaleMessage.getString("database.datatype")) + db_data_type + LocaleMessage.getString("is.not.registried"));
            } else {
                field.put("datatype", dt.getJavaType().getName());
            }
            String prompt = record.getString((Object)"REMARKS");
            String prompt_code = String.valueOf(this.wizard.getTableName().toUpperCase()) + "." + fieldName.toUpperCase();
            field.put("prompt", prompt_code);
            if (prompt != null) {
                this.wizard.addPrompt(prompt_code, prompt);
            }
            fieldsArray.addChild(field);
            ++j;
        }
        return fieldsArray;
    }

    public void refresh() throws ApplicationException {
        CompositeMap input = null;
        try {
            input = this.getInput(this.dbMetaData, "%");
        }
        catch (SQLException e) {
            DialogUtil.showExceptionMessageBox(e);
        }
        this.gridViewer.setData(input);
        this.gridViewer.refresh(false);
    }

    private CompositeMap getInput(DatabaseMetaData DBMetaData, String tableNamePattern) throws SQLException {
        ArrayList<String> excluedColumnList = new ArrayList<String>();
        int i = 0;
        while (i < this.excluedColumns.length) {
            String column = this.excluedColumns[i];
            if (column != null) {
                excluedColumnList.add(column);
            }
            ++i;
        }
        CommentCompositeMap input = new CommentCompositeMap();
        String tableName = this.wizard.getTableName();
        if (tableName == null) {
            this.setPageComplete(false);
            return input;
        }
        this.setPageComplete(true);
        ResultSet tableRet = DBMetaData.getColumns(null, DBMetaData.getUserName(), tableName, "%");
        while (tableRet.next()) {
            CommentCompositeMap element = new CommentCompositeMap();
            String columnName = tableRet.getString(this.columnNames[0]);
            if (excluedColumnList.contains(columnName)) continue;
            element.put(this.columnNames[0], columnName);
            element.put(this.columnNames[1], tableRet.getString(this.columnNames[1]));
            element.put(this.columnNames[2], tableRet.getString(this.columnNames[2]));
            element.put(this.columnNames[3], tableRet.getString(this.columnNames[3]));
            element.put(this.columnNames[4], new Integer(tableRet.getInt(this.columnNames[4])));
            element.put("DATA_TYPE", new Integer(tableRet.getInt("DATA_TYPE")));
            input.addChild(element);
        }
        return input;
    }
}

