/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.bm.wizard.table;

import aurora.ide.bm.wizard.table.BMFromDBWizard;
import aurora.ide.editor.widgets.WizardPageRefreshable;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LocaleMessage;
import java.sql.Connection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class BMMainConfigPage
extends WizardPageRefreshable {
    private Text containerText;
    private ISelection selection;
    private BMFromDBWizard wizard;
    private Button autoRegisterPromptButton;

    public BMMainConfigPage(ISelection selection, BMFromDBWizard bmWizard) {
        super("wizardPage");
        this.setTitle(LocaleMessage.getString("business.model.editor.file"));
        this.setDescription(LocaleMessage.getString("bm.wizard.desc"));
        this.selection = selection;
        this.wizard = bmWizard;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(LocaleMessage.getString("container"));
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BMMainConfigPage.this.checkPageValues();
            }
        });
        Button button = new Button(container, 8);
        button.setText(LocaleMessage.getString("openBrowse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] result;
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(BMMainConfigPage.this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, LocaleMessage.getString("select.new.file.container"));
                if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
                    BMMainConfigPage.this.containerText.setText(((Path)result[0]).toString());
                }
            }
        });
        this.autoRegisterPromptButton = new Button(container, 32);
        this.autoRegisterPromptButton.setText("\u5411\u6570\u636e\u5e93\u81ea\u52a8\u6ce8\u518c\u5b57\u6bb5\u63cf\u8ff0");
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.autoRegisterPromptButton.setLayoutData((Object)gd);
        this.autoRegisterPromptButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent se) {
                if (BMMainConfigPage.this.autoRegisterPromptButton.getSelection()) {
                    try {
                        Connection con = BMMainConfigPage.this.wizard.getConnection();
                        if (con == null) {
                            DialogUtil.showErrorMessageBox("\u4e0d\u80fd\u8fde\u63a5\u5230\u6570\u636e\u5e93\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e!");
                            BMMainConfigPage.this.autoRegisterPromptButton.setSelection(false);
                        }
                    }
                    catch (ApplicationException e) {
                        DialogUtil.logErrorException("\u4e0d\u80fd\u8fde\u63a5\u5230\u6570\u636e\u5e93\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e!", e);
                        BMMainConfigPage.this.autoRegisterPromptButton.setSelection(false);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.initPageValues();
        this.checkPageValues();
        this.setControl((Control)container);
    }

    public Button getAutoRegisterPromptButton() {
        return this.autoRegisterPromptButton;
    }

    public void initPageValues() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toString());
            }
        }
    }

    public void checkPageValues() {
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        if (this.getContainerName().length() == 0) {
            this.updatePageStatus(LocaleMessage.getString("file.container.must.be.specified"));
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updatePageStatus(LocaleMessage.getString("file.container.must.exist"));
            return;
        }
        if (!container.isAccessible()) {
            this.updatePageStatus(LocaleMessage.getString("project.must.be.writable"));
            return;
        }
        this.updatePageStatus(null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }
}

