/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.builder.processor;

import aurora.ide.builder.AuroraBuilder;
import aurora.ide.builder.BuildContext;
import aurora.ide.builder.BuildMessages;
import aurora.ide.builder.CompositeMapInfo;
import aurora.ide.builder.SxsdUtil;
import aurora.ide.builder.processor.AbstractProcessor;
import aurora.ide.builder.processor.LocalFieldCollector;
import aurora.ide.preferencepages.BuildLevelPage;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import uncertain.composite.CompositeMap;
import uncertain.schema.Attribute;

public class LocalFieldProcessor
extends AbstractProcessor {
    private int level;
    private Set<Object[]> fieldTask = new HashSet<Object[]>();

    public void processComplete(IFile file, CompositeMap map1, IDocument doc) {
        if (this.level == 0) {
            return;
        }
        Set<String> fieldSet = new LocalFieldCollector(file).collect();
        if (fieldSet.size() == 0) {
            return;
        }
        for (Object[] objs : this.fieldTask) {
            String name = (String)objs[0];
            String value = (String)objs[1];
            if (fieldSet.contains(value.toLowerCase())) continue;
            CompositeMap map = (CompositeMap)objs[2];
            CompositeMapInfo info = new CompositeMapInfo(map, doc);
            IRegion region = info.getAttrValueRegion2(name);
            int line = info.getLineOfRegion(region);
            String msg = String.format(BuildMessages.get("build.localfield.undefined"), name, value);
            AuroraBuilder.addMarker(file, msg, line + 1, region, this.level, "aurora.ide.undefinedLocalField");
        }
    }

    public void processMap(BuildContext bc) {
        String ext = "_" + bc.file.getFileExtension().toUpperCase();
        this.level = BuildLevelPage.getBuildLevel("aurora.ide.undefinedLocalField" + ext);
        if (this.level == 0) {
            return;
        }
        this.processAttribute(bc);
    }

    public void visitAttribute(Attribute a, BuildContext bc) {
        if (SxsdUtil.isLocalFieldReference(a.getAttributeType())) {
            String name = a.getName();
            String value = bc.map.getString((Object)name);
            if (LocalFieldCollector.localFieldDefine.contains(bc.map.getName()) && name.equalsIgnoreCase("name")) {
                return;
            }
            this.fieldTask.add(new Object[]{name, value, bc.map});
        }
    }
}

