/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.builder.processor;

import aurora.ide.builder.AuroraBuilder;
import aurora.ide.builder.BuildContext;
import aurora.ide.builder.BuildMessages;
import aurora.ide.builder.CompositeMapInfo;
import aurora.ide.builder.SxsdUtil;
import aurora.ide.builder.processor.AbstractProcessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import uncertain.composite.CompositeMap;
import uncertain.schema.Attribute;
import uncertain.schema.Element;

public class SxsdProcessor
extends AbstractProcessor {
    private void checkTag(BuildContext bc) {
        if (BuildContext.LEVEL_UNDEFINED_TAG == 0) {
            return;
        }
        List<Element> childs = SxsdUtil.getAvailableChildElements(bc.map);
        List childMap = bc.map.getChildsNotNull();
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(20);
        block0: for (CompositeMap m : childMap) {
            String uri;
            Element elem = SxsdUtil.getMapElement(m);
            if (elem != null && SxsdUtil.isExtOfAnyElement(elem) || (uri = m.getNamespaceURI()) == null || !uri.startsWith("http:")) continue;
            String mapName = m.getName();
            Integer c = (Integer)countMap.get(mapName);
            if (c == null) {
                c = 0;
            }
            countMap.put(mapName, c + 1);
            boolean reachMax = false;
            int mc = 0;
            int i = 0;
            while (i < childs.size()) {
                Element e = childs.get(i);
                if (mapName.equalsIgnoreCase(e.getQName().getLocalName())) {
                    String maxOccurs = e.getMaxOccurs();
                    if (maxOccurs == null || (mc = Integer.parseInt(maxOccurs)) >= (Integer)countMap.get(mapName)) continue block0;
                    reachMax = true;
                    break;
                }
                ++i;
            }
            CompositeMapInfo info = new CompositeMapInfo(m, bc.doc);
            IRegion region = info.getMapNameRegion();
            int line = info.getLineOfRegion(region);
            String msg = null;
            msg = reachMax ? String.format(BuildMessages.get("build.reachmax"), mapName, mc) : String.format(BuildMessages.get("build.shouldnotbehere"), mapName, bc.map.getName());
            AuroraBuilder.addMarker(bc.file, msg, line + 1, region, BuildContext.LEVEL_UNDEFINED_TAG, "aurora.ide.undefinedTag");
        }
    }

    public void processMap(BuildContext bc) {
        String uri = bc.map.getNamespaceURI();
        if (uri == null || !uri.startsWith("http:")) {
            return;
        }
        this.checkTag(bc);
        if (SxsdUtil.getMapElement(bc.map) == null) {
            return;
        }
        if (BuildContext.LEVEL_UNDEFINED_ATTRIBUTE == 0) {
            return;
        }
        if (bc.map.getName().equals("record") && bc.map.getParent().getName().equals("datas")) {
            return;
        }
        HashSet<String> nameSet = new HashSet<String>();
        if (bc.list == null) {
            AuroraBuilder.addMarker(bc.file, bc.nullListMsg, bc.info.getStartLine() + 1, 2, "aurora.ide.fatalError");
            return;
        }
        for (Attribute a : bc.list) {
            nameSet.add(a.getName().toLowerCase());
        }
        for (Map.Entry entry : bc.map.entrySet()) {
            String k = (String)entry.getKey();
            if (nameSet.contains(k.toLowerCase())) continue;
            IRegion region = bc.info.getAttrNameRegion(k);
            int line = bc.info.getLineOfRegion(region);
            String msg = String.format(BuildMessages.get("build.attribute.undefined"), k, bc.map.getName());
            IMarker marker = AuroraBuilder.addMarker(bc.file, msg, line + 1, region, BuildContext.LEVEL_UNDEFINED_ATTRIBUTE, "aurora.ide.undefinedAttribute");
            if (marker == null) continue;
            try {
                marker.setAttribute("ATTRIBUTE_NAME", (Object)k);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void processComplete(IFile file, CompositeMap map, IDocument doc) {
    }
}

