/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.celleditor;

import java.util.HashMap;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;

public class AuroraCellEditor {
    private static AuroraCellEditor auroraCellEditor;
    private HashMap dataType2EditorName = new HashMap();
    private final String defaultEditor = "textField";
    public static final String aurorUri = "http://www.aurora-framework.org/application";

    private AuroraCellEditor() {
        this.dataType2EditorName.put("DATE", "datePicker");
        this.dataType2EditorName.put("boolean", "checkBox");
        this.dataType2EditorName.put("BIGINT", "numberField");
        this.dataType2EditorName.put("options", "comboBox");
        this.dataType2EditorName.put("lovService", "lov");
    }

    public static synchronized AuroraCellEditor getInstance() {
        if (auroraCellEditor == null) {
            auroraCellEditor = new AuroraCellEditor();
        }
        return auroraCellEditor;
    }

    public String getEditorName(String dataType) {
        Object typeObject = this.dataType2EditorName.get(dataType);
        String editorName = null;
        editorName = typeObject != null ? (String)typeObject : "textField";
        return editorName;
    }

    public void addEditorName(String dataType, String editorName) {
        this.dataType2EditorName.put(dataType, editorName);
    }

    public QualifiedName getEdiotrQN(String dataType) {
        return new QualifiedName(aurorUri, this.getEditorName(dataType));
    }

    public QualifiedName getEditorQN(CompositeMap record) {
        return this.getEdiotrQN(this.getDatabaseType(record));
    }

    public String getEditorName(CompositeMap record) {
        return this.getEditorName(this.getDatabaseType(record));
    }

    public String getDatabaseType(CompositeMap record) {
        if (record == null) {
            return null;
        }
        String databaseType = record.getString((Object)"databaseType");
        if (databaseType != null) {
            return databaseType;
        }
        String options = record.getString((Object)"options");
        if (options != null) {
            return "options";
        }
        String lovService = record.getString((Object)"lovService");
        if (lovService != null) {
            return "lovService";
        }
        return null;
    }
}

