/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.celleditor;

import aurora.ide.celleditor.CellInfo;
import aurora.ide.celleditor.ICellEditor;
import aurora.ide.helpers.LocaleMessage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class BoolCellEditor
extends CheckboxCellEditor
implements ICellEditor {
    private Button button;
    private boolean hasSelection = false;
    protected CellInfo cellProperties;

    public BoolCellEditor(CellInfo cellProperties) {
        this.cellProperties = cellProperties;
    }

    protected Control createControl(Composite parent) {
        if (this.isTableItemEditor()) {
            NewButton content = new NewButton(parent, 0);
            content.setLayout((Layout)new FillLayout());
            this.button = new Button((Composite)content, 32);
            this.button.setBackground(parent.getBackground());
            content.setBackground(parent.getBackground());
            return content;
        }
        return super.createControl(parent);
    }

    public boolean validValue(String value) {
        boolean validValue = true;
        String errorMessage = "";
        if (this.cellProperties.isRequired() && value == null) {
            validValue = false;
            errorMessage = "<" + this.cellProperties.getColumnName() + ">" + LocaleMessage.getString("field") + LocaleMessage.getString("is.required");
        }
        if (value != null && !value.equals("true") && !value.equals("false")) {
            validValue = false;
            errorMessage = "<" + this.cellProperties.getColumnName() + ">" + LocaleMessage.getString("field") + LocaleMessage.getString("value.must.be.true.or.false");
        }
        if (!validValue) {
            this.setErrorMessage(errorMessage);
            if (this.getCellControl() != null) {
                this.getCellControl().setFocus();
            }
            return false;
        }
        return true;
    }

    public Control getCellControl() {
        return super.getControl();
    }

    public String getSelection() {
        if (this.button != null) {
            if (!this.hasSelection) {
                return null;
            }
            if (this.button.getSelection()) {
                return "true";
            }
            return "false";
        }
        if (super.getValue() == null) {
            return null;
        }
        return super.getValue().toString();
    }

    public Object valueToShow(String value) {
        Boolean showValue = null;
        showValue = "true".equals(value) ? new Boolean(true) : new Boolean(false);
        return showValue;
    }

    public void SetSelection(String dataValue) {
        if (dataValue == null) {
            dataValue = "false";
        }
        Boolean showValue = (Boolean)this.valueToShow(dataValue);
        if (this.button != null) {
            this.hasSelection = true;
            this.button.setSelection(showValue.booleanValue());
        } else {
            super.setValue((Object)showValue);
        }
    }

    public Control createCellControl(Composite parent) {
        return super.getControl();
    }

    public void dispose() {
        super.dispose();
    }

    public void init() {
        Table parent = this.cellProperties.getTable();
        this.createCellEditor((Composite)parent);
        Color bg = Display.getDefault().getSystemColor(7);
        if (this.cellProperties.isRequired() && this.getCellControl() != null) {
            this.getCellControl().setBackground(bg);
        }
        if (this.isTableItemEditor()) {
            this.SetSelection(this.cellProperties.getRecord().getString((Object)this.cellProperties.getColumnName()));
            this.addCellListener();
        }
    }

    private void addCellListener() {
        this.button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!BoolCellEditor.this.hasSelection) {
                    BoolCellEditor.this.hasSelection = true;
                }
                String dataValue = BoolCellEditor.this.getSelection();
                BoolCellEditor.this.cellProperties.getRecord().put((Object)BoolCellEditor.this.cellProperties.getColumnName(), (Object)dataValue);
                BoolCellEditor.this.cellProperties.getTableViewer().refresh(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    public void createCellEditor(Composite parent) {
        super.create(parent);
    }

    public CellEditor getCellEditor() {
        return this;
    }

    private boolean isTableItemEditor() {
        return this.cellProperties.getTableItem() != null;
    }

    class NewButton
    extends Composite {
        public NewButton(Composite parent, int style) {
            super(parent, 0);
        }

        public String toString() {
            return "ok" + BoolCellEditor.this.button.toString();
        }
    }
}

