/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.celleditor;

import aurora.ide.celleditor.BoolCellEditor;
import aurora.ide.celleditor.CellInfo;
import aurora.ide.celleditor.ComboxCellEditor;
import aurora.ide.celleditor.ICellEditor;
import aurora.ide.celleditor.NumberTextCellEditor;
import aurora.ide.celleditor.StringTextCellEditor;
import aurora.ide.editor.core.ITableViewer;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.LoadSchemaManager;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.helpers.SystemException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.swt.widgets.TableItem;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;
import uncertain.schema.Attribute;
import uncertain.schema.Editor;
import uncertain.schema.Enumeration;
import uncertain.schema.IType;
import uncertain.schema.Restriction;
import uncertain.schema.SimpleType;

public class CellEditorFactory {
    private static CellEditorFactory editorFactory;
    public static final QualifiedName boolean_qn;
    public static final QualifiedName string_qn;
    public static final QualifiedName int_qn;
    public static final QualifiedName integer_qn;
    public static final QualifiedName long_qn;
    public static final QualifiedName float_qn;
    public static final QualifiedName double_qn;
    public static final String required = "required";
    public static final QualifiedName localFieldReference;
    public static final QualifiedName foreignFieldReference;
    public static final QualifiedName modelReference;

    static {
        boolean_qn = new QualifiedName("http://www.uncertain-framework.org/schema/simple-schema", "boolean");
        string_qn = new QualifiedName("http://www.uncertain-framework.org/schema/simple-schema", "string");
        int_qn = new QualifiedName("http://www.uncertain-framework.org/schema/simple-schema", "int");
        integer_qn = new QualifiedName("http://www.uncertain-framework.org/schema/simple-schema", "integer");
        long_qn = new QualifiedName("http://www.uncertain-framework.org/schema/simple-schema", "long");
        float_qn = new QualifiedName("http://www.uncertain-framework.org/schema/simple-schema", "float");
        double_qn = new QualifiedName("http://www.uncertain-framework.org/schema/simple-schema", "double");
        localFieldReference = new QualifiedName("http://www.aurora-framework.org/schema/bm", "LocalFieldReference");
        foreignFieldReference = new QualifiedName("http://www.aurora-framework.org/schema/bm", "ForeignFieldReference");
        modelReference = new QualifiedName("http://www.aurora-framework.org/schema/bm", "ModelReference");
    }

    private CellEditorFactory() {
    }

    public static CellEditorFactory getInstance() {
        if (editorFactory == null) {
            editorFactory = new CellEditorFactory();
        }
        return editorFactory;
    }

    public ICellEditor createCellEditor(ITableViewer viewer, Attribute attribute) throws ApplicationException {
        return this.createCellEditor(viewer, attribute, null, null);
    }

    public ICellEditor createCellEditor(ITableViewer viewer, Attribute attribute, CompositeMap record, TableItem tableItem) throws ApplicationException {
        ICellEditor cellEditor = null;
        if (attribute == null) {
            return cellEditor;
        }
        CellInfo cellProperties = this.createCellProperties(viewer, attribute, record, tableItem);
        cellEditor = this.createDefinedEditor(attribute, cellProperties);
        if (cellEditor == null) {
            cellEditor = this.createDefaultEditor(attribute, cellProperties);
        }
        if (cellEditor != null) {
            cellEditor.init();
        }
        return cellEditor;
    }

    private CellInfo createCellProperties(ITableViewer viewer, Attribute attribute, CompositeMap record, TableItem tableItem) {
        return new CellInfo(viewer, attribute, record, tableItem);
    }

    private ICellEditor createDefaultEditor(Attribute attribute, CellInfo cellProperties) {
        Enumeration[] emus;
        SimpleType simpleType;
        Restriction rest;
        ICellEditor cellEditor = null;
        QualifiedName typeQname = attribute.getTypeQName();
        IType attributeType = LoadSchemaManager.getSchemaManager().getType(typeQname);
        if (attributeType != null && attributeType instanceof SimpleType && (rest = (simpleType = (SimpleType)attributeType).getRestriction()) != null && (emus = rest.getEnumerations()) != null) {
            cellEditor = new ComboxCellEditor(cellProperties);
            return cellEditor;
        }
        if (typeQname == null) {
            if (required.equals(attribute.getUse())) {
                cellEditor = new StringTextCellEditor(cellProperties);
                return cellEditor;
            }
            return cellEditor;
        }
        if (typeQname.equals((Object)boolean_qn)) {
            cellEditor = new BoolCellEditor(cellProperties);
            return cellEditor;
        }
        if (typeQname.equals((Object)string_qn)) {
            cellEditor = new StringTextCellEditor(cellProperties);
            return cellEditor;
        }
        if (typeQname.equals((Object)int_qn) || typeQname.equals((Object)integer_qn) || typeQname.equals((Object)double_qn) || typeQname.equals((Object)long_qn) || typeQname.equals((Object)float_qn) || typeQname.equals((Object)double_qn)) {
            cellEditor = new NumberTextCellEditor(cellProperties);
            return cellEditor;
        }
        return cellEditor;
    }

    private ICellEditor createDefinedEditor(Attribute attribute, CellInfo cellProperties) throws ApplicationException {
        Class<?> cls;
        QualifiedName typeQname = attribute.getTypeQName();
        if (typeQname == null) {
            return null;
        }
        IType type = LoadSchemaManager.getSchemaManager().getType(typeQname);
        if (type == null || !(type instanceof SimpleType)) {
            return null;
        }
        SimpleType simpleType = (SimpleType)type;
        QualifiedName editorQName = simpleType.getEditorQName();
        Editor ed = LoadSchemaManager.getSchemaManager().getEditor(editorQName);
        if (ed == null) {
            return null;
        }
        String cls_name = ed.getInstanceClass();
        try {
            cls = Class.forName(cls_name);
        }
        catch (ClassNotFoundException e) {
            throw new ApplicationException(String.valueOf(LocaleMessage.getString("editor.class")) + cls_name + LocaleMessage.getString("not.valid"), e);
        }
        Constructor<?> constructor = null;
        try {
            Class[] constructorClasses = new Class[]{CellInfo.class};
            constructor = cls.getConstructor(constructorClasses);
            Object[] constructorObjects = new Object[]{cellProperties};
            Object editor = constructor.newInstance(constructorObjects);
            ICellEditor cellEditor = (ICellEditor)editor;
            return cellEditor;
        }
        catch (SecurityException e) {
            throw new SystemException(e);
        }
        catch (NoSuchMethodException e) {
            throw new SystemException(e);
        }
        catch (IllegalArgumentException e) {
            throw new SystemException(e);
        }
        catch (InstantiationException e) {
            throw new SystemException(e);
        }
        catch (IllegalAccessException e) {
            throw new SystemException(e);
        }
        catch (InvocationTargetException e) {
            throw new SystemException(e);
        }
    }
}

