/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.celleditor;

import aurora.ide.editor.core.ITableViewer;
import aurora.ide.helpers.LoadSchemaManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;
import uncertain.schema.Attribute;
import uncertain.schema.Enumeration;
import uncertain.schema.IType;
import uncertain.schema.Restriction;
import uncertain.schema.SimpleType;

public class CellInfo {
    protected String[] items;
    protected ITableViewer tableViewer;
    protected boolean required;
    protected String columnName;
    protected CompositeMap record;
    protected TableItem tableItem;
    protected QualifiedName typeQname;

    public QualifiedName getTypeQname() {
        return this.typeQname;
    }

    public void setTypeQname(QualifiedName typeQname) {
        this.typeQname = typeQname;
    }

    public CellInfo(ITableViewer tableViewer, Attribute attribute) {
        this.tableViewer = tableViewer;
        this.parseAttribute(attribute);
    }

    public CellInfo(ITableViewer tableViewer, Attribute attribute, CompositeMap record, TableItem tableItem) {
        this(tableViewer, attribute);
        this.record = record;
        this.tableItem = tableItem;
    }

    public CellInfo(ITableViewer tableViewer, String columnName, boolean required) {
        this.tableViewer = tableViewer;
        this.columnName = columnName;
        this.required = required;
    }

    public CellInfo(ITableViewer tableViewer, String columnName, boolean required, CompositeMap record, TableItem tableItem) {
        this(tableViewer, columnName, required);
        this.record = record;
        this.tableItem = tableItem;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String[] getItems() {
        return this.items;
    }

    public CompositeMap getRecord() {
        return this.record;
    }

    public TableItem getTableItem() {
        return this.tableItem;
    }

    public ITableViewer getTableViewer() {
        return this.tableViewer;
    }

    public Table getTable() {
        return this.tableViewer.getViewer().getTable();
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setItems(String[] items) {
        this.items = items;
    }

    public void setRecord(CompositeMap record) {
        this.record = record;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setTableItem(TableItem tableItem) {
        this.tableItem = tableItem;
    }

    public void setTableViewer(ITableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    private void iniItems(Attribute attribute) {
        block6: {
            Enumeration[] emus;
            QualifiedName typeQname = attribute.getTypeQName();
            if (typeQname == null) {
                return;
            }
            IType type = LoadSchemaManager.getSchemaManager().getType(typeQname);
            if (type == null || !(type instanceof SimpleType)) {
                return;
            }
            SimpleType simpleType = (SimpleType)type;
            Restriction rest = simpleType.getRestriction();
            if (rest == null || (emus = rest.getEnumerations()) == null) break block6;
            if (this.required) {
                this.items = new String[emus.length];
                int i = 0;
                while (i < emus.length) {
                    this.items[i] = emus[i].getValue();
                    ++i;
                }
            } else {
                this.items = new String[emus.length + 1];
                this.items[0] = "";
                int i = 0;
                while (i < emus.length) {
                    this.items[i + 1] = emus[i].getValue();
                    ++i;
                }
            }
        }
    }

    private void parseAttribute(Attribute attribute) {
        Assert.isNotNull((Object)attribute, (String)"Attribute can not be null");
        this.columnName = attribute.getLocalName();
        if ("required".equals(attribute.getUse())) {
            this.required = true;
        }
        this.typeQname = attribute.getTypeQName();
        this.iniItems(attribute);
    }
}

