/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.celleditor;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.bm.editor.GridDialog;
import aurora.ide.celleditor.CellInfo;
import aurora.ide.celleditor.StringTextCellEditor;
import aurora.ide.editor.widgets.GridViewer;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraResourceUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.helpers.ProjectUtil;
import java.io.IOException;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;

public class ForeignFieldReferenceCellEditor
extends StringTextCellEditor {
    public ForeignFieldReferenceCellEditor(CellInfo cellProperties) {
        super(cellProperties);
    }

    protected void addCellListener() {
        this.getCellControl().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                try {
                    ForeignFieldReferenceCellEditor.this.fireEvent();
                }
                catch (Exception e1) {
                    DialogUtil.showExceptionMessageBox(e1);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.getCellControl().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (ForeignFieldReferenceCellEditor.this.isTableItemEditor()) {
                    ForeignFieldReferenceCellEditor.this.rebuildCellEditor(ForeignFieldReferenceCellEditor.this.cellProperties.getTableItem());
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
    }

    private void fireEvent() throws ApplicationException {
        CompositeMap root;
        CompositeMap parent = this.cellProperties.getRecord().getParent();
        String fileName = parent.getString((Object)"refModel");
        if (fileName == null) {
            throw new ApplicationException(String.valueOf(LocaleMessage.getString("its.parent's")) + "'refModel'" + LocaleMessage.getString("attribute.value.is.null"));
        }
        CompositeLoader loader = AuroraResourceUtil.getCompsiteLoader();
        String path = String.valueOf(fileName.replace('.', '/')) + '.' + "bm";
        String fullPath = String.valueOf(ProjectUtil.getBMHomeLocalPath(ProjectUtil.getIProjectFromSelection())) + "/" + path;
        try {
            root = loader.loadByFullFilePath(fullPath);
        }
        catch (IOException e) {
            throw new ApplicationException("\u6587\u4ef6\u8def\u5f84\uff1a" + fullPath + "\u4e0d\u6b63\u786e", e);
        }
        catch (SAXException e) {
            throw new ApplicationException("\u6587\u4ef6\u89e3\u6790\u4e0d\u6b63\u786e", e);
        }
        CompositeMap fields = root.getChild("fields");
        CommentCompositeMap filedNames = new CommentCompositeMap();
        for (CompositeMap child : fields.getChildsNotNull()) {
            String targetNode = child.getString((Object)"name");
            if (targetNode == null) continue;
            CommentCompositeMap newChild = new CommentCompositeMap();
            newChild.put("name", targetNode);
            filedNames.addChild(newChild);
        }
        String[] columnProperties = new String[]{"name"};
        GridViewer grid = new GridViewer(48);
        grid.setData(filedNames);
        grid.setFilterColumn("name");
        grid.setColumnNames(columnProperties);
        GridDialog dialog = new GridDialog(new Shell(), grid);
        if (dialog.open() == 0 && dialog.getSelected() != null) {
            String value = dialog.getSelected().getString((Object)"name");
            this.setValue(value);
            this.cellProperties.getRecord().put((Object)this.cellProperties.getColumnName(), (Object)value);
            this.cellProperties.getTableViewer().refresh(true);
        }
    }

    private boolean isTableItemEditor() {
        return this.cellProperties.getTableItem() != null;
    }
}

