/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.celleditor;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.bm.editor.GridDialog;
import aurora.ide.celleditor.CellInfo;
import aurora.ide.celleditor.StringTextCellEditor;
import aurora.ide.editor.widgets.GridViewer;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.DialogUtil;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import uncertain.composite.CompositeMap;

public class LocalFieldReferenceCellEditor
extends StringTextCellEditor {
    public LocalFieldReferenceCellEditor(CellInfo cellProperties) {
        super(cellProperties);
    }

    protected void addCellListener() {
        this.getCellControl().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                try {
                    LocalFieldReferenceCellEditor.this.fireEvent();
                }
                catch (ApplicationException ex) {
                    DialogUtil.showExceptionMessageBox(ex);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.getCellControl().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (LocalFieldReferenceCellEditor.this.isTableItemEditor()) {
                    LocalFieldReferenceCellEditor.this.rebuildCellEditor(LocalFieldReferenceCellEditor.this.cellProperties.getTableItem());
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
    }

    private void fireEvent() throws ApplicationException {
        CompositeMap root = this.getData();
        if (root == null) {
            return;
        }
        CompositeMap fields = this.isTableItemEditor() ? root.getChild("fields") : root.getParent().getChild("fields");
        CommentCompositeMap filedNames = new CommentCompositeMap();
        if (fields != null) {
            for (CompositeMap child : fields.getChildsNotNull()) {
                String targetNode = child.getString((Object)"name");
                if (targetNode == null) continue;
                CommentCompositeMap newChild = new CommentCompositeMap();
                newChild.put("name", targetNode);
                filedNames.addChild(newChild);
            }
        }
        String[] columnProperties = new String[]{"name"};
        GridViewer grid = new GridViewer(48);
        grid.setData(filedNames);
        grid.setFilterColumn("name");
        grid.setColumnNames(columnProperties);
        GridDialog dialog = new GridDialog(new Shell(), grid);
        if (dialog.open() == 0 && dialog.getSelected() != null) {
            String value = dialog.getSelected().getString((Object)"name");
            this.setValue(value);
            if (this.isTableItemEditor()) {
                this.cellProperties.getRecord().put((Object)this.cellProperties.getColumnName(), (Object)value);
            } else {
                TableItem item = this.cellProperties.getTableViewer().getViewer().getTable().getSelection()[0];
                CompositeMap data = (CompositeMap)item.getData();
                data.put((Object)this.cellProperties.getColumnName(), (Object)value);
            }
            this.cellProperties.getTableViewer().refresh(true);
        }
    }

    private CompositeMap getData() {
        if (this.cellProperties.getTableItem() != null) {
            return this.cellProperties.getRecord().getRoot();
        }
        TableViewer tableViewer = this.cellProperties.getTableViewer().getViewer();
        if (tableViewer == null) {
            return null;
        }
        Object dataObject = tableViewer.getInput();
        if (dataObject == null) {
            return null;
        }
        return (CompositeMap)dataObject;
    }

    private boolean isTableItemEditor() {
        return this.cellProperties.getTableItem() != null;
    }
}

