/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.component.wizard;

import aurora.ide.AuroraPlugin;
import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.bm.BMUtil;
import aurora.ide.bm.editor.GridDialog;
import aurora.ide.celleditor.CellInfo;
import aurora.ide.celleditor.ComboxCellEditor;
import aurora.ide.editor.core.IViewer;
import aurora.ide.editor.widgets.GridViewer;
import aurora.ide.editor.widgets.core.ICellModifierListener;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraConstant;
import aurora.ide.helpers.AuroraResourceUtil;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LoadSchemaManager;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.node.action.AddElementAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;
import uncertain.schema.ComplexType;
import uncertain.schema.Element;
import uncertain.schema.IType;

public class CreateGridFromDataSetAction
extends AddElementAction {
    private static final String idColumn = "id";
    private static final String modelColumn = "model";
    private static final String screenBodyColumn = "screenBody";
    static final String title = LocaleMessage.getString("create.grid.from.dataset");

    public CreateGridFromDataSetAction(IViewer viewer, CompositeMap dataSet, QualifiedName qName, int actionStyle) {
        super(viewer, dataSet, qName, actionStyle);
    }

    public ImageDescriptor getDefaultImageDescriptor() {
        return AuroraPlugin.getImageDescriptor(LocaleMessage.getString("wizard.icon"));
    }

    public void run() {
        if (this.currentNode == null || !AuroraConstant.DataSetQN.equals((Object)this.currentNode.getQName())) {
            DialogUtil.showErrorMessageBox("It is not a dataSet element!");
            return;
        }
        if (this.currentNode.getString((Object)idColumn) == null) {
            DialogUtil.showErrorMessageBox("\u8bf7\u5148\u8bbe\u7f6eID\u5c5e\u6027.");
            return;
        }
        try {
            if (this.getFieldsFromDS(this.currentNode) == null) {
                DialogUtil.showErrorMessageBox("\u6b64dataSet\u6ca1\u6709\u53ef\u7528\u5b57\u6bb5.");
                return;
            }
        }
        catch (ApplicationException e) {
            DialogUtil.showExceptionMessageBox(e);
            return;
        }
        CompositeMap view = this.currentNode.getParent().getParent();
        if (view == null || !AuroraConstant.ViewQN.equals((Object)view.getQName())) {
            DialogUtil.showErrorMessageBox("Its parent's parent is not a view element!");
            return;
        }
        boolean successful = this.createGrid(this.currentNode);
        if (this.viewer != null && successful) {
            this.viewer.refresh(true);
        }
    }

    private boolean createGrid(CompositeMap dataSet) {
        GridWizard wizard = new GridWizard(dataSet);
        WizardDialog dialog = new WizardDialog(new Shell(), (IWizard)wizard);
        dialog.open();
        return wizard.isSuccessful();
    }

    public CompositeMap getFieldsFromDS(CompositeMap dataSet) throws ApplicationException {
        if (dataSet == null) {
            return null;
        }
        CompositeMap fields = dataSet.getChild("fields");
        if (fields != null && fields.getChilds() != null && fields.getChilds().size() > 0) {
            return fields;
        }
        String classPath = dataSet.getString((Object)modelColumn);
        CompositeMap model = AuroraResourceUtil.loadFromResource(BMUtil.getBMResourceFromClassPath(classPath));
        if (model == null) {
            return null;
        }
        fields = model.getChild("fields");
        if (fields != null && fields.getChilds() != null && fields.getChilds().size() > 0) {
            return fields;
        }
        return null;
    }

    class FieldPage
    extends WizardPage
    implements IViewer {
        public static final String PAGE_NAME = "FiledPage";
        public static final String uri = "http://www.aurora-framework.org/application";
        private GridWizard wizard;
        private GridViewer grid;
        ModifyCompositeMapListener newCompositeMap;

        protected FieldPage(GridWizard wizard) {
            super(PAGE_NAME);
            this.setTitle(String.valueOf(title) + "--" + LocaleMessage.getString("filed.page"));
            this.wizard = wizard;
        }

        public void createControl(Composite parent) {
            Composite content = new Composite(parent, 0);
            content.setLayout((Layout)new GridLayout());
            CompositeMap fields = this.wizard.getFields();
            CommentCompositeMap filedNames = new CommentCompositeMap();
            for (CompositeMap child : fields.getChildsNotNull()) {
                String targetNode = child.getString((Object)"name");
                if (targetNode == null) continue;
                CommentCompositeMap newChild = new CommentCompositeMap();
                newChild.put("name", targetNode);
                newChild.put("prompt", child.getString((Object)"prompt"));
                filedNames.addChild(newChild);
            }
            String[] columnProperties = new String[]{"name", "prompt", "editor"};
            this.grid = new GridViewer(columnProperties, 74);
            this.grid.setParent(this);
            try {
                this.grid.createViewer(content);
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
            }
            TableViewer tableView = this.grid.getViewer();
            CellEditor[] celleditors = new CellEditor[columnProperties.length];
            int i = 0;
            while (i < columnProperties.length - 1) {
                celleditors[i] = new TextCellEditor((Composite)tableView.getTable());
                ++i;
            }
            QualifiedName qn = new QualifiedName(uri, "Field");
            ComplexType type = LoadSchemaManager.getSchemaManager().getComplexType(qn);
            List editors = LoadSchemaManager.getSchemaManager().getElementsOfType((IType)type);
            Iterator editorIt = editors.iterator();
            String[] items = new String[editors.size()];
            int i2 = 0;
            while (editorIt.hasNext()) {
                Element editor = (Element)editorIt.next();
                items[i2] = editor.getLocalName();
                ++i2;
            }
            CellInfo cellProperties = new CellInfo(this.grid, "editor", false);
            cellProperties.setItems(items);
            ComboxCellEditor cellEditor = new ComboxCellEditor(cellProperties);
            cellEditor.init();
            celleditors[columnProperties.length - 1] = cellEditor.getCellEditor();
            this.grid.addEditor("editor", cellEditor);
            this.grid.setCellEditors(celleditors);
            try {
                this.grid.setData(filedNames);
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
            }
            this.newCompositeMap = new ModifyCompositeMapListener();
            this.grid.addCellModifierListener(this.newCompositeMap);
            this.setControl((Control)content);
            this.setPageComplete(true);
        }

        public CompositeMap getSelection() {
            return this.grid.getSelection();
        }

        public HashMap getMap() {
            return this.newCompositeMap.getSelection();
        }

        public void refresh(boolean isDirty) {
            this.grid.refresh(false);
        }

        public void repaint() throws ApplicationException {
            if (this.newCompositeMap == null) {
                return;
            }
            CompositeMap fields = this.wizard.getFields();
            CommentCompositeMap filedNames = new CommentCompositeMap();
            for (CompositeMap child : fields.getChildsNotNull()) {
                String targetNode = child.getString((Object)"name");
                if (targetNode == null) continue;
                CommentCompositeMap newChild = new CommentCompositeMap();
                newChild.put("name", targetNode);
                newChild.put("prompt", child.getString((Object)"prompt"));
                filedNames.addChild(newChild);
            }
            this.grid.setData(filedNames);
            this.newCompositeMap.clear();
        }

        class ModifyCompositeMapListener
        implements ICellModifierListener {
            HashMap records = new HashMap();

            ModifyCompositeMapListener() {
            }

            public void modify(CompositeMap record, String property, String value) {
                String name = record.getString((Object)"name");
                CompositeMap newRecord = null;
                if (this.records.get(name) == null) {
                    newRecord = new CommentCompositeMap(record.getPrefix(), record.getNamespaceURI(), "column");
                    newRecord.put((Object)"name", (Object)name);
                    this.records.put(name, newRecord);
                } else {
                    newRecord = (CompositeMap)this.records.get(name);
                }
                newRecord.put((Object)property, (Object)value);
            }

            public HashMap getSelection() {
                return this.records;
            }

            public void clear() {
                this.records.clear();
            }
        }
    }

    class GridWizard
    extends Wizard
    implements IViewer {
        private boolean successful;
        private MainConfigPage mainConfigPage;
        private FieldPage fieldPage;
        private CompositeMap dataSet;

        public GridWizard(CompositeMap dataSet) {
            this.dataSet = dataSet;
        }

        public void addPages() {
            this.mainConfigPage = new MainConfigPage(this, this.dataSet);
            this.addPage((IWizardPage)this.mainConfigPage);
            this.fieldPage = new FieldPage(this);
            this.addPage((IWizardPage)this.fieldPage);
            this.fieldPage.setPageComplete(false);
        }

        public boolean performFinish() {
            String prefix = this.dataSet.getPrefix();
            String uri = this.dataSet.getNamespaceURI();
            CompositeMap grid = this.mainConfigPage.getGrid();
            CommentCompositeMap columns = new CommentCompositeMap(prefix, uri, "columns");
            CommentCompositeMap editors = new CommentCompositeMap(prefix, uri, "editors");
            grid.addChild((CompositeMap)columns);
            grid.addChild((CompositeMap)editors);
            Iterator selection = this.fieldPage.getSelection().getChildsNotNull().iterator();
            HashMap hash = this.fieldPage.getMap();
            HashMap useEditor = new HashMap();
            while (selection.hasNext()) {
                CompositeMap column = (CompositeMap)selection.next();
                String name = column.getString((Object)"name");
                CompositeMap record = null;
                if (hash.get(name) == null) {
                    record = new CommentCompositeMap(prefix, uri, "column");
                    record.put((Object)"name", (Object)name);
                } else {
                    record = (CompositeMap)hash.get(name);
                    record.setNameSpace(prefix, uri);
                    String editorType = record.getString((Object)"editor");
                    record.put((Object)"editor", (Object)this.getEditorId(useEditor, grid.getString((Object)CreateGridFromDataSetAction.idColumn), editorType));
                }
                columns.addChild(record);
            }
            Iterator it = useEditor.keySet().iterator();
            if (it != null) {
                while (it.hasNext()) {
                    String type = (String)it.next();
                    CommentCompositeMap newRecord = new CommentCompositeMap(prefix, uri, type);
                    newRecord.put(CreateGridFromDataSetAction.idColumn, useEditor.get(type));
                    editors.addChild(newRecord);
                }
            }
            this.addGrid(grid);
            this.successful = true;
            return true;
        }

        private void addGrid(CompositeMap grid) {
            CompositeMap view = CreateGridFromDataSetAction.this.currentNode.getParent().getParent();
            CompositeMap screenBody = view.getChild(CreateGridFromDataSetAction.screenBodyColumn);
            if (screenBody == null) {
                screenBody = new CommentCompositeMap(CreateGridFromDataSetAction.this.currentNode.getPrefix(), CreateGridFromDataSetAction.this.currentNode.getNamespaceURI(), CreateGridFromDataSetAction.screenBodyColumn);
                view.addChild(screenBody);
            }
            screenBody.addChild(grid);
        }

        public CompositeMap getFields() {
            return this.mainConfigPage.getFields();
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public void createPageControls(Composite pageContainer) {
        }

        private String getEditorId(HashMap editors, String gridId, String type) {
            String editorId = null;
            if (type != null && editors.get(type) == null) {
                editorId = String.valueOf(gridId) + "_" + type;
                editors.put(type, editorId);
            } else {
                editorId = (String)editors.get(type);
            }
            return editorId;
        }

        public void refresh(boolean isDirty) {
            try {
                this.fieldPage.repaint();
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
            }
        }
    }

    class MainConfigPage
    extends WizardPage {
        public static final String PAGE_NAME = "mainPage";
        private CompositeMap dataSets;
        private String bindTarget;
        private String id;
        private boolean navBar;
        private String width;
        private String height;
        private Set allIds;
        private boolean addButton;
        private boolean deleteButton;
        private boolean saveButton;
        IViewer parentViewer;
        private CompositeMap fields;
        private CompositeMap dataSet;

        protected MainConfigPage(IViewer parentView, CompositeMap dataSet) {
            super(PAGE_NAME);
            this.setTitle(String.valueOf(title) + "--" + LocaleMessage.getString("mainpage"));
            this.parentViewer = parentView;
            this.dataSet = dataSet;
        }

        public boolean canFlipToNextPage() {
            try {
                this.fields = CreateGridFromDataSetAction.this.getFieldsFromDS(this.dataSet);
                if (this.fields == null) {
                    DialogUtil.showErrorMessageBox("\u6b64dataSet\u6ca1\u6709\u53ef\u7528\u5b57\u6bb5.");
                    return false;
                }
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
                return false;
            }
            return super.canFlipToNextPage();
        }

        public void createControl(Composite parent) {
            Composite content = new Composite(parent, 0);
            content.setLayout((Layout)new GridLayout(4, false));
            GridData gridData = new GridData(768);
            Group dataSetGroup = new Group(content, 0);
            gridData.horizontalSpan = 4;
            dataSetGroup.setLayoutData((Object)gridData);
            dataSetGroup.setText(LocaleMessage.getString("bindtarget"));
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            dataSetGroup.setLayout((Layout)layout);
            final Text bindTargetText = new Text((Composite)dataSetGroup, 0);
            gridData = new GridData(768);
            bindTargetText.setLayoutData((Object)gridData);
            Button browseButton = new Button((Composite)dataSetGroup, 8);
            browseButton.setText(LocaleMessage.getString("openBrowse"));
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    try {
                        MainConfigPage.this.dataSet = MainConfigPage.this.selectDataSet();
                    }
                    catch (ApplicationException e) {
                        DialogUtil.showExceptionMessageBox(e);
                    }
                    if (MainConfigPage.this.dataSet != null) {
                        bindTargetText.setText(MainConfigPage.this.dataSet.getString((Object)CreateGridFromDataSetAction.idColumn));
                        MainConfigPage.this.parentViewer.refresh(true);
                    }
                }
            });
            Label label = new Label(content, 256);
            label.setText(LocaleMessage.getString("please.input.id"));
            final Text idText = new Text(content, 0);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            idText.setLayoutData((Object)gridData);
            bindTargetText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (bindTargetText.getText() != null && !bindTargetText.getText().equals("")) {
                        MainConfigPage.this.bindTarget = bindTargetText.getText();
                        if (idText.getText() == null || idText.getText().equals("")) {
                            idText.setText(String.valueOf(MainConfigPage.this.bindTarget) + "_grid");
                        }
                    }
                    MainConfigPage.this.checkDialog();
                }
            });
            idText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (idText.getText() != null && !idText.getText().equals("")) {
                        MainConfigPage.this.id = idText.getText();
                    }
                    MainConfigPage.this.checkDialog();
                }
            });
            Label widthLabel = new Label(content, 256);
            widthLabel.setText(LocaleMessage.getString("please.input.width"));
            final Text widthText = new Text(content, 0);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            gridData.grabExcessHorizontalSpace = true;
            widthText.setLayoutData((Object)gridData);
            widthText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (widthText.getText() != null && !widthText.getText().equals("")) {
                        MainConfigPage.this.width = widthText.getText();
                    }
                    MainConfigPage.this.checkDialog();
                }
            });
            Label heightLabel = new Label(content, 256);
            heightLabel.setText(LocaleMessage.getString("please.input.height"));
            final Text heightText = new Text(content, 0);
            heightText.setLayoutData((Object)gridData);
            heightText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (heightText.getText() != null && !heightText.getText().equals("")) {
                        MainConfigPage.this.height = heightText.getText();
                    }
                    MainConfigPage.this.checkDialog();
                }
            });
            final Button navBarButton = new Button(content, 32);
            navBarButton.setText(LocaleMessage.getString("enbaleNavBar"));
            gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            navBarButton.setLayoutData((Object)gridData);
            navBarButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (navBarButton.getSelection()) {
                        MainConfigPage.this.navBar = true;
                    } else {
                        MainConfigPage.this.navBar = false;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            Group buttonGroup = new Group(content, 0);
            gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            buttonGroup.setLayoutData((Object)gridData);
            buttonGroup.setText(LocaleMessage.getString("selectbuttons"));
            layout = new GridLayout();
            layout.numColumns = 3;
            buttonGroup.setLayout((Layout)layout);
            final Button add = new Button((Composite)buttonGroup, 32);
            add.setText(LocaleMessage.getString("addbutton"));
            add.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (add.getSelection()) {
                        MainConfigPage.this.addButton = true;
                    } else {
                        MainConfigPage.this.addButton = false;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            final Button delete = new Button((Composite)buttonGroup, 32);
            delete.setText(LocaleMessage.getString("deletebutton"));
            delete.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (delete.getSelection()) {
                        MainConfigPage.this.deleteButton = true;
                    } else {
                        MainConfigPage.this.deleteButton = false;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            final Button save = new Button((Composite)buttonGroup, 32);
            save.setText(LocaleMessage.getString("savebutton"));
            save.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (save.getSelection()) {
                        MainConfigPage.this.saveButton = true;
                    } else {
                        MainConfigPage.this.saveButton = false;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.setControl((Control)content);
            bindTargetText.setText(this.dataSet.getString((Object)CreateGridFromDataSetAction.idColumn));
        }

        public CompositeMap getFields() {
            return this.fields;
        }

        public CompositeMap getGrid() {
            String prefix = this.dataSet.getPrefix();
            String uri = this.dataSet.getNamespaceURI();
            CommentCompositeMap grid = new CommentCompositeMap(prefix, uri, "grid");
            grid.put(CreateGridFromDataSetAction.idColumn, this.id);
            grid.put("bindTarget", this.bindTarget);
            grid.put("width", this.width);
            grid.put("height", this.height);
            grid.put("navBar", String.valueOf(this.navBar));
            if (this.addButton || this.deleteButton || this.saveButton) {
                CommentCompositeMap toolBar = new CommentCompositeMap(prefix, uri, "toolBar");
                grid.addChild(toolBar);
                this.createButton(toolBar, this.addButton, "add");
                this.createButton(toolBar, this.deleteButton, "delete");
                this.createButton(toolBar, this.saveButton, "save");
            }
            return grid;
        }

        private void createButton(CompositeMap toobar, boolean create, String type) {
            if (create) {
                CommentCompositeMap button = new CommentCompositeMap(CreateGridFromDataSetAction.this.childQN.getPrefix(), CreateGridFromDataSetAction.this.childQN.getNameSpace(), "button");
                button.put("type", type);
                toobar.addChild((CompositeMap)button);
            }
        }

        private CompositeMap selectDataSet() throws ApplicationException {
            if (this.dataSets == null) {
                CompositeMap view = this.dataSet.getParent().getParent();
                this.dataSets = this.getAvailableDataSets(view);
                if (this.dataSets == null || this.dataSets.getChildsNotNull().size() == 0) {
                    DialogUtil.showErrorMessageBox("no.dataSet.available");
                    return null;
                }
            }
            String[] columnProperties = new String[]{CreateGridFromDataSetAction.idColumn, CreateGridFromDataSetAction.modelColumn};
            GridViewer grid = new GridViewer(this.dataSets, columnProperties, 0);
            grid.setFilterColumn(CreateGridFromDataSetAction.idColumn);
            GridDialog dialog = new GridDialog(new Shell(), grid);
            if (dialog.open() == 0) {
                return dialog.getSelected();
            }
            return null;
        }

        private String outputErrorMessage() {
            if (this.allIds == null) {
                this.allIds = new HashSet();
                CompositeMapUtil.collectAttribueValues(this.allIds, CreateGridFromDataSetAction.idColumn, this.dataSet.getRoot());
            }
            if (this.bindTarget == null || this.bindTarget.equals("")) {
                return LocaleMessage.getString("DataSet.selection.can.not.be.null");
            }
            if (this.id == null || this.id.equals("")) {
                return LocaleMessage.getString("id.can.not.be.null");
            }
            if (this.allIds.contains(this.id)) {
                return LocaleMessage.getString("This.id.has.exists.please.change.it");
            }
            return null;
        }

        private void checkDialog() {
            String errorMessage = this.outputErrorMessage();
            this.setErrorMessage(errorMessage);
            if (errorMessage != null) {
                this.setPageComplete(false);
            } else {
                this.setPageComplete(true);
            }
        }

        private CompositeMap getAvailableDataSets(CompositeMap parentCM) throws ApplicationException {
            CompositeMap dataSets = parentCM.getChild("dataSets");
            if (dataSets == null || dataSets.getChildsNotNull().size() == 0) {
                return null;
            }
            CommentCompositeMap qualifyDataSetList = new CommentCompositeMap(dataSets.getPrefix(), dataSets.getNamespaceURI(), "dataSets");
            for (CompositeMap child : dataSets.getChildsNotNull()) {
                String id = child.getString((Object)CreateGridFromDataSetAction.idColumn);
                if (id == null || "".equals(id) || CreateGridFromDataSetAction.this.getFieldsFromDS(child) == null) continue;
                qualifyDataSetList.addChild(child);
            }
            return qualifyDataSetList;
        }
    }
}

