/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.component.wizard;

import aurora.ide.AuroraPlugin;
import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.bm.BMUtil;
import aurora.ide.bm.editor.GridDialog;
import aurora.ide.celleditor.BoolCellEditor;
import aurora.ide.celleditor.CellInfo;
import aurora.ide.editor.core.IViewer;
import aurora.ide.editor.widgets.GridViewer;
import aurora.ide.editor.widgets.PropertyHashViewer;
import aurora.ide.editor.widgets.WizardPageRefreshable;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraConstant;
import aurora.ide.helpers.AuroraResourceUtil;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.helpers.ProjectUtil;
import aurora.ide.node.action.AddElementAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;

public class CreateLovFromBMAction
extends AddElementAction {
    static final String title = "\u521b\u5efaLov";

    public CreateLovFromBMAction(IViewer viewer, CompositeMap currentNode, QualifiedName childQN, int actionStyle) {
        super(viewer, currentNode, childQN, actionStyle);
    }

    public ImageDescriptor getDefaultImageDescriptor() {
        return AuroraPlugin.getImageDescriptor(LocaleMessage.getString("wizard.icon"));
    }

    public void run() {
        if (this.currentNode == null || !AuroraConstant.FieldsQN.equals((Object)this.currentNode.getQName())) {
            DialogUtil.showErrorMessageBox("\u5f53\u524d\u9009\u4e2d\u7684\u4e0d\u662fFields\u8282\u70b9!");
            return;
        }
        LovWizard wizard = new LovWizard(this.currentNode);
        WizardDialog dialog = new WizardDialog(new Shell(), (IWizard)wizard);
        dialog.open();
        boolean successful = wizard.isSuccessful();
        if (this.viewer != null && successful) {
            this.viewer.refresh(true);
        }
    }

    class FieldPage
    extends WizardPageRefreshable {
        public static final String PAGE_NAME = "FiledPage";
        private LovWizard wizard;
        private GridViewer gridViewer;
        PropertyHashViewer hashViewer;
        HashMap field_properties;

        protected FieldPage(LovWizard wizard) {
            super(PAGE_NAME);
            this.field_properties = new HashMap();
            this.setTitle("\u521b\u5efaLov--" + LocaleMessage.getString("filed.page"));
            this.wizard = wizard;
        }

        public void createControl(Composite parent) {
            Composite content = new Composite(parent, 0);
            content.setLayout((Layout)new GridLayout());
            String[] columnNames = new String[]{"name"};
            String[] columnTitles = new String[]{"\u5b57\u6bb5"};
            this.gridViewer = new GridViewer(columnNames, 450);
            this.gridViewer.setColumnTitles(columnTitles);
            try {
                this.gridViewer.createViewer(content);
                CellEditor[] celleditors = new CellEditor[columnNames.length];
                int i = 1;
                while (i < columnNames.length) {
                    CellInfo cellProperties = new CellInfo(this.gridViewer, columnNames[i], false);
                    BoolCellEditor cellEditor = new BoolCellEditor(cellProperties);
                    cellEditor.init();
                    celleditors[i] = cellEditor.getCellEditor();
                    this.gridViewer.addEditor(columnNames[i], cellEditor);
                    ++i;
                }
                this.gridViewer.setCellEditors(celleditors);
                this.gridViewer.setData(this.wizard.getBMFields());
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
            }
            this.setPageComplete(true);
            this.initPageValues();
            this.checkPageValues();
            this.setControl((Control)content);
        }

        public void refreshPage() {
            if (!this.isInit()) {
                return;
            }
        }

        public CompositeMap getSelection() {
            return this.gridViewer.getSelection();
        }

        public void checkPageValues() {
        }
    }

    class LovWizard
    extends Wizard
    implements IViewer {
        private boolean successful;
        private MainConfigPage mainConfigPage;
        private FieldPage fieldPage;
        private CompositeMap fieldsNode;

        public LovWizard(CompositeMap fieldsNode) {
            CreateLovFromBMAction.this.setText(CreateLovFromBMAction.title);
            this.fieldsNode = fieldsNode;
        }

        public void addPages() {
            this.mainConfigPage = new MainConfigPage(this, this.fieldsNode);
            this.mainConfigPage.setPageComplete(false);
            this.addPage((IWizardPage)this.mainConfigPage);
            this.fieldPage = new FieldPage(this);
            this.addPage((IWizardPage)this.fieldPage);
        }

        public boolean performFinish() {
            String prefix = CompositeMapUtil.getContextPrefix(this.fieldsNode, CreateLovFromBMAction.this.childQN);
            CreateLovFromBMAction.this.childQN.setPrefix(prefix);
            CommentCompositeMap fieldNode = new CommentCompositeMap(CreateLovFromBMAction.this.childQN.getPrefix(), CreateLovFromBMAction.this.childQN.getNameSpace(), CreateLovFromBMAction.this.childQN.getLocalName());
            fieldNode.put("name", this.mainConfigPage.getFieldNameText().getText());
            fieldNode.put("lovservice", this.mainConfigPage.getBMText().getText());
            fieldNode.put("lovHeight", this.mainConfigPage.getLovHeightText().getText());
            fieldNode.put("lovWidth", this.mainConfigPage.getLovWidthText().getText());
            fieldNode.put("lovGridHeigh", this.mainConfigPage.getLovGridHeightText().getText());
            CommentCompositeMap mappingNode = new CommentCompositeMap(CreateLovFromBMAction.this.childQN.getPrefix(), CreateLovFromBMAction.this.childQN.getNameSpace(), "mapping");
            CompositeMap fields = this.fieldPage.getSelection();
            if (fields == null || fields.getChilds() == null) {
                this.fieldPage.updatePageStatus("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5b57\u6bb5.");
                this.fieldPage.setPageComplete(true);
                return false;
            }
            Iterator it = fields.getChildIterator();
            while (it.hasNext()) {
                CompositeMap field = (CompositeMap)it.next();
                CommentCompositeMap mapNode = new CommentCompositeMap(CreateLovFromBMAction.this.childQN.getPrefix(), CreateLovFromBMAction.this.childQN.getNameSpace(), "map");
                String fieldName = field.getString((Object)"name");
                mapNode.put("from", fieldName);
                mapNode.put("to", fieldName);
                mappingNode.addChild(mapNode);
            }
            fieldNode.addChild(mappingNode);
            CompositeMapUtil.addElement(this.fieldsNode, fieldNode);
            this.successful = true;
            return true;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public void createPageControls(Composite pageContainer) {
        }

        public void refresh(boolean isDirty) {
        }

        public CompositeMap getBMFields() {
            return this.mainConfigPage.getBMFields();
        }
    }

    class MainConfigPage
    extends WizardPageRefreshable {
        public static final String PAGE_NAME = "mainPage";
        private CompositeMap bmFields;
        private Text bmText;
        private Text fieldNameText;
        private Text lovHeightText;
        private Text lovWidthText;
        private Text lovGridHeightText;

        public CompositeMap getBMFields() {
            return this.bmFields;
        }

        public Text getBMText() {
            return this.bmText;
        }

        public Text getFieldNameText() {
            return this.fieldNameText;
        }

        public Text getLovHeightText() {
            return this.lovHeightText;
        }

        public Text getLovWidthText() {
            return this.lovWidthText;
        }

        public Text getLovGridHeightText() {
            return this.lovGridHeightText;
        }

        protected MainConfigPage(IViewer parent, CompositeMap fieldsNode) {
            super(PAGE_NAME);
            this.setTitle("\u521b\u5efaLov--" + LocaleMessage.getString("mainpage"));
        }

        public boolean canFlipToNextPage() {
            if (this.bmText != null && !"".equals(this.bmText.getText()) && this.bmFields == null) {
                DialogUtil.showErrorMessageBox("\u6b64dataSet\u6ca1\u6709\u53ef\u7528\u5b57\u6bb5.");
                return false;
            }
            return super.canFlipToNextPage();
        }

        public void checkPageValues() {
            String parentBMPath = this.bmText.getText();
            if (parentBMPath == null || "".equals(parentBMPath)) {
                this.updatePageStatus("\u5fc5\u987b\u6307\u5b9a\u7236BM!");
                return;
            }
            IResource bmFile = null;
            try {
                bmFile = BMUtil.getBMResourceFromClassPath(parentBMPath);
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
            }
            if (bmFile == null) {
                this.updatePageStatus("\u6b64BM\u6587\u4ef6\u4e0d\u5b58\u5728!");
                return;
            }
            try {
                this.bmFields = BMUtil.getFieldsFromBMPath(parentBMPath);
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
            }
            if (this.bmFields == null) {
                this.updatePageStatus("\u6b64BM\u6ca1\u6709\u5b9a\u4e49field\u5b57\u6bb5.");
                return;
            }
            String fieldName = this.fieldNameText.getText();
            if (fieldName == null || fieldName.equals("")) {
                this.updatePageStatus("\u8bf7\u8f93\u5165\u5b57\u6bb5\u540d");
                return;
            }
            String lovHeightStr = this.lovHeightText.getText();
            try {
                Integer.parseInt(lovHeightStr);
            }
            catch (NumberFormatException e) {
                this.updatePageStatus("\u7a97\u53e3\u9ad8\u5ea6\u503c\u5fc5\u987b\u662f\u6570\u5b57.");
                return;
            }
            String lovWidthStr = this.lovWidthText.getText();
            try {
                Integer.parseInt(lovWidthStr);
            }
            catch (NumberFormatException e) {
                this.updatePageStatus("\u7a97\u53e3\u5bbd\u5ea6\u503c\u5fc5\u987b\u662f\u6570\u5b57.");
                return;
            }
            String lovGridHeightStr = this.lovGridHeightText.getText();
            try {
                Integer.parseInt(lovGridHeightStr);
            }
            catch (NumberFormatException e) {
                this.updatePageStatus("\u6570\u636e\u663e\u793a\u533a\u503c\u5fc5\u987b\u662f\u6570\u5b57.");
                return;
            }
            this.updatePageStatus(null);
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(3, false));
            GridData gd = new GridData(768);
            Label label = new Label(container, 0);
            label.setText("\u9009\u62e9BM");
            this.bmText = new Text(container, 2052);
            this.bmText.setLayoutData((Object)gd);
            this.bmText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MainConfigPage.this.checkPageValues();
                }
            });
            Button pickBMButton = new Button(container, 8);
            pickBMButton.setText(LocaleMessage.getString("openBrowse"));
            pickBMButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    try {
                        this.pickBM();
                    }
                    catch (ApplicationException e) {
                        DialogUtil.showExceptionMessageBox(e);
                    }
                }

                private void pickBM() throws ApplicationException {
                    String classPath;
                    IProject project = ProjectUtil.getIProjectFromSelection();
                    List bmList = ProjectUtil.getBMSFromProject(project);
                    CommentCompositeMap bms = new CommentCompositeMap("bms");
                    String[] columnNames = new String[]{"name", "fullpath"};
                    for (IResource bmFile : bmList) {
                        CommentCompositeMap child = new CommentCompositeMap("record");
                        child.put("name", bmFile.getName());
                        child.put("fullpath", AuroraResourceUtil.getRegisterPath((IFile)bmFile));
                        bms.addChild(child);
                    }
                    GridViewer grid = new GridViewer(null, 48);
                    grid.setData(bms);
                    grid.setFilterColumn("name");
                    grid.setColumnNames(columnNames);
                    GridDialog dialog = new GridDialog(new Shell(), grid);
                    if (dialog.open() == 0 && (classPath = dialog.getSelected().getString((Object)"fullpath")) != null) {
                        MainConfigPage.this.bmText.setText(classPath);
                    }
                }
            });
            label = new Label(container, 0);
            label.setText("\u5b57\u6bb5\u540d");
            this.fieldNameText = new Text(container, 2052);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.fieldNameText.setLayoutData((Object)gd);
            this.fieldNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MainConfigPage.this.checkPageValues();
                }
            });
            label = new Label(container, 0);
            label.setText("\u7a97\u53e3\u9ad8\u5ea6");
            this.lovHeightText = new Text(container, 2052);
            this.lovHeightText.setLayoutData((Object)gd);
            this.lovHeightText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MainConfigPage.this.checkPageValues();
                }
            });
            label = new Label(container, 0);
            label.setText("\u7a97\u53e3\u5bbd\u5ea6");
            this.lovWidthText = new Text(container, 2052);
            this.lovWidthText.setLayoutData((Object)gd);
            this.lovWidthText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MainConfigPage.this.checkPageValues();
                }
            });
            label = new Label(container, 0);
            label.setText("\u6570\u636e\u663e\u793a\u533a\u9ad8\u5ea6");
            this.lovGridHeightText = new Text(container, 2052);
            this.lovGridHeightText.setLayoutData((Object)gd);
            this.lovGridHeightText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MainConfigPage.this.checkPageValues();
                }
            });
            this.setControl((Control)container);
        }
    }
}

