/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage;

import aurora.ide.editor.textpage.ColorManager;
import aurora.ide.editor.textpage.IColorConstants;
import aurora.ide.editor.textpage.scanners.XMLTagScanner;
import java.util.Stack;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class XMLAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy {
    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        try {
            if ("/".equals(c.text)) {
                this.autoCloseXMLTagBySlash(d, c);
            } else {
                ">".equals(c.text);
            }
            if (c.text != null && (c.text.startsWith("\n") || c.text.startsWith("\r"))) {
                this.autoInsertChild(d, c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void autoCloseXMLTagBySlash(IDocument d, DocumentCommand c) throws Exception {
        String tagName2;
        if (c.offset <= 0 || d.getChar(c.offset - 1) != '<') {
            return;
        }
        String tagName = this.findOpeningTag(d, 0, c.offset - 1);
        if (tagName == null) {
            return;
        }
        int nextChar = c.offset;
        if (c.offset < d.getLength() && d.getChar(c.offset) == '>') {
            ++nextChar;
        }
        if (tagName.equals(tagName2 = this.findClosedTag(d, nextChar, d.getLength()))) {
            return;
        }
        c.text = "/" + tagName + (nextChar == c.offset ? ">" : "");
    }

    /*
     * Enabled aggressive block sorting
     */
    private String findOpeningTag(IDocument doc, int start, int end) throws Exception {
        ITypedRegion[] regions = doc.computePartitioning(start, end - start);
        Stack<String> tagStack = new Stack<String>();
        int i = regions.length - 1;
        while (i >= 0) {
            String type = regions[i].getType();
            String tagName = this.getTagName(doc, (IRegion)regions[i]);
            if ("XML_START_TAG".equals(type)) {
                char c = doc.getChar(regions[i].getOffset() + regions[i].getLength() - 2);
                if (c == '/') {
                    this.debug("close:" + tagName);
                } else {
                    if (tagStack.isEmpty()) {
                        this.debug("find open tag:" + tagName);
                        return tagName;
                    }
                    if (!((String)tagStack.peek()).equals(tagName)) {
                        this.debug("Unmatched tag:" + (String)tagStack.peek() + " != " + tagName);
                        return null;
                    }
                    this.debug("Pop :" + (String)tagStack.pop());
                }
            } else if ("XML_END_TAG".equals(type)) {
                this.debug("Push:" + tagName);
                if (tagName == null) {
                    return null;
                }
                tagStack.push(tagName);
            }
            --i;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String findClosedTag(IDocument doc, int start, int end) throws Exception {
        while (start < doc.getLength() && doc.getChar(start) != '<') {
            ++start;
        }
        if (start >= doc.getLength()) {
            return null;
        }
        ITypedRegion[] regions = doc.computePartitioning(start, end - start);
        Stack<String> tagStack = new Stack<String>();
        this.debug("--------");
        int i = 0;
        while (i < regions.length) {
            String type = regions[i].getType();
            String tagName = this.getTagName(doc, (IRegion)regions[i]);
            if ("XML_END_TAG".equals(type)) {
                if (tagStack.isEmpty()) {
                    this.debug("find closed tag : " + tagName);
                    return tagName;
                }
                if (!((String)tagStack.peek()).equals(tagName)) {
                    this.debug("Unmatched tag:" + (String)tagStack.peek() + " != " + tagName);
                    return null;
                }
                this.debug("Pop :" + (String)tagStack.pop());
            } else if ("XML_START_TAG".equals(type)) {
                char c = doc.getChar(regions[i].getOffset() + 1);
                if (c == '/') {
                    this.debug("xxx find closed tag:" + tagName);
                    return tagName;
                }
                c = doc.getChar(regions[i].getOffset() + regions[i].getLength() - 2);
                if (c == '/') {
                    this.debug("close:" + tagName);
                } else {
                    this.debug("Push:" + tagName);
                    if (tagName == null) {
                        return null;
                    }
                    tagStack.push(tagName);
                }
            }
            ++i;
        }
        return null;
    }

    private String getTagName(IDocument doc, IRegion region) throws Exception {
        XMLTagScanner scanner = new XMLTagScanner(new ColorManager());
        scanner.setRange(doc, region.getOffset(), region.getLength());
        IToken token = Token.EOF;
        while ((token = scanner.nextToken()) != Token.EOF) {
            if (!(token.getData() instanceof TextAttribute)) continue;
            TextAttribute text = (TextAttribute)token.getData();
            int tokenOffset = scanner.getTokenOffset();
            int tokenLength = scanner.getTokenLength();
            if (!text.getForeground().getRGB().equals((Object)IColorConstants.TAG_NAME)) continue;
            return doc.get(tokenOffset, tokenLength);
        }
        return null;
    }

    protected void autoCloseXMLTagByGt(IDocument d, DocumentCommand c) throws Exception {
        char ch;
        if (c.offset < 2) {
            return;
        }
        if (d.getChar(c.offset - 1) == '<') {
            this.debug("empty tag.");
            return;
        }
        int ltIndex = c.offset - 1;
        while (ltIndex >= 0 && (ch = d.getChar(ltIndex)) != '<') {
            if (ch == '>' || ch == '/') {
                this.debug("invalid char '" + ch + "' before '<'.");
                return;
            }
            --ltIndex;
        }
        if (ltIndex < 0) {
            this.debug("'<' not found.");
            return;
        }
        String tagName = this.getTagName(d, (IRegion)new Region(ltIndex, c.offset - ltIndex));
        if (tagName == null) {
            this.debug("tagName not found.");
            return;
        }
        this.debug("find tagName:" + tagName);
        String restStr = d.get(c.offset, d.getLength() - c.offset);
        if (restStr == null || restStr.trim().length() == 0) {
            this.debug("nothing after caretOffset , close directly.");
            d.replace(c.offset, 0, "></" + tagName + ">");
            ++c.offset;
            c.text = "";
            return;
        }
        int endTagIndex = restStr.indexOf("</" + tagName + ">");
        if (endTagIndex == -1) {
            endTagIndex = restStr.indexOf("</" + tagName + " ");
        }
        if (endTagIndex == -1) {
            this.debug("no end-tag after caretOffset , close directly.");
            d.replace(c.offset, 0, "></" + tagName + ">");
            ++c.offset;
            c.text = "";
            return;
        }
        String ws = d.get(c.offset, endTagIndex);
        if (ws.trim().length() == 0) {
            this.debug("there already has a end-tag ,do nothing.");
            return;
        }
        restStr = d.get(c.offset, endTagIndex);
        int lti1 = restStr.indexOf(60);
        int gti1 = restStr.indexOf(62);
        if (lti1 != -1 && gti1 > lti1) {
            this.debug("a new tag appear before end-tag , end-tag invalid , close directly." + lti1 + " " + gti1);
            d.replace(c.offset, 0, "></" + tagName + ">");
            ++c.offset;
            c.text = "";
            return;
        }
        if (lti1 != -1) {
            this.debug("there is a new '<' after caretOffset.");
            return;
        }
        if (gti1 != -1) {
            this.debug("there is a '>' after caretOffset.");
            return;
        }
    }

    protected void autoInsertChild(IDocument d, DocumentCommand c) {
        if (c.offset > d.getLength() - 2) {
            return;
        }
        try {
            if (!"/>".equals(d.get(c.offset, 2))) {
                return;
            }
            ITypedRegion region = d.getPartition(c.offset);
            if (!"XML_START_TAG".equals(region.getType())) {
                return;
            }
            String tagName = this.getTagName(d, (IRegion)region);
            if (tagName == null) {
                tagName = "";
            }
            String format = ">%s%s%s</%s>";
            boolean isTextTag = tagName.toLowerCase().matches(".*((script)|(sql)|(style)|(freemarker)).*");
            if (isTextTag) {
                format = "><![CDATA[%s%s%s]]></%s>";
            }
            String resp = String.format(format, c.text, "    ", c.text, tagName);
            d.replace(c.offset, 2, resp);
            c.offset = c.offset + (resp.length() - (3 + tagName.length() + c.text.length() + (isTextTag ? 3 : 0)));
            c.text = "";
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void debug(Object o) {
    }
}

