/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.action;

import aurora.ide.editor.textpage.TextPage;
import aurora.ide.helpers.DialogUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class AnnotateSeletionAction
implements IEditorActionDelegate {
    IEditorPart activeEditor;
    ISelection selection;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.activeEditor = targetEditor;
    }

    public void run(IAction action) {
        if (this.activeEditor == null || !(this.activeEditor instanceof TextPage)) {
            DialogUtil.showErrorMessageBox("\u8fd9\u4e2a\u7c7b\u4e0d\u662f" + TextPage.class.getName());
            return;
        }
        TextPage tp = (TextPage)this.activeEditor;
        IDocument document = tp.getInputDocument();
        if (!(this.selection instanceof ITextSelection)) {
            return;
        }
        ITextSelection ts = (ITextSelection)this.selection;
        String content = ts.getText();
        if ("".equals(content)) {
            return;
        }
        try {
            ITypedRegion partitionRegion = document.getPartition(ts.getOffset());
            if ("XML_CDATA".equals(partitionRegion.getType())) {
                content = "/*" + content + "*/";
            } else if ("XML_START_TAG".equals(partitionRegion.getType()) || "__dftl_partition_content_type".equals(partitionRegion.getType())) {
                content = "<!--" + content + "-->";
            }
            document.replace(ts.getOffset(), ts.getLength(), content);
        }
        catch (BadLocationException e) {
            DialogUtil.logErrorException(e);
            return;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

