/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.action;

import aurora.ide.api.composite.map.CommentXMLOutputter;
import aurora.ide.editor.textpage.TextPage;
import aurora.ide.helpers.AuroraResourceUtil;
import aurora.ide.helpers.DialogUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;

public class FormatAction
implements IEditorActionDelegate {
    IEditorPart activeEditor;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.activeEditor = targetEditor;
    }

    public void run(IAction action) {
        int cursorLine;
        IDocument document;
        TextPage tp;
        block23: {
            if (this.activeEditor == null || !(this.activeEditor instanceof TextPage)) {
                DialogUtil.showErrorMessageBox("\u8fd9\u4e2a\u7c7b\u4e0d\u662f" + TextPage.class.getName());
                return;
            }
            tp = (TextPage)this.activeEditor;
            IFile file = tp.getFile();
            document = tp.getInputDocument();
            String content = document.get();
            if (content == null) {
                return;
            }
            cursorLine = tp.getCursorLine();
            CompositeLoader cl = AuroraResourceUtil.getCompsiteLoader();
            InputStream is = null;
            try {
                is = new ByteArrayInputStream(content.getBytes("UTF-8"));
                CompositeMap data = cl.loadFromStream(is);
                String formatContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + CommentXMLOutputter.defaultInstance().toXML(data, true);
                tp.refresh(formatContent);
            }
            catch (IOException e) {
                DialogUtil.logErrorException("\u89e3\u6790" + file.getFullPath().toOSString() + "\u9519\u8bef\uff01", e);
                try {
                    if (is != null) {
                        is.close();
                    }
                    break block23;
                }
                catch (IOException e2) {
                    DialogUtil.logErrorException("\u5173\u95ed" + is + "\u9519\u8bef\uff01", e2);
                }
                break block23;
            }
            catch (SAXException e) {
                try {
                    DialogUtil.logErrorException("\u89e3\u6790" + file.getFullPath().toOSString() + "\u9519\u8bef\uff01", e);
                    break block23;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e3) {
                        DialogUtil.logErrorException("\u5173\u95ed" + is + "\u9519\u8bef\uff01", e3);
                    }
                }
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                DialogUtil.logErrorException("\u5173\u95ed" + is + "\u9519\u8bef\uff01", e);
            }
        }
        document = tp.getInputDocument();
        try {
            int offset = document.getLineOffset(cursorLine);
            int length = document.getLineLength(cursorLine);
            if (offset == 0 || length == 0) {
                return;
            }
            tp.setHighlightRange(offset, length, true);
        }
        catch (BadLocationException e) {
            DialogUtil.logErrorException(e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

