/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.action;

import aurora.ide.api.composite.map.Comment;
import aurora.ide.freemarker.FMFunctionRegisterSqlConfigration;
import aurora.ide.freemarker.FreeMarkerGenerator;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.FileUtil;
import aurora.ide.helpers.PathUtil;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterSql {
    private StringBuilder pageRegisterSql = new StringBuilder();
    private static final String PAGE_REGISTER = "#PAGE_REGISTER#";
    private static final String PAGE_PATH = "#PAGE_PATH#";
    private static final String PAGE_NAME = "#PAGE_NAME#";
    private static final String PAGE_REGISTER_SQL = "sys_service_pkg.sys_service_load('#PAGE_PATH#','#PAGE_NAME#',1,1,0);";
    private StringBuilder functionRegisterSql = new StringBuilder();
    private static final String MODULE_REGISTER = "#MODULE_REGISTER#";
    private static final String FUNCTION_REGISTER = "#FUNCTION_REGISTER#";
    private static final String MODULE_CODE = "#MODULE_CODE#";
    private static final String MODULE_NAME = "#MODULE_NAME#";
    private static final String FUNCTION_CODE = "#FUNCTION_CODE#";
    private static final String FUNCTION_NAME = "#FUNCTION_NAME#";
    private static final String FUNCTION_ORDER = "#FUNCTION_ORDER#";
    private static final String HOST_PATH = "#HOST_PATH#";
    private static final String MODULE_REGISTER_SQL = "sys_function_pkg.sys_function_load('#MODULE_CODE#','#MODULE_NAME#','','G','','','','ZHS');";
    private static final String FUNCTION_REGISTER_SQL = "sys_function_pkg.sys_function_load('#FUNCTION_CODE#','#FUNCTION_NAME#','#MODULE_CODE#','F','#HOST_PATH#','#FUNCTION_ORDER#','','ZHS');";
    private StringBuilder serviceRegisterSql = new StringBuilder();
    private static final String LOAD_SERVICE = "#LOAD_SERVICE#";
    private static final String LOAD_SERVICE_SQL = "sys_function_service_pkg.load_service('#HOST_PATH#','#PAGE_PATH#');";
    private StringBuilder bmRegisterSql = new StringBuilder();
    private static final String REGISTER_BM = "#REGISTER_BM#";
    private static final String BM_PATH = "#BM_PATH#";
    private static final String REGISTER_BM_SQL = "sys_register_bm_pkg.register_bm('#HOST_PATH#','#BM_PATH#');";
    private String functionCode;
    private String functionName;
    private String functionOrder;
    private String modulesCode;
    private String modulesName;
    private IFile hostPage;
    private String hostPath;
    private String resultString;

    public RegisterSql(String functionCode, String functionName, String functionOrder, String modulesCode, String modulesName, IFile hostPage) {
        this.functionCode = functionCode;
        this.functionName = functionName;
        this.functionOrder = functionOrder;
        this.modulesCode = modulesCode;
        this.modulesName = modulesName;
        this.hostPage = hostPage;
        this.hostPath = PathUtil.getPathInScreen(hostPage);
    }

    public RegisterSql() {
    }

    public String build(List<IFile> files) throws IOException, SAXException, TemplateException {
        FMFunctionRegisterSqlConfigration config = new FMFunctionRegisterSqlConfigration();
        Template template = config.getTemplate();
        FreeMarkerGenerator fg = new FreeMarkerGenerator();
        HashMap root = new HashMap();
        HashMap<String, String> module = new HashMap<String, String>();
        module.put("module_code", this.modulesCode == null ? "" : this.modulesCode);
        module.put("module_name", this.modulesName == null ? "" : this.modulesName);
        root.put("module", module);
        HashMap<String, String> function = new HashMap<String, String>();
        function.put("function_name", this.functionName == null ? "" : this.functionName);
        function.put("function_code", this.functionCode == null ? "" : this.functionCode);
        function.put("host_path", this.hostPath == null ? "" : this.hostPath);
        function.put("function_order", this.functionOrder == null ? "" : this.functionOrder);
        root.put("function", function);
        DefaultObjectWrapper dow = new DefaultObjectWrapper();
        ArrayList<ScreenPage> pages = new ArrayList<ScreenPage>();
        ArrayList<Model> models = new ArrayList<Model>();
        for (IFile f : files) {
            String fileExtension = f.getFileExtension();
            if ("screen".equalsIgnoreCase(fileExtension) || "svc".equalsIgnoreCase(fileExtension)) {
                Object object;
                String pagePath = PathUtil.getPathInScreen(f);
                Comment fileComment = CompositeMapUtil.getFileComment(f);
                String pageName = f.getProjectRelativePath().removeFileExtension().lastSegment();
                if (fileComment != null && (object = fileComment.get("pagename")) != null && !"".equals(object)) {
                    pageName = object.toString();
                }
                ScreenPage p = new ScreenPage(pagePath, pageName);
                pages.add(p);
            }
            if (!"bm".equalsIgnoreCase(fileExtension)) continue;
            String bmPath = PathUtil.getPathInScreen(f);
            Model m = new Model(bmPath);
            models.add(m);
        }
        root.put("pages", dow.wrap(pages));
        root.put("models", dow.wrap(models));
        return fg.gen(template, root);
    }

    public static Map createTempConfig() throws TemplateModelException {
        HashMap root = new HashMap();
        HashMap<String, String> module = new HashMap<String, String>();
        module.put("module_code", "modulesCode");
        module.put("module_name", "modulesName");
        root.put("module", module);
        HashMap<String, String> function = new HashMap<String, String>();
        function.put("function_name", "functionName");
        function.put("function_code", "functionCode");
        function.put("host_path", "hostPath");
        function.put("function_order", "functionOrder");
        root.put("function", function);
        DefaultObjectWrapper dow = new DefaultObjectWrapper();
        ArrayList<ScreenPage> pages = new ArrayList<ScreenPage>();
        ArrayList<Model> models = new ArrayList<Model>();
        RegisterSql registerSql = new RegisterSql();
        registerSql.getClass();
        ScreenPage p = registerSql.new ScreenPage("pagePath", "pageName");
        pages.add(p);
        RegisterSql registerSql2 = new RegisterSql();
        registerSql2.getClass();
        Model m = registerSql2.new Model("bmPath");
        models.add(m);
        root.put("pages", dow.wrap(pages));
        root.put("models", dow.wrap(models));
        return root;
    }

    private String old(List<IFile> files) {
        String moduleRegisterSql = MODULE_REGISTER_SQL.replace(MODULE_CODE, this.modulesCode).replace(MODULE_NAME, this.modulesName);
        this.functionRegisterSql = this.functionRegisterSql.append(moduleRegisterSql).append("\n");
        String fRegisterSql = FUNCTION_REGISTER_SQL.replace(FUNCTION_CODE, this.functionCode).replace(FUNCTION_NAME, this.functionName).replace(MODULE_CODE, this.modulesCode).replace(HOST_PATH, this.hostPath).replace(FUNCTION_ORDER, this.functionOrder);
        this.functionRegisterSql = this.functionRegisterSql.append(fRegisterSql).append("\n");
        InputStream resourceAsStream = this.getClass().getResourceAsStream("functionRegister.sql");
        this.resultString = FileUtil.readStringFile(resourceAsStream).toString();
        for (IFile f : files) {
            String fileExtension = f.getFileExtension();
            if ("screen".equalsIgnoreCase(fileExtension) || "svc".equalsIgnoreCase(fileExtension)) {
                Object object;
                String pagePath = PathUtil.getPathInScreen(f);
                Comment fileComment = CompositeMapUtil.getFileComment(f);
                String pageName = f.getProjectRelativePath().removeFileExtension().lastSegment();
                if (fileComment != null && (object = fileComment.get("pagename")) != null && !"".equals(object)) {
                    pageName = object.toString();
                }
                String pSql = PAGE_REGISTER_SQL.replace(PAGE_PATH, pagePath).replace(PAGE_NAME, pageName);
                this.pageRegisterSql = this.pageRegisterSql.append(pSql).append("\n");
                String lSql = LOAD_SERVICE_SQL.replace(HOST_PATH, this.hostPath).replace(PAGE_PATH, pagePath);
                this.serviceRegisterSql = this.serviceRegisterSql.append(lSql).append("\n");
            }
            if (!"bm".equalsIgnoreCase(fileExtension)) continue;
            String bmPath = PathUtil.getPathInScreen(f);
            String sql = REGISTER_BM_SQL.replace(HOST_PATH, this.hostPath).replace(BM_PATH, bmPath);
            this.bmRegisterSql = this.bmRegisterSql.append(sql).append("\n");
        }
        this.resultString = this.resultString.replace(PAGE_REGISTER, this.pageRegisterSql.toString()).replace(MODULE_REGISTER, this.functionRegisterSql.toString()).replace(LOAD_SERVICE, this.serviceRegisterSql.toString()).replace(REGISTER_BM, this.bmRegisterSql.toString());
        return this.resultString;
    }

    private class Model
    implements TemplateHashModel {
        DefaultObjectWrapper dow = new DefaultObjectWrapper();
        private String bm_path;

        private Model(String bm_path) {
            this.bm_path = bm_path == null ? "" : bm_path;
        }

        public TemplateModel get(String arg) throws TemplateModelException {
            if ("bm_path".equals(arg)) {
                return this.dow.wrap((Object)this.bm_path);
            }
            return null;
        }

        public boolean isEmpty() throws TemplateModelException {
            return false;
        }
    }

    private class ScreenPage
    implements TemplateHashModel {
        DefaultObjectWrapper dow = new DefaultObjectWrapper();
        private String page_path;
        private String page_name;

        private ScreenPage(String page_path, String page_name) {
            this.page_name = page_name == null ? "" : page_name;
            this.page_path = page_path == null ? "" : page_path;
        }

        public TemplateModel get(String arg) throws TemplateModelException {
            if ("page_path".equals(arg)) {
                return this.dow.wrap((Object)this.page_path);
            }
            if ("page_name".equals(arg)) {
                return this.dow.wrap((Object)this.page_name);
            }
            return null;
        }

        public boolean isEmpty() throws TemplateModelException {
            return false;
        }
    }
}

