/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.hyperlinks;

import aurora.ide.AuroraPlugin;
import aurora.ide.bm.BMUtil;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.DialogUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class BMFileHyperlink
implements IHyperlink {
    private IRegion region;
    private ITextViewer viewer;

    public BMFileHyperlink(IRegion region, ITextViewer viewer) {
        this.region = region;
        this.viewer = viewer;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        return null;
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        IDocument doc = this.viewer.getDocument();
        try {
            String classPath = doc.get(this.region.getOffset(), this.region.getLength());
            IResource file = BMUtil.getBMResourceFromClassPath(classPath);
            if (file == null) {
                file = BMUtil.getBMResourceFromClassPath(classPath, "xml");
            }
            if (file == null) {
                return;
            }
            if (!(file instanceof IFile)) {
                DialogUtil.showErrorMessageBox("\u8d44\u6e90" + file + "\u4e0d\u662f\u4e00\u4e2a\u6587\u4ef6\u7c7b\u578b");
                return;
            }
            if (file.exists()) {
                IDE.openEditor((IWorkbenchPage)AuroraPlugin.getActivePage(), (IFile)((IFile)file));
            }
        }
        catch (BadLocationException e) {
            DialogUtil.logErrorException(e);
        }
        catch (ApplicationException e) {
            DialogUtil.showExceptionMessageBox(e);
        }
        catch (PartInitException e) {
            DialogUtil.logErrorException(e);
        }
    }
}

