/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.js.validate;

import aurora.ide.editor.textpage.js.validate.AnnotationReporter;
import aurora.ide.search.core.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavascriptValidator {
    private ErrorReporter errorReporter;
    private static Script fulljslintScript;

    public JavascriptValidator(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    /*
     * Loose catch block
     */
    public void validate(String name, String source) {
        Context cx = Context.enter();
        ScriptableObject scope = cx.initStandardObjects();
        cx.setErrorReporter(this.errorReporter);
        try {
            try {
                source = Util.convertJS(source);
                cx.compileString(source, name, 0, null);
                WarningReporter warningReporter = new WarningReporter();
                scope.put("meReport", (Scriptable)scope, (Object)warningReporter);
                scope.put("scriptText", (Scriptable)scope, (Object)source);
                Object eval = this.getScript().exec(cx, (Scriptable)scope);
                if ("$ME_JS_ERROR".equals(eval)) {
                    String reason = warningReporter.reason.trim();
                    if (reason == null || !"Expected an identifier and instead saw 'debugger'.".equals(reason)) {
                        ((AnnotationReporter)this.errorReporter).warning(warningReporter.reason, name, warningReporter.line - 1, warningReporter.evidence, warningReporter.character);
                    }
                } else {
                    boolean cfr_ignored_0 = eval instanceof String;
                }
            }
            catch (EvaluatorException warningReporter) {
                Context.exit();
            }
            catch (IOException warningReporter) {
                Context.exit();
            }
            catch (Exception e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                Context.exit();
            }
        }
        finally {
            Context.exit();
        }
    }

    public final Script getScript() throws IOException {
        if (fulljslintScript == null) {
            InputStream resourceAsStream = null;
            Context cx = Context.enter();
            try {
                resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("js/fulljslint.js");
                InputStreamReader osw = new InputStreamReader(resourceAsStream);
                fulljslintScript = cx.compileReader((Reader)osw, "JS lint", 1, null);
            }
            finally {
                Context.exit();
                if (resourceAsStream != null) {
                    resourceAsStream.close();
                }
            }
        }
        return fulljslintScript;
    }

    public class WarningReporter {
        public int character;
        public String evidence;
        public int line;
        public String reason;
    }
}

