/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.quickfix;

import aurora.ide.editor.textpage.quickfix.CompletionProposalCreator;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.CompositeMapUtil;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import uncertain.composite.CompositeMap;

public class QuickAssistProcessor
implements IQuickAssistProcessor {
    private static String[] fixableMarkerType = new String[]{"aurora.ide.undefinedAttribute", "aurora.ide.undefinedDataSet"};

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return true;
    }

    public boolean canFix(Annotation annotation) {
        if (!(annotation instanceof MarkerAnnotation)) {
            return false;
        }
        MarkerAnnotation ma = (MarkerAnnotation)annotation;
        String[] stringArray = fixableMarkerType;
        int n = fixableMarkerType.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker;
            String s;
            block6: {
                s = stringArray[n2];
                marker = ma.getMarker();
                if (marker != null) break block6;
                return false;
            }
            try {
                if (s.equals(marker.getType())) {
                    return true;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return true;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        ISourceViewer viewer = invocationContext.getSourceViewer();
        IAnnotationModel am = viewer.getAnnotationModel();
        Iterator itr = am.getAnnotationIterator();
        MarkerAnnotation anno = null;
        while (itr.hasNext()) {
            Position p;
            Annotation a = (Annotation)itr.next();
            if (!(a instanceof MarkerAnnotation) || !(p = am.getPosition(a)).includes(invocationContext.getOffset())) continue;
            anno = (MarkerAnnotation)a;
            break;
        }
        if (anno == null || !this.canFix((Annotation)anno)) {
            return null;
        }
        IDocument doc = viewer.getDocument();
        CompositeMap rootMap = null;
        try {
            rootMap = CompositeMapUtil.loaderFromString(doc.get());
        }
        catch (ApplicationException e3) {
            e3.printStackTrace();
            return null;
        }
        IMarker marker = anno.getMarker();
        return new CompletionProposalCreator(doc, rootMap, marker).getCompletionProposal();
    }

    public String getErrorMessage() {
        return "\u672a\u627e\u5230\u5e2e\u52a9\u4fe1\u606f";
    }
}

