/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.widgets;

import aurora.ide.celleditor.ICellEditor;
import aurora.ide.editor.widgets.GridViewer;
import aurora.ide.editor.widgets.core.ICellModifierListener;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.ExceptionUtil;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;
import uncertain.composite.CompositeMap;

public class GridCellModifier
implements ICellModifier {
    protected GridViewer viewer;
    private ArrayList listeners = new ArrayList();

    public GridCellModifier(GridViewer viewer) {
        this.viewer = viewer;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        ICellEditor cellEditor;
        if (element == null) {
            return "";
        }
        CompositeMap data = (CompositeMap)element;
        String value = data.getString((Object)property);
        if (value == null) {
            value = "";
            data.put((Object)property, (Object)value);
        }
        if ((cellEditor = this.viewer.getCellEditor(property)) != null) {
            Object returnValue = cellEditor.valueToShow(value);
            return returnValue;
        }
        return value;
    }

    public void modify(Object element, String property, Object value) {
        ICellEditor cellEditor = this.viewer.getCellEditor(property);
        if (cellEditor != null) {
            value = cellEditor.getSelection();
        }
        TableItem item = (TableItem)element;
        Object o = item.getData();
        CompositeMap data = (CompositeMap)o;
        Object oldValue = data.get((Object)property);
        try {
            this.noticeListeners(data, property, value);
        }
        catch (Exception e) {
            DialogUtil.showErrorMessageBox(ExceptionUtil.getExceptionTraceMessage(e));
            return;
        }
        if (oldValue == null) {
            oldValue = "";
        }
        if (oldValue == null || !oldValue.equals(value)) {
            data.put((Object)property, value);
            this.viewer.refresh(true);
        }
        if (value == null || value.equals("")) {
            data.remove((Object)property);
        }
    }

    public void addCellModifierListener(ICellModifierListener listener) {
        this.listeners.add(listener);
    }

    public void removeCellModifierListener(ICellModifierListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private void noticeListeners(CompositeMap record, String property, Object value) {
        if (this.listeners.size() == 0) {
            return;
        }
        for (ICellModifierListener listener : this.listeners) {
            String newValue = value == null ? null : value.toString();
            listener.modify(record, property, newValue);
        }
    }
}

