/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.widgets;

import aurora.ide.helpers.LocaleMessage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class ListElementsExchangeDialog {
    private String dialogTitle;
    private String leftGroupTitle;
    private String rightGroupTitle;
    private String[] leftItems;
    private String[] rightItems;
    private List leftList;
    private List rightList;
    Shell shell;
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private int result;

    public ListElementsExchangeDialog(Shell shell, String dialogTitle, String leftGroupTitle, String rightGroupTitle, String[] leftItems, String[] rightItems) {
        this.shell = shell;
        this.dialogTitle = dialogTitle;
        this.leftGroupTitle = leftGroupTitle;
        this.rightGroupTitle = rightGroupTitle;
        this.leftItems = leftItems;
        this.rightItems = rightItems;
    }

    public ListElementsExchangeDialog(String dialogTitle, String leftGroupTitle, String rightGroupTitle, String[] leftItems, String[] rightItems) {
        this.dialogTitle = dialogTitle;
        this.leftGroupTitle = leftGroupTitle;
        this.rightGroupTitle = rightGroupTitle;
        this.leftItems = leftItems;
        this.rightItems = rightItems;
    }

    public int open() {
        this.result = 1;
        if (this.shell == null) {
            this.shell = new Shell(68832);
        }
        GridLayout gridLayout = new GridLayout();
        this.shell.setLayout((Layout)gridLayout);
        if (this.dialogTitle != null) {
            this.shell.setText(this.dialogTitle);
        }
        Group mainGroup = new Group((Composite)this.shell, 0);
        GridData gridData = new GridData(4, 4, true, true);
        mainGroup.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 8;
        mainGroup.setLayout((Layout)gridLayout);
        Group leftGroup = new Group((Composite)mainGroup, 0);
        if (this.leftGroupTitle != null) {
            leftGroup.setText(this.leftGroupTitle);
        }
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 3;
        leftGroup.setLayoutData((Object)gridData);
        leftGroup.setLayout((Layout)new FillLayout());
        this.leftList = new List((Composite)leftGroup, 514);
        Group actionGroup = new Group((Composite)mainGroup, 0);
        gridData = new GridData(4, 4, false, true);
        gridData.horizontalSpan = 2;
        actionGroup.setLayoutData((Object)gridData);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = false;
        rowLayout.pack = false;
        rowLayout.justify = false;
        rowLayout.type = 512;
        rowLayout.marginLeft = 10;
        rowLayout.marginTop = 80;
        rowLayout.marginRight = 10;
        rowLayout.marginBottom = 80;
        rowLayout.spacing = 5;
        actionGroup.setLayout((Layout)rowLayout);
        if (this.leftItems != null) {
            this.leftList.setItems(this.leftItems);
        }
        Button toRightAll = new Button((Composite)actionGroup, 0);
        toRightAll.setText("=>");
        Button toRight = new Button((Composite)actionGroup, 0);
        toRight.setText("->");
        Button toleft = new Button((Composite)actionGroup, 0);
        toleft.setText("<-");
        Button toleftAll = new Button((Composite)actionGroup, 0);
        toleftAll.setText("<=");
        Group rightGroup = new Group((Composite)mainGroup, 0);
        if (this.rightGroupTitle != null) {
            rightGroup.setText(this.rightGroupTitle);
        }
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 3;
        rightGroup.setLayoutData((Object)gridData);
        rightGroup.setLayout((Layout)new FillLayout());
        this.rightList = new List((Composite)rightGroup, 2562);
        if (this.rightItems != null) {
            this.rightList.setItems(this.rightItems);
        }
        Group buttonGroup = new Group((Composite)this.shell, 0);
        gridData = new GridData(3, 4, false, false);
        buttonGroup.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        buttonGroup.setLayout((Layout)gridLayout);
        Button cancel = new Button((Composite)buttonGroup, 8);
        cancel.setText(LocaleMessage.getString("Cancel"));
        gridData = new GridData(3, 2, false, false);
        cancel.setLayoutData((Object)gridData);
        Button enter = new Button((Composite)buttonGroup, 8);
        enter.setText(LocaleMessage.getString("OK"));
        gridData = new GridData(3, 2, false, false);
        enter.setLayoutData((Object)gridData);
        toRightAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int oldLength = ListElementsExchangeDialog.this.rightList.getItems().length;
                String[] newItems = ListElementsExchangeDialog.joinItems(ListElementsExchangeDialog.this.rightList.getItems(), ListElementsExchangeDialog.this.leftList.getItems());
                ListElementsExchangeDialog.this.rightList.setItems(newItems);
                ListElementsExchangeDialog.this.rightList.setSelection(oldLength, newItems.length);
                ListElementsExchangeDialog.this.leftList.removeAll();
            }
        });
        toRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int oldLength = ListElementsExchangeDialog.this.rightList.getItems().length;
                String[] newItems = ListElementsExchangeDialog.joinItems(ListElementsExchangeDialog.this.rightList.getItems(), ListElementsExchangeDialog.this.leftList.getSelection());
                ListElementsExchangeDialog.this.rightList.setItems(newItems);
                ListElementsExchangeDialog.this.rightList.setSelection(oldLength, newItems.length);
                ListElementsExchangeDialog.this.leftList.remove(ListElementsExchangeDialog.this.leftList.getSelectionIndices());
            }
        });
        toleft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int oldLength = ListElementsExchangeDialog.this.leftList.getItems().length;
                String[] newItems = ListElementsExchangeDialog.joinItems(ListElementsExchangeDialog.this.leftList.getItems(), ListElementsExchangeDialog.this.rightList.getSelection());
                ListElementsExchangeDialog.this.leftList.setItems(newItems);
                ListElementsExchangeDialog.this.leftList.setSelection(oldLength, newItems.length);
                ListElementsExchangeDialog.this.rightList.remove(ListElementsExchangeDialog.this.rightList.getSelectionIndices());
            }
        });
        toleftAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int oldLength = ListElementsExchangeDialog.this.leftList.getItems().length;
                String[] newItems = ListElementsExchangeDialog.joinItems(ListElementsExchangeDialog.this.leftList.getItems(), ListElementsExchangeDialog.this.rightList.getItems());
                ListElementsExchangeDialog.this.leftList.setItems(newItems);
                ListElementsExchangeDialog.this.leftList.setSelection(oldLength, newItems.length);
                ListElementsExchangeDialog.this.rightList.removeAll();
            }
        });
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ListElementsExchangeDialog.this.shell.close();
                ListElementsExchangeDialog.this.result = 1;
            }
        });
        enter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ListElementsExchangeDialog.this.shell.close();
                ListElementsExchangeDialog.this.result = 0;
            }
        });
        this.shell.open();
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ListElementsExchangeDialog.this.leftItems = ListElementsExchangeDialog.this.leftList.getItems();
                ListElementsExchangeDialog.this.rightItems = ListElementsExchangeDialog.this.rightList.getItems();
            }
        });
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        String[] ITEMS = new String[]{"Alpha", "Bravo", "Charlie", "Delta", "Echo", "Foxtrot", "Golf"};
        new ListElementsExchangeDialog(shell, "Dialog", "left ", "right", ITEMS, ITEMS).open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public static String[] joinItems(String[] left, String[] right) {
        String[] result = new String[left.length + right.length];
        int resultIndex = 0;
        int i = 0;
        while (i < left.length) {
            result[resultIndex++] = left[i];
            ++i;
        }
        i = 0;
        while (i < right.length) {
            result[resultIndex++] = right[i];
            ++i;
        }
        return result;
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    public String getLeftGroupTitle() {
        return this.leftGroupTitle;
    }

    public void setLeftGroupTitle(String leftGroupTitle) {
        this.leftGroupTitle = leftGroupTitle;
    }

    public String getRightGroupTitle() {
        return this.rightGroupTitle;
    }

    public void setRightGroupTitle(String rightGroupTitle) {
        this.rightGroupTitle = rightGroupTitle;
    }

    public String[] getLeftItems() {
        return this.leftItems;
    }

    public void setLeftItems(String[] leftItems) {
        this.leftItems = leftItems;
    }

    public String[] getRightItems() {
        return this.rightItems;
    }

    public void setRightItems(String[] rightItems) {
        this.rightItems = rightItems;
    }
}

