/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.widgets;

import aurora.ide.celleditor.ICellEditor;
import aurora.ide.editor.widgets.GridViewer;
import aurora.ide.editor.widgets.core.IGridLabelProvider;
import aurora.ide.helpers.ImagesUtils;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import uncertain.composite.CompositeMap;

public class PropertyGridLabelProvider
extends BaseLabelProvider
implements IGridLabelProvider,
ITableColorProvider {
    int nodeIndex;
    int nodeCount;
    String[] gridPropties;
    private GridViewer viewer;
    private int rowNum = 0;
    private Color COLOR_ODD = new Color(null, 245, 255, 255);
    private Color COLOR_EVEN = new Color(null, 255, 255, 255);

    public PropertyGridLabelProvider(String[] gridPropties, GridViewer viewer) {
        this.gridPropties = gridPropties;
        this.viewer = viewer;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        return element.toString();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return null;
        }
        if (this.gridPropties == null || this.gridPropties.length == 0) {
            return null;
        }
        ICellEditor cellEditor = this.viewer.getCellEditor(this.gridPropties[columnIndex - 1]);
        if (cellEditor != null && cellEditor instanceof CheckboxCellEditor) {
            CompositeMap data = (CompositeMap)element;
            String returnValue = data.getString((Object)this.gridPropties[columnIndex - 1]);
            if (returnValue != null && returnValue.equals("true")) {
                return ImagesUtils.getImage("checked.gif");
            }
            return ImagesUtils.getImage("unchecked.gif");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        CompositeMap data = (CompositeMap)element;
        int nowCount = data.getParent().getChildsNotNull().size();
        if (nowCount != this.nodeCount) {
            this.nodeCount = nowCount;
            this.nodeIndex = 0;
        }
        if (columnIndex == 0) {
            if ((this.viewer.getGridStyle() & 0x80) != 0) {
                return "";
            }
            return String.valueOf(++this.nodeIndex);
        }
        if (this.gridPropties == null || this.gridPropties.length == 0) {
            return null;
        }
        String attrName = this.gridPropties[columnIndex - 1];
        ICellEditor cellEditor = this.viewer.getCellEditor(attrName);
        String returnValue = data.getString((Object)attrName);
        if (cellEditor != null && returnValue != null) {
            cellEditor.SetSelection(returnValue);
        }
        return returnValue;
    }

    public void refresh() {
        this.nodeIndex = 0;
    }

    public Color getBackground(Object element, int columnIndex) {
        if (columnIndex == 0) {
            this.rowNum = this.rowNum % 2 == 0 ? ++this.rowNum : --this.rowNum;
        }
        return this.rowNum == 0 ? this.COLOR_EVEN : this.COLOR_ODD;
    }

    public Color getForeground(Object element, int columnIndex) {
        return null;
    }
}

